/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.script.Function;

public class NUMTO
extends AbstractFunction {
    static final String[] CHINESE_NUMBER = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    static final String[] CHINESE_NUMBER_LEVEL_STR = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u4ebf"};
    static final long[] CHINESE_NUMBER_LEVEL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000000L};

    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        Object object = objectArray[0];
        Object object2 = objectArray.length > 1 ? objectArray[1] : Boolean.FALSE;
        String string = "";
        if (object instanceof Number && ((Number)object).longValue() >= 0L && object2 instanceof Boolean) {
            try {
                string = this.numberToChinese(((Number)object).longValue(), (Boolean)object2);
            }
            catch (Exception exception) {
                string = Primitive.ERROR_VALUE.toString();
            }
        } else {
            return Primitive.ERROR_NAME;
        }
        return string;
    }

    private String numberToChinese(long l2, boolean bl) throws Exception {
        String string = "";
        if (bl) {
            while (l2 > 0L) {
                string = CHINESE_NUMBER[(int)l2 % 10] + string;
                l2 /= 10L;
            }
            return string;
        }
        return this.standardNumberToChinese(l2, string);
    }

    private String standardNumberToChinese(long l2, String string) throws Exception {
        for (int i2 = 5; i2 >= 4; --i2) {
            if (l2 / CHINESE_NUMBER_LEVEL[i2] > 0L) {
                string = i2 != 5 ? string + this.thousandToChinese(l2 / CHINESE_NUMBER_LEVEL[i2], string) + CHINESE_NUMBER_LEVEL_STR[i2] : this.standardNumberToChinese(l2 / CHINESE_NUMBER_LEVEL[i2], string) + CHINESE_NUMBER_LEVEL_STR[i2];
            } else if (string.length() > 0 && !string.endsWith(CHINESE_NUMBER[0]) && l2 % CHINESE_NUMBER_LEVEL[i2] > 0L) {
                string = string + CHINESE_NUMBER[0];
            }
            l2 %= CHINESE_NUMBER_LEVEL[i2];
        }
        string = string + this.thousandToChinese(l2, string);
        return string;
    }

    private String thousandToChinese(long l2, String string) throws Exception {
        String string2 = "";
        if (l2 == 10L && string.length() == 0) {
            return CHINESE_NUMBER_LEVEL_STR[1];
        }
        if (l2 > 10L && l2 < 20L && string.length() == 0) {
            return CHINESE_NUMBER_LEVEL_STR[1] + CHINESE_NUMBER[(int)l2 % 10];
        }
        for (int i2 = 3; i2 >= 0; --i2) {
            if (l2 / CHINESE_NUMBER_LEVEL[i2] > 0L) {
                string2 = string2 + CHINESE_NUMBER[(int)(l2 / CHINESE_NUMBER_LEVEL[i2])] + CHINESE_NUMBER_LEVEL_STR[i2];
            } else if (string2.length() > 0 && !string2.endsWith(CHINESE_NUMBER[0]) && l2 % CHINESE_NUMBER_LEVEL[i2] > 0L) {
                string2 = string2 + CHINESE_NUMBER[0];
            }
            l2 %= CHINESE_NUMBER_LEVEL[i2];
        }
        return string2;
    }

    public Function.Type getType() {
        return TEXT;
    }

    public String getCN() {
        return "NUMTO(number,bool)\u6216NUMTO(number):\u8fd4\u56denumber\u7684\u4e2d\u6587\u8868\u793a\u3002\u5176\u4e2dbool\u7528\u4e8e\u9009\u62e9\u4e2d\u6587\u8868\u793a\u7684\u65b9\u5f0f\uff0c\u5f53\u6ca1\u6709bool\u65f6\u91c7\u7528\u9ed8\u8ba4\u65b9\u5f0f\u663e\u793a\u3002\n\u793a\u4f8b\uff1aNUMTO(2345,true)\u7b49\u4e8e\u4e8c\u4e09\u56db\u4e94\u3002\n\u793a\u4f8b\uff1aNUMTO(2345,false)\u7b49\u4e8e\u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002\n\u793a\u4f8b\uff1aNUMTO(2345)\u7b49\u4e8e\u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002";
    }

    public String getEN() {
        return "";
    }
}

