/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.script.Function;

public class ATAN2
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length < 2) {
            return Primitive.ERROR_NAME;
        }
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof Number && object2 instanceof Number) {
            return FunctionHelper.asNumber(Math.atan2(((Number)object2).doubleValue(), ((Number)object).doubleValue()));
        }
        return Primitive.ERROR_NAME;
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "ATAN2(x_num,y_num): \u8fd4\u56dex\u3001y\u5750\u6807\u7684\u53cd\u6b63\u5207\u503c\u3002\u8fd4\u56de\u89d2\u5ea6\u4e3ax\u8f74\u4e0e\u8fc7\uff08x_num,y_num\uff09\u4e0e\u5750\u6807\u539f\u70b9\uff080,0\uff09\u7684\u4e00\u6761\u76f4\u7ebf\u5f62\u6210\u7684\u89d2\u5ea6\u3002\u8be5\u89d2\u5ea6\u4ee5\u5f27\u5ea6\u663e\u793a\u3002\nX_num:\u6307\u5b9a\u70b9\u7684x\u5750\u6807\u3002\nY_num:\u6307\u5b9a\u70b9\u7684y\u5750\u6807\u3002\n\u5907\u6ce8:\n    \u6b63\u503c\u8868\u793a\u4ecex\u8f74\u5f00\u59cb\u4ee5\u9006\u65f6\u9488\u65b9\u5f0f\u6240\u5f97\u7684\u89d2\u5ea6\uff1b\u8d1f\u503c\u8868\u793a\u4ecex\u8f74\u5f00\u59cb\u4ee5\u987a\u65f6\u9488\u65b9\u5f0f\u6240\u5f97\u7684\u89d2\u5ea6\u3002\n    ATAN2(a,b)=ATAN(b/a)\uff0ca\u4e3a0\u65f6\u9664\u5916\u3002\n    \u5f53x_num\u4e0ey_num\u90fd\u4e3a0\u65f6\uff0cATAN2\u8fd4\u56de\u9519\u8bef\u4fe1\u606f*DIV/0!\u3002\n    \u7528\u89d2\u5ea6\u5236\u663e\u793a\u8fd4\u56de\u6570\u503c\u65f6\uff0c\u628a\u8fd4\u56de\u6570\u503c\u4e58\u4ee5180/PI()\u3002\n    \u8fd4\u56de\u503c\u4ee5\u5f27\u5ea6\u8868\u793a\uff08\u8fd4\u56de\u503c\u5927\u4e8e-pi\u4e14\u5c0f\u4e8e\u7b49\u4e8epi\uff09\u3002\n\u793a\u4f8b:\nATAN2(-2,2)\u7b49\u4e8e2.356194490192345\uff08\u5f27\u5ea6\u5236\u76843*pi/4\uff09\u3002\nATAN2(2,2)\u7b49\u4e8e0.785398163\uff08\u5f27\u5ea6\u5236\u7684pi/4\uff09\u3002\nATAN2(-2,2)*180/PI()\u7b49\u4e8e135\uff08\u89d2\u5ea6\u5236\uff09\u3002";
    }

    public String getEN() {
        return "ATAN2(x_num,y_num): Returns the arctangent, or inverse tangent, of the specified x- and y-coordinates. The arctangent is the angle from the x-axis to a line containing the origin (0, 0) and a point with coordinates (x_num, y_num). The angle is given in radians.\nX_num is the x-coordinate of the point.\nY_num is the y-coordinate of the point.\n\nRemarks:\n1. A positive result represents a counterclockwise angle from the x-axis; a negative result represents a clockwise angle. \n2. ATAN2(a,b) equals ATAN(b/a), except that a can equal 0 in ATAN2. \n3. If both x_num and y_num are 0, ATAN2 returns the #DIV/0! error value. \n4. To express the arctangent in degrees, multiply the result by 180/PI( ) or use the DEGREES function.\n5. The angle is between -pi and pi, excluding -pi.\n\nExample:\n   ATAN2(-2,2)=2.356194490 (3*pi/4 in radians)\n   ATAN2(2,2)=0.785398163 (pi/4 in radians)\n   ATAN2(-2,2)*180/PI()=135 (in degrees)";
    }
}

