/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.privilege.base.FSPrivilegeVote;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.FSOpenEntryService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.stable.StableUtils;
import com.fr.web.utils.WebUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PlatformEntryService
extends AbstractFSAuthService {
    private static List<String> supportedModules = new ArrayList<String>();

    public String actionOP() {
        return "fr_platform";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (FSRegisterForBI.isSupportFS()) {
            FSOpenEntryService fSOpenEntryService = new FSOpenEntryService();
            fSOpenEntryService.process(httpServletRequest, httpServletResponse, string);
            return;
        }
        FSContext.initData();
        httpServletRequest.getSession(true).removeAttribute("originalURL");
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            PlatformEntryService.dealCookie(httpServletRequest, httpServletResponse);
            fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        }
        if (fSAuthentication != null && fSAuthentication.isRoot()) {
            this.init(httpServletRequest, httpServletResponse, string);
        } else {
            FSPrivilegeVote.FS_AUTH_ERROR.action(httpServletRequest, httpServletResponse);
        }
    }

    private void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = PrivilegeManager.getInstance().getRootManagerName();
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        hashMap.put("company", FSConfig.getInstance().getLoginTitle4FS());
        hashMap.put("userName", string2);
        hashMap.put("isAdmin", true);
        hashMap.put("isRegiste", !ComparatorUtils.equals(StableUtils.getBytes(), null) + "");
        hashMap.put("isLicExist", this.checkLicExist() + "");
        hashMap.put("hasRegistePrivilege", ModuleControl.getInstance().hasRegisterInfoModulePrivilege(l2) + "");
        hashMap.put("roots", this.getModuleRootShowInfo(l2).toString());
        hashMap.put("authenticateType", FSConfig.getInstance().getAuthenticateType());
        hashMap.put("hasprocess", false);
        hashMap.put("hasbi", false);
        hashMap.put("hasAnalysis", false);
        hashMap.put("hasnavigation", false);
        hashMap.put("ismobilebinddev", false);
        hashMap.put("isPlatForm", true);
        hashMap.put("templatePrivilegeType", PrivilegeManager.getInstance().getPrivilegeFilterType());
        hashMap.put("dataConnectionAuthority", FSConfig.getInstance().isDataConnectionAuthority());
        WebUtils.writeOutTemplate(PlatformEntryService.searchTemplatePath(httpServletRequest), httpServletResponse, hashMap);
    }

    private boolean checkLicExist() {
        if (ConfigManager.getInstance().isLicUseLock()) {
            return true;
        }
        try {
            Env env = FRContext.getCurrentEnv();
            String string = env.getLicName();
            InputStream inputStream = env.readBean(string, "resources");
            return inputStream != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String searchTemplatePath(HttpServletRequest httpServletRequest) {
        if ("true".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "debug"))) {
            return "/com/fr/fs/web/fs_debug.html";
        }
        if (FRContext.isShouldForceEnglish()) {
            return "/com/fr/fs/web/fs_en_us.html";
        }
        return "/com/fr/fs/web/fs.html";
    }

    private JSONObject getModuleRootShowInfo(long l2) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("modules", ModuleControl.getInstance().getModuleRootShowInfo(l2));
        return jSONObject;
    }

    public static List supportModules() {
        if (!supportedModules.isEmpty()) {
            return supportedModules;
        }
        supportedModules.add("1");
        supportedModules.add(String.valueOf(3));
        supportedModules.add(String.valueOf(18));
        supportedModules.add(String.valueOf(16));
        supportedModules.add(String.valueOf(5));
        supportedModules.add(String.valueOf(8));
        supportedModules.add(String.valueOf(9));
        return supportedModules;
    }
}

