/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetFilterUserInfoAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasCustomModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "startIdx");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "count");
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "keyword");
        int n2 = 0;
        int n3 = 0;
        if (StringUtils.isNotEmpty(string)) {
            n2 = Integer.valueOf(string);
        }
        if (StringUtils.isNotEmpty(string2)) {
            n3 = Integer.valueOf(string2);
        }
        JSONObject jSONObject = this.getFilterUserInfo(l2, n2, n3, string3);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getalluserinfo";
    }

    private JSONObject getFilterUserInfo(long l2, int n2, int n3, String string) throws Exception {
        JSONObject jSONObject = new JSONObject();
        List list = this.getFilterAuthUser(l2, string);
        int n4 = Math.min(n3 + n2, list.size());
        HashMap hashMap = new HashMap(32);
        JSONArray jSONArray = new JSONArray();
        if (list != null && n2 >= 0) {
            for (int i2 = n2; i2 < n4; ++i2) {
                User user = (User)list.get(i2);
                JSONObject jSONObject2 = user.createUnEditInfoJSONConfig();
                FArray fArray = UserControl.getInstance().getAllSRoleNames(user.getId());
                jSONObject2.put("role", StableUtils.join(fArray.toList(), "; "));
                this.addJob(user, hashMap, jSONObject2);
                jSONArray.put(jSONObject2);
            }
        }
        jSONObject.put("total", list.size());
        jSONObject.put("users", jSONArray);
        return jSONObject;
    }

    private List getFilterAuthUser(long l2, String string) throws Exception {
        List list = !FSConfig.getInstance().isGradeAuthority() ? UserControl.getInstance().findAllUser() : UserControl.getInstance().findAllAuthUser(l2);
        if (StringUtils.isEmpty(string)) {
            return list;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            User user = (User)list.get(i2);
            if (!this.isKeywordInUserInfo(user.createUnEditInfoJSONConfig(), string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    private void addJob(User user, Map map, JSONObject jSONObject) throws Exception {
        Set set = UserControl.getInstance().getJobs(user.getId());
        if (set != null) {
            Iterator iterator = set.iterator();
            String string = "";
            while (iterator.hasNext()) {
                RelationObject relationObject = (RelationObject)iterator.next();
                long l2 = (Long)relationObject.getValue(Department.class);
                String string2 = DepartmentControl.getInstance().getDepartmentShowName(l2, ",");
                if (string2 == null) continue;
                String string3 = (String)map.get(relationObject.getValue(Post.class));
                if (string3 == null) {
                    string3 = PostControl.getInstance().getPostName((Long)relationObject.getValue(Post.class));
                    if (string3 == null) continue;
                    map.put(relationObject.getValue(Post.class), string3);
                    string = string + string2 + "-" + string3 + " ";
                    continue;
                }
                string = string + string2 + "-" + string3 + " ";
            }
            if (StringUtils.isNotBlank(string)) {
                jSONObject.put("depart", string);
            }
        }
    }

    private boolean isKeywordInUserInfo(JSONObject jSONObject, String string) {
        if (jSONObject.optString("username", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        if (jSONObject.optString("realname", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        if (jSONObject.optString("mobile", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        return jSONObject.optString("email", "").toLowerCase().contains(string.toLowerCase());
    }
}

