/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSetAuthGetEntryUsersAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "entryId");
        JSONArray jSONArray = new JSONArray();
        if (!StringUtils.isBlank(string)) {
            this.addUserFromCompanyRole(jSONArray, string);
            this.addUserFromCustomRole(jSONArray, string);
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getEntryUsers";
    }

    private void addUserFromCompanyRole(JSONArray jSONArray, String string) throws Exception {
        int n2 = Integer.parseInt(string.substring(0, 1));
        long l2 = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n2, l2);
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            List list2 = CompanyRoleControl.getInstance().getAllEntryPrivileges(companyRole.getId());
            HashSet hashSet = new HashSet();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCompanyUser(companyRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n2, l2);
        }
    }

    private void addUserFromCustomRole(JSONArray jSONArray, String string) throws Exception {
        int n2 = Integer.parseInt(string.substring(0, 1));
        long l2 = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n2, l2);
        List list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            List list2 = CustomRoleControl.getInstance().getAllEntryPrivileges(customRole.getId());
            HashSet hashSet = new HashSet();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCustomUser(customRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n2, l2);
        }
    }

    private void addCompanyUser(CompanyRole companyRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CompanyRoleControl.getInstance().getUsersID(companyRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l2);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private void addUser(User user, JSONArray jSONArray, EntryTypeAndID entryTypeAndID) throws Exception {
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (jSONObject.getLong("id") != user.getId()) continue;
            long l2 = jSONObject.getLong("view");
            long l3 = this.getView(entryTypeAndID.getView());
            if (l2 == 0L && l3 == 1L) {
                jSONObject.put("view", 1);
            }
            long l4 = jSONObject.getLong("design");
            long l5 = this.getDesignAndEdit(entryTypeAndID.getAuthorized());
            if (l4 == 0L && l5 == 1L) {
                jSONObject.put("design", 1);
            }
            long l6 = jSONObject.getLong("edit");
            long l7 = this.getDesignAndEdit(entryTypeAndID.getEdit());
            if (l6 == 0L && l7 == 1L) {
                jSONObject.put("edit", 1);
            }
            return;
        }
        JSONObject jSONObject = user.createUnEditInfoJSONConfig();
        jSONObject.put("view", this.getView(entryTypeAndID.getView()));
        jSONObject.put("design", this.getDesignAndEdit(entryTypeAndID.getAuthorized()));
        jSONObject.put("edit", this.getDesignAndEdit(entryTypeAndID.getEdit()));
        jSONObject.put("id", user.getId());
        jSONArray.put(jSONObject);
    }

    private void addCustomUser(CustomRole customRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CustomRoleControl.getInstance().getUsersID(customRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l2);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private long getView(long l2) {
        if (l2 == 2L) {
            l2 = 1L;
        }
        return l2;
    }

    private long getDesignAndEdit(long l2) {
        if (l2 == 2L) {
            l2 = 0L;
        }
        return l2;
    }
}

