/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.RecursionTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.UserCache;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSManagerModuleImportUserAction
extends ActionNoSessionCMD {
    private static long IdFix = 10L;
    private static String ROOT = "-1";
    private static Map deparIdMap = new HashMap();
    private static boolean isTreeData = false;

    @Override
    public String getCMD() {
        return "importUser";
    }

    @Override
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasCustomModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "res");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "override");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        if (string2 != null) {
            List list = UserCache.getDuplicatedUsers();
            boolean bl = this.updateHSQLUsers(list);
            jSONObject.put("success", bl);
        } else {
            JSONObject jSONObject2 = new JSONObject(string);
            String string3 = null;
            boolean bl = false;
            String string4 = jSONObject2.optString("dsName", "");
            TableData tableData = DatasourceManager.getInstance().getTableData(string4);
            if (tableData != null) {
                if (!this.needQuery(httpServletRequest, tableData, jSONObject2, jSONObject)) {
                    List list = this.getImportUsers(jSONObject2, tableData);
                    DepartmentCache.reInit();
                    if (!list.isEmpty()) {
                        bl = true;
                        UserCache.setDuplicatedUsers(list);
                        string3 = this.getDuplicatedInfo(list);
                    }
                    jSONObject.put("hasDuplicated", bl).put("warnings", string3);
                }
            } else {
                jSONObject.put("error", Inter.getLocText("Can_not_find_Data_Connection", httpServletRequest.getLocale()));
            }
        }
        printWriter.write(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private boolean needQuery(HttpServletRequest httpServletRequest, TableData tableData, JSONObject jSONObject, JSONObject jSONObject2) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "clearall");
        boolean bl = false;
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        if (this.isEncryptChanged(jSONObject)) {
            if (bl) {
                FSManagerModuleImportUserAction.clearTables();
                HSQLDBDAOControl.getInstance().parseJSON(jSONObject);
                FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
                return false;
            }
            jSONObject2.put("query", Inter.getLocText("ModifySecretWillRemoveUser", httpServletRequest.getLocale()));
            return true;
        }
        if (tableData instanceof RecursionTableData) {
            if (bl) {
                FSManagerModuleImportUserAction.clearTables();
                return false;
            }
            jSONObject2.put("query", Inter.getLocText("UseTreeWillRemoveUser", httpServletRequest.getLocale()));
            return true;
        }
        return false;
    }

    private boolean isEncryptChanged(JSONObject jSONObject) throws Exception {
        int n2 = jSONObject.optInt("encrypt", -1);
        String string = jSONObject.optString("myencrypt", "");
        JSONObject jSONObject2 = HSQLDBDAOControl.getInstance().getPv().toJSONObject();
        if (n2 == jSONObject2.getInt("encrypt")) {
            if (n2 == 1) {
                return !ComparatorUtils.equals(string, jSONObject2.getString("myencrypt"));
            }
            return false;
        }
        return true;
    }

    private List getImportUsers(JSONObject jSONObject, TableData tableData) throws Exception {
        if (!jSONObject.has("dsName")) {
            return new ArrayList();
        }
        int n2 = jSONObject.optInt("userName", -1);
        int n3 = jSONObject.optInt("password", -1);
        int n4 = jSONObject.optInt("name", -1);
        int n5 = jSONObject.optInt("email", -1);
        int n6 = jSONObject.optInt("mobile", -1);
        int n7 = jSONObject.optInt("department", -1);
        int n8 = jSONObject.optInt("post", -1);
        int n9 = jSONObject.optInt("role", -1);
        return FSManagerModuleImportUserAction.doImport(tableData, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static List doImport(TableData tableData, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws Exception {
        ArrayList<TableDataUser> arrayList = new ArrayList<TableDataUser>();
        isTreeData = tableData instanceof RecursionTableData;
        DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
        int n10 = dataModel.getRowCount();
        for (int i2 = 0; i2 < n10; ++i2) {
            Object object;
            Object object2;
            TableDataUser tableDataUser = FSManagerModuleImportUserAction.initUserFormDS(dataModel, i2, n2, n3, n4, n5, n6);
            if (tableDataUser == null) continue;
            Department department = null;
            Post post = null;
            if (n7 > -1 && n8 > -1) {
                String string;
                object2 = dataModel.getValueAt(i2, n7);
                object = dataModel.getValueAt(i2, n8);
                String string2 = object2 != null ? object2.toString() : "";
                String string3 = string = object != null ? object.toString() : "";
                if (StringUtils.isNotEmpty(string2) && StringUtils.isNotEmpty(string)) {
                    department = new Department(string2, "", -1L);
                    if (isTreeData) {
                        FSManagerModuleImportUserAction.generateRecursionDepartment(department, (RecursionTableData)tableData, (RecursionDataModel)dataModel, i2);
                    }
                    DepartmentControl.getInstance().addDepartment(department);
                    post = new Post(string, "");
                    if (!PostControl.getInstance().addPost(post)) {
                        post = PostControl.getInstance().getPostByName(string);
                    }
                    tableDataUser.setPostValue(string);
                    tableDataUser.setDepartmentValue(string2);
                }
            }
            if (n9 > -1) {
                object2 = dataModel.getValueAt(i2, n9);
                Object object3 = object = object2 != null ? object2.toString() : "";
                if (StringUtils.isNotEmpty((String)object)) {
                    tableDataUser.setRoleValue((String)object);
                }
            }
            if (FSManagerModuleImportUserAction.importUser2HSQL(tableDataUser, department, post)) continue;
            arrayList.add(tableDataUser);
        }
        return arrayList;
    }

    private static TableDataUser initUserFormDS(DataModel dataModel, int n2, int n3, int n4, int n5, int n6, int n7) throws TableDataException {
        Object object;
        String string;
        Object object2 = dataModel.getValueAt(n2, n3);
        String string2 = string = object2 != null ? object2.toString() : "";
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        Object object3 = dataModel.getValueAt(n2, n4);
        TableDataUser tableDataUser = new TableDataUser(n2, string, object3 != null ? object3.toString() : "");
        if (n5 > -1) {
            object = dataModel.getValueAt(n2, n5);
            tableDataUser.setName(object != null ? object.toString() : "");
        }
        if (n6 > -1) {
            object = dataModel.getValueAt(n2, n6);
            tableDataUser.setEmail(object != null ? object.toString() : "");
        }
        if (n7 > -1) {
            object = dataModel.getValueAt(n2, n7);
            tableDataUser.setMobile(object != null ? object.toString() : "");
        }
        return tableDataUser;
    }

    private static boolean importUser2HSQL(TableDataUser tableDataUser, Department department, Post post) throws Exception {
        String string;
        User user = tableDataUser.getUser();
        if (!UserControl.getInstance().addUser(user)) {
            long l2 = UserControl.getInstance().getUser(tableDataUser.getUserName());
            user.setId(l2);
            if (!isTreeData) {
                return false;
            }
        }
        if (department != null && post != null) {
            CompanyRole companyRole = new CompanyRole(post.getId(), department.getId(), null);
            CompanyRoleControl.getInstance().addCompanyRole(companyRole);
            UserControl.getInstance().addDepartmentAndPost2User(user.getId(), department.getId(), post.getId());
        }
        if (StringUtils.isNotEmpty(string = tableDataUser.getRoleValue())) {
            CustomRole customRole = new CustomRole(string, "");
            if (!CustomRoleControl.getInstance().addCustomRole(customRole)) {
                customRole = CustomRoleControl.getInstance().findByCustomRoleName(string);
            }
            UserControl.getInstance().addSRole(user.getId(), customRole.getId());
        }
        return true;
    }

    private static void generateRecursionDepartment(Department department, RecursionTableData recursionTableData, RecursionDataModel recursionDataModel, int n2) throws Exception {
        String string;
        int n3 = recursionTableData.getMarkFieldIndex();
        int n4 = recursionTableData.getParentmarkFieldIndex();
        String string2 = recursionDataModel.getValueAt(n2, n3).toString();
        if (n4 < 0) {
            string = recursionDataModel.getParentValue(n2);
        } else {
            Object object = recursionDataModel.getValueAt(n2, n4);
            String string3 = string = object == null ? ROOT : object.toString();
        }
        if (StringUtils.isEmpty(string)) {
            string = ROOT;
        }
        department.setId(FSManagerModuleImportUserAction.genIdFromString(string2));
        department.setPid(FSManagerModuleImportUserAction.genIdFromString(string));
    }

    private static long genIdFromString(String string) {
        if (string == ROOT) {
            return -1L;
        }
        Long l2 = (Long)deparIdMap.get(string);
        if (l2 == null) {
            long l3 = (long)deparIdMap.size() + IdFix;
            while (deparIdMap.containsValue(new Long(l3))) {
                ++l3;
            }
            deparIdMap.put(string, new Long(l3));
            return l3;
        }
        return l2;
    }

    private String getDuplicatedInfo(List<TableDataUser> list) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (list.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append(Inter.getLocText("User_Duplicated_Username"));
        int n3 = n2 = list.size() > 3 ? 3 : list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TableDataUser tableDataUser = list.get(i2);
            stringBuilder.append(tableDataUser.getUserName());
            if (i2 == n2 - 1) continue;
            stringBuilder.append(Inter.getLocText("Comma"));
        }
        stringBuilder.append("...(");
        stringBuilder.append(Inter.getLocText("Page_Total"));
        stringBuilder.append(list.size());
        stringBuilder.append(Inter.getLocText("Ge"));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean updateHSQLUsers(List<TableDataUser> list) throws Exception {
        boolean bl = true;
        for (TableDataUser tableDataUser : list) {
            UserControl.getInstance().deleteUser(tableDataUser.getId());
            this.importDuplicatedUser2HSQL(tableDataUser);
        }
        return bl;
    }

    private boolean importDuplicatedUser2HSQL(TableDataUser tableDataUser) throws Exception {
        String string = tableDataUser.getDepartmentValue();
        Department department = null;
        Post post = null;
        if (StringUtils.isNotEmpty(string)) {
            post = new Post(tableDataUser.getPostValue(), "");
            department = new Department(string, "", -1L);
            DepartmentControl.getInstance().addDepartment(department);
            if (!PostControl.getInstance().addPost(post)) {
                post = PostControl.getInstance().getPostByName(post.getPostname());
            }
        }
        return FSManagerModuleImportUserAction.importUser2HSQL(tableDataUser, department, post);
    }

    public static void clearTables() throws Exception {
        List list;
        int n2;
        List list2;
        Long[] longArray;
        int n3;
        List list3 = UserControl.getInstance().findAllUserWithoutSort();
        if (list3 != null) {
            n3 = list3.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                User user = (User)list3.get(i2);
                UserControl.getInstance().deleteUser(user.getId());
            }
        }
        if ((longArray = DepartmentControl.getInstance().getDpidsByPid(-1L)) != null) {
            int n4 = longArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                DepartmentControl.getInstance().deleteDepartment(longArray[n3]);
            }
        }
        if ((list2 = PostControl.getInstance().getAllPost(false)) != null) {
            n2 = list2.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                Post post = (Post)list2.get(i3);
                PostControl.getInstance().deletePost(post.getId());
            }
        }
        if ((list = CustomRoleControl.getInstance().getAllCustomRole()) != null) {
            int n5 = list.size();
            for (n2 = 0; n2 < n5; ++n2) {
                CustomRole customRole = (CustomRole)list.get(n2);
                CustomRoleControl.getInstance().deleteCustomRole(customRole.getId());
            }
        }
        deparIdMap.clear();
    }
}

