/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.fs.FSConfig;
import com.fr.fs.adhoc.ADHOCDesignSetting;
import com.fr.fs.adhoc.ADHOCReportNode;
import com.fr.fs.adhoc.output.ADHOCFileRepository;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.web.FSOutputReportlet;
import com.fr.fs.web.service.ADHOCInitAnalysisPanelAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLFileReader;
import com.fr.web.core.A.H;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMainADHOCReportAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        ADHOCReportNode aDHOCReportNode = null;
        aDHOCReportNode = l2 == UserControl.getInstance().getSuperManagerID() ? SystemManagerFavoriteAndADHOC.getInstance().findSysADHOCReportNodeById(Long.parseLong(string)) : FSConfig.getInstance().getControl().getADHOCReportDAO().findByID(Long.parseLong(string));
        this.dealWithEntryResourceRequest(httpServletRequest, httpServletResponse, l2, aDHOCReportNode);
    }

    private void dealWithEntryResourceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l2, ADHOCReportNode aDHOCReportNode) throws Exception {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        if (aDHOCReportNode == null) {
            throw new Exception("can't find the report! might be delete or move!");
        }
        if (aDHOCReportNode.getPath().endsWith(".cpr")) {
            File file = ADHOCFileRepository.getInstance().getADHOCDirFile(l2 + "");
            String string = file.getAbsolutePath() + aDHOCReportNode.getPath();
            FSOutputReportlet fSOutputReportlet = new FSOutputReportlet(string, aDHOCReportNode.getReportName());
            H.A(httpServletRequest, httpServletResponse, fSOutputReportlet, false);
        } else if (aDHOCReportNode.getPath().endsWith(".ads")) {
            Object object;
            File file = new File(CodeUtils.decodeText(aDHOCReportNode.getPath()));
            if (!file.exists()) {
                object = file.getName().substring(0, file.getName().lastIndexOf("."));
                file = FSMainADHOCReportAction.getFileWithRelativePath(String.valueOf(l2), ".ads", (String)object);
                if (!file.exists()) {
                    throw new Exception("can't find file:" + aDHOCReportNode.getPath() + "! might be delete or move!");
                }
            }
            object = (ADHOCDesignSetting)BaseXMLUtils.readXMLFile(BaseUtils.readResource(file.getAbsolutePath()), (XMLFileReader)new ADHOCDesignSetting());
            HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
            JSONObject jSONObject = ((ADHOCDesignSetting)object).getReportSetting();
            hashMap.put("popConfig", jSONObject);
            String string = jSONObject.getString("viewname");
            ADHOCInitAnalysisPanelAction.initAnalysisPanel(string, "", false, hashMap, httpServletResponse);
        }
    }

    private static File getFileWithRelativePath(String string, String string2, String string3) {
        File file = ADHOCFileRepository.getInstance().getADHOCDirFile(string);
        if (!file.exists()) {
            StableUtils.mkdirs(file);
        }
        return new File(file, string3 + string2);
    }

    public String getCMD() {
        return "adhoc_report";
    }
}

