/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportWebUtils;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryGetUserReportsAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = this.authentication(httpServletRequest);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "file");
        if (StringUtils.isEmpty(string)) {
            string = "cpt,frm";
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        IdGenerator idGenerator = new IdGenerator();
        FileNode[] fileNodeArray = FRContext.getCurrentEnv().listFile("reportlets");
        JSONArray jSONArray = l2 == CustomRoleControl.getInstance().getSuperCustomRoleID() ? this.createReportJSONArrayForSuperUser(fileNodeArray, idGenerator, string) : this.createReportJSONArrayForUser(fileNodeArray, idGenerator, string, l2);
        printWriter.print(jSONArray.toString());
        printWriter.flush();
        printWriter.close();
    }

    protected long authentication(HttpServletRequest httpServletRequest) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        return l2;
    }

    protected JSONArray createReportJSONArrayForSuperUser(FileNode[] fileNodeArray, IdGenerator idGenerator, String string) {
        return ReportWebUtils.getReportletsOfCurrentEnv(fileNodeArray, idGenerator, string);
    }

    protected JSONArray createReportJSONArrayForUser(FileNode[] fileNodeArray, IdGenerator idGenerator, String string, long l2) throws Exception {
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l2);
        ArrayList arrayList = new ArrayList();
        FSPrivilegeTools.getInstance().filterFile(fileNodeArray, set, arrayList, 0);
        FileNode[] fileNodeArray2 = new FileNode[arrayList.size()];
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            fileNodeArray2[i2] = (FileNode)arrayList.get(i2);
        }
        return FSPrivilegeTools.getReportletsOfCurrentEnv(fileNodeArray2, set, idGenerator, string, 0);
    }

    public String getCMD() {
        return "get_user_reports";
    }
}

