/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSEntryGetAllReportsAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!ModuleControl.getInstance().hasPrivilegeModulePrivilege(l2)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fileType");
        if (StringUtils.isEmpty(string)) {
            string = "cpt";
        }
        String[] stringArray = string.split(",");
        Env env = FRContext.getCurrentEnv();
        JSONArray jSONArray = new JSONArray();
        this.find(env, "reportlets", jSONArray, stringArray);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    private void find(Env env, String string, JSONArray jSONArray, String[] stringArray) throws Exception {
        FileNode[] fileNodeArray = env.listFile(string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            JSONObject jSONObject = new JSONObject();
            if (fileNode.isDirectory()) {
                jSONObject.put("name", fileNode.getName());
                jSONObject.put("path", fileNode.getEnvPath());
                jSONArray.put(jSONObject);
                JSONArray jSONArray2 = new JSONArray();
                jSONObject.put("children", jSONArray2);
                this.find(env, string + File.separator + fileNode.getName(), jSONArray2, stringArray);
                continue;
            }
            for (String string2 : stringArray) {
                if (!fileNode.isFileType(string2)) continue;
                jSONObject.put("name", fileNode.getName());
                jSONObject.put("path", fileNode.getEnvPath());
                jSONArray.put(jSONObject);
            }
        }
    }

    public String getCMD() {
        return "get_all_reports";
    }
}

