/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.service.FSEntryGetUserReportsAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportWebUtils;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSEntry4OAGetUserReportsAction
extends FSEntryGetUserReportsAction {
    public String getCMD() {
        return "get_user_reports_from_oa";
    }

    protected long authentication(HttpServletRequest httpServletRequest) throws Exception {
        return ServiceUtils.getCurrentUserID(httpServletRequest);
    }

    protected JSONArray createReportJSONArrayForSuperUser(FileNode[] fileNodeArray, IdGenerator idGenerator, String string) {
        return this.getReportletsOfCurrentEnv(fileNodeArray, idGenerator, string, -1);
    }

    protected JSONArray createReportJSONArrayForUser(FileNode[] fileNodeArray, IdGenerator idGenerator, String string, long l2) throws Exception {
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l2);
        ArrayList arrayList = new ArrayList();
        FSPrivilegeTools.getInstance().filterFile(fileNodeArray, set, arrayList, 0);
        FileNode[] fileNodeArray2 = new FileNode[arrayList.size()];
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            fileNodeArray2[i2] = (FileNode)arrayList.get(i2);
        }
        return FSEntry4OAGetUserReportsAction.getReportletsOfCurrentEnv(fileNodeArray2, set, idGenerator, string, 0, -1);
    }

    private JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, IdGenerator idGenerator, String string, int n2) {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile(fileNodeArray, string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put(jSONObject);
            try {
                int n3 = idGenerator.generateId();
                jSONObject.put("id", n3);
                if (n2 != -1) {
                    jSONObject.put("idstring", n2 + "_" + n3);
                } else {
                    jSONObject.put("idstring", n3);
                }
                jSONObject.put("name", fileNode.getName());
                jSONObject.put("text", fileNode.getName());
                jSONObject.put("value", fileNode.getName());
                jSONObject.put("path", string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", 1);
                jSONObject.put("write", 1);
                jSONObject.put("design", 1);
                if (!fileNode.isDirectory()) {
                    jSONObject.put("click", "viewcpt('" + string2 + "')");
                }
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("open", true);
                jSONObject.put("hasChildren", true);
                jSONObject.put("children", this.getReportletsOfCurrentEnv(fileNode.getEnvPath(), idGenerator, string, n3));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONArray;
    }

    public JSONArray getReportletsOfCurrentEnv(String string, IdGenerator idGenerator, String string2, int n2) {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return jSONArray;
        }
        return this.getReportletsOfCurrentEnv(fileNodeArray, idGenerator, string2, n2);
    }

    public static JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, Set set, IdGenerator idGenerator, String string, int n2, int n3) throws Exception {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile(fileNodeArray, string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put(jSONObject);
            try {
                int n4 = idGenerator.generateId();
                jSONObject.put("id", n4);
                if (n3 != -1) {
                    jSONObject.put("idstring", n3 + "_" + n4);
                } else {
                    jSONObject.put("idstring", n4);
                }
                jSONObject.put("text", fileNode.getName());
                jSONObject.put("name", fileNode.getName());
                jSONObject.put("value", fileNode.getName());
                jSONObject.put("path", string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", fileNode.getPage());
                jSONObject.put("write", fileNode.getWrite());
                jSONObject.put("design", fileNode.getDesign());
                if (!fileNode.isDirectory()) {
                    jSONObject.put("click", "viewcpt('" + string2 + "')");
                }
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("open", true);
                jSONObject.put("hasChildren", true);
                FileNode[] fileNodeArray2 = FRContext.getCurrentEnv().listFile(fileNode.getEnvPath());
                ArrayList arrayList = new ArrayList();
                FSPrivilegeTools.getInstance().filterFile(fileNodeArray2, set, arrayList, n2);
                FileNode[] fileNodeArray3 = new FileNode[arrayList.size()];
                int n5 = arrayList.size();
                for (int i3 = 0; i3 < n5; ++i3) {
                    fileNodeArray3[i3] = (FileNode)arrayList.get(i3);
                }
                jSONObject.put("children", FSEntry4OAGetUserReportsAction.getReportletsOfCurrentEnv(fileNodeArray3, set, idGenerator, string, n2, n4));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONArray;
    }
}

