/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.DAOBean;
import com.fr.fs.FSConfig;
import com.fr.fs.base.FSManager;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.AbstractFSAuthentication;
import com.fr.fs.privilege.auth.AuthenticateResult;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.privilege.auth.FailResult;
import com.fr.fs.privilege.auth.LdapAuthenticationProvider;
import com.fr.fs.privilege.auth.SuccessResult;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.privilege.base.FServicePrivilegeLoader;
import com.fr.fs.privilege.entity.DaoFSAuthentication;
import com.fr.fs.web.UserInfo;
import com.fr.general.ComparatorUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AbstractAuthentication;
import com.fr.privilege.authentication.UsernamePasswordAuthentication;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.stable.StringUtils;
import com.fr.web.core.reserve.NoSessionIDService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractFSAuthService
extends NoSessionIDService {
    protected PrivilegeVote getFSVote(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            AbstractFSAuthService.dealCookie(httpServletRequest, httpServletResponse);
            fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        }
        return FSManager.getFSKeeper().access(fSAuthentication);
    }

    public static void dealCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UserInfo userInfo = new UserInfo(httpServletRequest);
        AbstractFSAuthService.dealLoginInfo(httpServletRequest, httpServletResponse, userInfo.getUserName(), userInfo.getPassword());
        userInfo = null;
    }

    private static boolean dealLoginInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        Object object;
        Object object2;
        AuthenticateResult authenticateResult;
        Object object3;
        Object object4;
        boolean bl = true;
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return false;
        }
        if (ComparatorUtils.equals("ldap", FSConfig.getInstance().getAuthenticateType())) {
            Boolean bl2;
            object4 = FSConfig.getInstance().getPrincipalSuffix();
            object3 = string;
            if (StringUtils.isNotEmpty((String)object4)) {
                object3 = string + (String)object4;
            }
            if (!(bl2 = Boolean.valueOf(LdapAuthenticationProvider.getInstance().ldapAuthentication((String)object3, string2))).booleanValue()) {
                return false;
            }
            bl = false;
        }
        object4 = UserNamePassWordFSAuthenticationProvider.getInstance();
        ((UserNamePassWordFSAuthenticationProvider)object4).setNeedPassword(bl);
        object3 = new UsernamePasswordAuthentication(string, string2);
        boolean bl3 = ((UserNamePassWordFSAuthenticationProvider)object4).authenticate((Authentication)object3);
        if (!bl3) {
            authenticateResult = new FailResult("No User & Password Exist!");
        } else {
            object2 = UserControl.getInstance().getByUserName(string);
            if (object2 != null) {
                object = new DaoFSAuthentication(new com.fr.fs.base.entity.UserInfo(((DAOBean)object2).getId(), ((User)object2).getUsername(), ((User)object2).getPassword()));
                ((AbstractFSAuthentication)object).setRoot(object3.isRoot());
                ((AbstractAuthentication)object).setAuthenticated(true);
                ((AbstractAuthentication)object).setAuthorities(object3.getAuthorities());
                authenticateResult = new SuccessResult((FSAuthentication)object);
            } else {
                authenticateResult = new FailResult("No User & Password Exist!");
            }
        }
        if (authenticateResult.success()) {
            object2 = authenticateResult.getFSAuthentication();
            object = httpServletRequest.getSession(true);
            long l2 = ((FSAuthentication)object2).getUserInfo().getId();
            UserControl.getInstance().login(l2);
            PrivilegeInfoSessionMananger.login(new FServicePrivilegeLoader(string, UserControl.getInstance().getAllSRoleNames(l2), UserControl.getInstance().getUserDP(l2)), (HttpSession)object, httpServletResponse);
            object.setAttribute("fr_fs_auth_key", object2);
            return true;
        }
        return false;
    }
}

