/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.org.quartz.Trigger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import oracle.sql.TIMESTAMP;

public abstract class ITrigger
implements XMLable {
    public static int WAITSTATE = -2;
    public static final int IMMEDIATE = 1;
    public static final int ON = 2;
    public static final FieldColumnMapper[] ITRIGGER_FIELDMAPPER = new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CommonFieldColumnMapper("timeZoneID", 12, "timezone_id", new ColumnSize(255), true), new CommonFieldColumnMapper("startType", 4, "start_type", new ColumnSize(5), true), new CommonFieldColumnMapper("startTime", 93, "startTime", new ColumnSize(), true, new FCValueMapper(){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                }
            }
            return object;
        }
    })};
    public static CommonFieldColumnMapper EndTimeFieldMapper = new CommonFieldColumnMapper("endTime", 93, "endTime", new ColumnSize(), true, new FCValueMapper(){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                }
            }
            return object;
        }
    });
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private long version;
    private String timeZoneID = TimeZone.getDefault().getID();
    private long startType = 1L;
    private Date startTime = null;
    private Date endTime = null;

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("startType", this.getStartType());
        Date date = this.getStartTime();
        if (date != null) {
            String string = DateUtils.DATETIMEFORMAT2.format(date);
            jSONObject.put("startTime", string);
        }
        return jSONObject;
    }

    public abstract Trigger createTrigger();

    public abstract int getITriggerIdPrefix();

    public abstract ITrigger analyzeJSON(JSONObject var1);

    public long getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    public long getStartType() {
        return this.startType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public void setVersion(long l2) {
        this.version = l2;
    }

    public void setTimeZoneID(String string) {
        this.timeZoneID = string;
    }

    public void setStartType(long l2) {
        this.startType = l2;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof ITrigger)) {
            return false;
        }
        ITrigger iTrigger = (ITrigger)object;
        return iTrigger.getId() == this.getId() && iTrigger.getVersion() == this.getVersion() && ComparatorUtils.equals(iTrigger.getStartTime(), this.getStartTime()) && iTrigger.getStartType() == this.getStartType() && ComparatorUtils.equals(iTrigger.getTimeZoneID(), this.getTimeZoneID());
    }

    public Object clone() throws CloneNotSupportedException {
        ITrigger iTrigger = (ITrigger)super.clone();
        if (this.startTime != null) {
            iTrigger.startTime = (Date)this.startTime.clone();
        }
        return iTrigger;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }
}

