/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.FRContext;
import com.fr.fs.schedule.job.ReportletJob;
import com.fr.general.Inter;
import com.fr.io.TemplateWorkBookIO;
import com.fr.log.LogUtils;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.report.module.EngineModuleFactory;
import com.fr.report.report.WriteECReport;
import com.fr.report.worksheet.WorkSheet;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.write.ReportWriteAttrProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class WriteReportletJob
extends ReportletJob {
    protected void executeReport() {
        this.record_list = new ArrayList();
        this.arrayParaList = new ArrayList();
        this.reportlet = EngineModuleFactory.generateReportlet(this.reportPath);
        ScheduleUtils.calculatorParameters(this.getExecuteParameter(), this.record_list, this.arrayParaList);
        try {
            TemplateWorkBook templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook(FRContext.getCurrentEnv(), this.reportPath);
            File file = new File(StableUtils.pathJoin(new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", this.reportPath}));
            if (!file.exists()) {
                this.log.error("[Schedule] WriteReportletJob . Not found reportlet: " + this.reportPath);
                return;
            }
            int n2 = this.record_list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                WriteWorkBook writeWorkBook;
                Map map = (Map)this.record_list.get(i2);
                if (!this.checkExecuteFormula(map, writeWorkBook = (WriteWorkBook)LogUtils.executeAndLogRecord(templateWorkBook, this.reportPath, map, ActorFactory.getActor("write")))) {
                    return;
                }
                this.writeReportData(writeWorkBook, templateWorkBook, Collections.EMPTY_MAP);
                String string = Inter.getLocText("Reporting-Schedule-Action") + ":" + Inter.getLocText("Successfully");
                if (this.scheduleTask.getCounts() > 0) {
                    string = string + ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts());
                }
                this.log.scheduleInfo(this.scheduleTask.getName(), string);
            }
        }
        catch (Exception exception) {
            this.dealWithException(exception);
        }
        this.log.info("[Schedule] WriteJob complete successfully.");
    }

    public void logReportPathError() {
        this.log.error("[Schedule] WriteReportletJob : Reporlet path is null.");
    }

    public void logTipInfo() {
        this.log.info("[Schedule] Start to write. ReportPath :" + this.reportPath);
    }

    private void writeReportData(WriteWorkBook writeWorkBook, TemplateWorkBook templateWorkBook, Map map) throws Exception {
        int n2 = templateWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeInnerReportData(writeWorkBook.getWriteReport(i2), (WorkSheet)templateWorkBook.getTemplateReport(i2), map);
        }
    }

    private void writeInnerReportData(WriteECReport writeECReport, WorkSheet workSheet, Map map) throws Exception {
        ReportWriteAttrProvider reportWriteAttrProvider = workSheet.getReportWriteAttr();
        if (reportWriteAttrProvider == null) {
            return;
        }
        reportWriteAttrProvider.submit(writeECReport, workSheet.getTemplateWorkBook(), map);
    }
}

