/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.BaseXMLUtils;
import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.fs.schedule.ScheduleUserAndCPRFile;
import com.fr.fs.schedule.ViewScheduleSavedInfo;
import com.fr.fs.schedule.job.DoFileActionJob;
import com.fr.fs.schedule.job.ReportletJob;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.PageWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.module.EngineModuleFactory;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FileActionList;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.script.Calculator;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.WebletException;
import com.fr.web.request.ReportletRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ViewReportletJob
extends ReportletJob {
    private static final int SHOWTYPE = 1;
    private ViewScheduleSavedInfo viewScheduleSavedInfo;
    private File saveDirectory;
    private String currentUserName;

    protected void executeReport() {
        this.record_list = new ArrayList();
        this.arrayParaList = new ArrayList();
        FileRepository fileRepository = this.scheduleTask.getScheduledOutput().getFileRepository();
        this.saveDirectory = ScheduleUtils.getTaskTimeDirFile(fileRepository, this.scheduleTask.getName(), this.scheduledFireTime);
        if (!this.saveDirectory.exists()) {
            StableUtils.mkdirs(this.saveDirectory);
        }
        try {
            this.reportlet = EngineModuleFactory.generateReportlet(this.reportPath);
            File file = new File(StableUtils.pathJoin(new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", this.reportPath}));
            if (!file.exists()) {
                this.log.error("[Schedule] Not found reportlet: " + this.reportPath);
                return;
            }
            ScheduleUtils.calculatorParameters(this.getExecuteParameter(), this.record_list, this.arrayParaList);
            this.viewScheduleSavedInfo = new ViewScheduleSavedInfo();
            this.viewScheduleSavedInfo.setShowType(1);
            if (!this.arrayParaList.isEmpty()) {
                this.viewScheduleSavedInfo.setFArrayParameters(this.arrayParaList.toArray(new Parameter[this.arrayParaList.size()]));
            }
            String[] stringArray = new String[this.arrayParaList.size()];
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = ((Parameter)this.arrayParaList.get(i2)).getName();
            }
            ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
            ScheduleUserAndCPRFile scheduleUserAndCPRFile = new ScheduleUserAndCPRFile();
            if (scheduledOutput.isSendEmailByUsername()) {
                this.sendEmailByUserName(this.record_list, stringArray);
            }
            if (scheduledOutput.isCreateCPRByUsername()) {
                String string = scheduledOutput.getUsernames();
                String[] stringArray2 = new String[]{};
                if (StringUtils.isNotBlank(string)) {
                    stringArray2 = string.split(",");
                }
                int n3 = stringArray2.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (scheduleUserAndCPRFile.hasUser(stringArray2[i3])) continue;
                    this.currentUserName = stringArray2[i3];
                    String string2 = this.executeReportByUsername(this.record_list, stringArray, false, false);
                    scheduleUserAndCPRFile.addPath(this.currentUserName, string2);
                }
                if (scheduledOutput.getOutputFileActionList().size() > 0) {
                    this.currentUserName = null;
                    this.executeReportByUsername(this.record_list, stringArray, false, true);
                }
            } else {
                this.currentUserName = null;
                this.executeReportByUsername(this.record_list, stringArray, false, true);
            }
            if (!scheduleUserAndCPRFile.isEmpty()) {
                this.writeUserCprXML(scheduleUserAndCPRFile);
            }
            this.log.info("[Schedule] The Task '" + this.scheduleTask.getName() + "' of " + this.reportPath + " has finished!");
        }
        catch (Exception exception) {
            this.dealWithException(exception);
        }
    }

    private void addEmailParameterAndResultBook(Map map, ResultWorkBook resultWorkBook) {
        EmailNotification emailNotification;
        if (map == null || map.isEmpty()) {
            return;
        }
        FileActionList fileActionList = this.scheduleTask.getScheduledOutput().getOutputFileActionList();
        if (fileActionList != null && (emailNotification = fileActionList.getEmailNotification()) != null) {
            emailNotification.setParameters(map);
            emailNotification.setBook(resultWorkBook);
        }
    }

    private void sendEmailByUserName(List list, String[] stringArray) throws Exception {
        FileActionList fileActionList = this.scheduleTask.getScheduledOutput().getOutputFileActionList();
        EmailNotification emailNotification = fileActionList.getEmailNotification();
        String string = emailNotification.getToAddress();
        for (String this.currentUserName : this.getUserNameFromAddress(string)) {
            this.executeReportByUsername(list, stringArray, true, false);
        }
        fileActionList.setEmailNotification(null);
    }

    private String[] getUserNameFromAddress(String string) {
        if (StringUtils.isBlank(string)) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        block0: for (String string2 : stringArray) {
            EmailManager emailManager = ConfigManager.getInstance().getEmailManager();
            Map map = emailManager.getAllUsersMap();
            for (String string3 : map.keySet()) {
                if (!ComparatorUtils.equals(string2, map.get(string3))) continue;
                stringArray2[var4_4] = string3;
                continue block0;
            }
        }
        return stringArray2;
    }

    private String executeReportByUsername(List list, String[] stringArray, boolean bl, boolean bl2) throws Exception {
        File[] fileArray;
        String string = this.scheduleTask.getReportletPath();
        String string2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf("."));
        ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
        ArrayList arrayList = new ArrayList();
        File file = new File(this.saveDirectory.getAbsolutePath() + File.separator + this.currentUserName);
        if (StringUtils.isBlank(this.currentUserName)) {
            file = this.saveDirectory;
        }
        if (!file.exists()) {
            StableUtils.mkdirs(file);
        }
        File[] fileArray2 = new File[]{};
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            fileArray = (File[])list.get(i2);
            if (StringUtils.isNotEmpty(this.currentUserName)) {
                fileArray.put("fr_username", this.getFSUserName());
            } else {
                fileArray.put("fr_username", "");
            }
            TemplateWorkBook templateWorkBook = null;
            try {
                templateWorkBook = this.reportlet.createReport(new ScheduleReportletRequestImpl((Map)fileArray));
            }
            catch (WebletException webletException) {
                this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", string));
            }
            if (templateWorkBook == null) {
                this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", string));
                return null;
            }
            Calculator.putThreadSavedNameSpace(ParameterMapNameSpace.create((Map)fileArray));
            PageWorkBook pageWorkBook = (PageWorkBook)templateWorkBook.execute((Map)fileArray, ActorFactory.getActor("page"));
            if (!this.checkExecuteFormula((Map)fileArray, pageWorkBook)) {
                return null;
            }
            this.addEmailParameterAndResultBook((Map)fileArray, pageWorkBook);
            String string3 = ScheduleUtils.createOutputReportName(string2, i2, stringArray);
            fileArray2 = scheduledOutput.exportReportFiles(pageWorkBook, string3, file);
            this.dealWithInfo(this.scheduleTask, fileArray2, (Map)fileArray, arrayList, this.currentUserName);
        }
        this.exportViewScheduleSavedInfo(this.viewScheduleSavedInfo);
        if (bl) {
            EmailNotification emailNotification = scheduledOutput.getOutputFileActionList().getEmailNotification();
            String string4 = ConfigManager.getInstance().getEmailManager().getAddress(this.currentUserName);
            if (StringUtils.isNotBlank(string4)) {
                try {
                    fileArray = emailNotification.getFilesToDealWith(arrayList.toArray(new File[arrayList.size()]));
                    emailNotification.doFileAction(fileArray, string4);
                    DoFileActionJob.recordSuccess(this.scheduleTask, this.currentUserName);
                }
                catch (EmailException emailException) {
                    this.log.error(emailException.getMessage());
                    DoFileActionJob.recordError(this.scheduleTask, emailException, arrayList, this.currentUserName);
                }
            }
            return fileArray2[0].getAbsolutePath();
        }
        if (bl2) {
            DoFileActionJob.doFileAction(this.scheduleTask, Arrays.asList(fileArray2));
        }
        return fileArray2[0].getAbsolutePath();
    }

    private String getFSUserName() {
        String string = "(?<=\\()(.+?)(?=\\))";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(this.currentUserName);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return this.currentUserName;
    }

    private void dealWithInfo(ScheduleTask scheduleTask, File[] fileArray, Map map, List list, String string) {
        String string2 = Inter.getLocText("CPR_SUCESS");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank(string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        this.log.scheduleInfo(scheduleTask.getName(), string2);
        scheduleTask.setCounts(0);
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.viewScheduleSavedInfo.addMapTemplateFileName(map, fileArray[i2].getName());
            if (fileArray[i2].getName().endsWith(".cpr")) continue;
            list.add(fileArray[i2]);
        }
    }

    protected void dealWithException(Exception exception) {
        String string = Inter.getLocText("CPR_FAILED");
        if (this.scheduleTask.getCounts() > 0) {
            string = string + ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank(this.currentUserName)) {
            string = string + ScheduleLogUtils.combineByBrackets("User", this.currentUserName);
        }
        this.log.scheduleError(this.scheduleTask.getName(), string, exception);
        this.restartTask();
        ScheduleLogUtils.error(exception);
    }

    private void exportViewScheduleSavedInfo(ViewScheduleSavedInfo viewScheduleSavedInfo) throws FileNotFoundException {
        BaseXMLUtils.writeXMLFile(new FileOutputStream(new File(this.saveDirectory, "info.xml")), viewScheduleSavedInfo);
    }

    private void writeUserCprXML(ScheduleUserAndCPRFile scheduleUserAndCPRFile) throws FileNotFoundException {
        BaseXMLUtils.writeXMLFile(new FileOutputStream(new File(this.saveDirectory, "usercpr.xml")), scheduleUserAndCPRFile);
    }

    private class ScheduleReportletRequestImpl
    implements ReportletRequest {
        private Map map = null;

        public ScheduleReportletRequestImpl(Map map) {
            this.map = map;
        }

        public Object getParameter(String string) {
            return this.map.get(string);
        }
    }
}

