/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.data.impl.sap.SAPTransfer;
import com.fr.data.impl.sap.SAPTransferManager;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.schedule.entry.SAPSynManager;
import com.fr.schedule.task.SAPSynTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.transfer.cal.PCSE;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class SAPSynJob
implements Job {
    private FRLogger log = FRLogger.getLogger();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SAPSynTask sAPSynTask = null;
        try {
            Date date = jobExecutionContext.getScheduledFireTime();
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            long l2 = jobDataMap.getLong("__task__");
            sAPSynTask = jobDataMap.get((Object)"__restarttask__") != null ? (SAPSynTask)jobDataMap.get((Object)"__restarttask__") : (SAPSynTask)ScheduleContext.createDAOSession().load(SAPSynTask.class, l2);
            if (sAPSynTask == null) {
                return;
            }
            String[] stringArray = sAPSynTask.getTransferNames();
            if (stringArray == null) {
                this.log.error("[Schedule] SAPSynJob : Transfer Names is Null...");
                return;
            }
            SAPTransfer[] sAPTransferArray = new SAPTransfer[stringArray.length];
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sAPTransferArray[i2] = SAPTransferManager.getInstance().getSAPTransfer(stringArray[i2]);
                if (sAPTransferArray[i2] != null) continue;
                this.log.error("[Schedule] SAPSynJob : The transfer " + stringArray[i2] + " can not found...");
                return;
            }
            this.log.info("[Schedule] The SAP Syn Task '" + sAPSynTask.getName() + "' of " + this.showNames(stringArray) + " starts!");
            this.executeTransfer(sAPSynTask, sAPTransferArray, date);
        }
        catch (RuntimeException runtimeException) {
            ScheduleLogUtils.error(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
        }
    }

    private String showNames(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i2]);
        }
        return stringBuffer.toString();
    }

    private void executeTransfer(SAPSynTask sAPSynTask, SAPTransfer[] sAPTransferArray, Date date) {
        Calculator calculator = this.initCalculator(date);
        Parameter[] parameterArray = sAPSynTask.getParametersToArray();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Parameter parameter : parameterArray) {
            Object object = parameter.getValue();
            if (parameter.getValue() instanceof Formula) {
                try {
                    object = calculator.evalValue((Formula)object);
                }
                catch (Exception exception) {
                    this.log.error("[Schedule] The SAP Syn Task '" + sAPSynTask.getName() + "'s parameter(" + parameter.getName() + ") cal error, task stop : " + exception.getMessage(), exception);
                    return;
                }
            }
            hashMap.put(parameter.getName(), object);
        }
        try {
            PCSE.executeTransfer(sAPTransferArray, hashMap);
            String string = Inter.getLocText("Trans_SUCCESS");
            if (sAPSynTask.getCounts() > 0) {
                string = string + ScheduleLogUtils.combineByBrackets("RESTART", sAPSynTask.getCounts());
            }
            this.log.sapSynInfo(sAPSynTask.getName(), string);
            sAPSynTask.setCounts(0);
            this.log.info("[Schedule] The SAP Syn Task '" + sAPSynTask.getName() + "' has finished!");
        }
        catch (Exception exception) {
            String string = Inter.getLocText("Trans_FAILED");
            if (sAPSynTask.getCounts() > 0) {
                string = string + ScheduleLogUtils.combineByBrackets("RESTART", sAPSynTask.getCounts());
            }
            this.log.sapSynError(sAPSynTask.getName(), string, exception);
            SAPSynManager.reStartTask(sAPSynTask, Integer.parseInt(sAPSynTask.getRepeatTime()) * 60 * 1000);
            ScheduleLogUtils.error(exception);
            return;
        }
    }

    private Calculator initCalculator(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        Calculator calculator = Calculator.createCalculator();
        calculator.set("$date", calendar.getTime());
        return calculator;
    }
}

