/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.io.TemplateWorkBookIO;
import com.fr.main.TemplateWorkBook;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.FTPException;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DoFileActionJob
implements Job {
    private static FRLogger log = FRLogger.getLogger();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        ScheduleTask scheduleTask = (ScheduleTask)jobDataMap.get((Object)"__restarttask__");
        List list = (List)jobDataMap.get((Object)"__attachlist__");
        DoFileActionJob.doFileAction(scheduleTask, list);
    }

    public static void doFileAction(ScheduleTask scheduleTask, List list) {
        ScheduledOutput scheduledOutput = scheduleTask.getScheduledOutput();
        if (scheduledOutput.getOutputFileActionList().size() == 0) {
            scheduledOutput.synFileActionList();
        }
        ArrayList arrayList = scheduledOutput.getOutputFileActionList() == null ? new ArrayList() : scheduledOutput.getOutputFileActionList();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            OutputFileAction outputFileAction = (OutputFileAction)arrayList.get(i2);
            if (outputFileAction == null) continue;
            File[] fileArray = outputFileAction.getFilesToDealWith(list.toArray(new File[list.size()]));
            try {
                outputFileAction.doFileAction(fileArray);
                DoFileActionJob.recordSuccess(scheduleTask, null);
                continue;
            }
            catch (Exception exception) {
                DoFileActionJob.recordError(scheduleTask, exception, list, null);
            }
        }
    }

    private static Parameter[] getTaskTplParameters(ScheduleTask scheduleTask) {
        Object[] objectArray = scheduleTask.getParametersToArray();
        if (ArrayUtils.isEmpty(objectArray)) {
            String string = scheduleTask.getReportletPath();
            TemplateWorkBook templateWorkBook = null;
            try {
                templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook(FRContext.getCurrentEnv(), string);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
            objectArray = templateWorkBook.getParameters();
        }
        return objectArray;
    }

    public static void recordError(ScheduleTask scheduleTask, Exception exception, List list, String string) {
        String string2 = Inter.getLocText(new String[]{"Attach_File", "Send"}) + ":" + Inter.getLocText("Failed");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank(string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        if (exception instanceof EmailException) {
            log.scheduleError(scheduleTask.getName(), string2, exception, Inter.getLocText(new String[]{"Mail", "HJS-Send_Failed"}));
            ScheduleTask scheduleTask2 = null;
            try {
                scheduleTask2 = scheduleTask.clone4Exe();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                log.error(cloneNotSupportedException.getMessage());
            }
            scheduleTask2.setCounts(scheduleTask2.getCounts() + 1);
            if (scheduleTask2.getCounts() > Integer.parseInt(scheduleTask2.getRepeatTimes()) || Integer.parseInt(scheduleTask2.getRepeatTimes()) == 0) {
                return;
            }
            DoFileActionJob.scheduleFileRestartTask(scheduleTask2, list);
        } else if (exception instanceof FTPException) {
            log.scheduleError(scheduleTask.getName(), string2, exception, "FTP" + Inter.getLocText(new String[]{"Upload", "Failed"}));
            scheduleTask.setCounts(scheduleTask.getCounts() + 1);
            if (scheduleTask.getCounts() > Integer.parseInt(scheduleTask.getRepeatTimes()) || Integer.parseInt(scheduleTask.getRepeatTimes()) == 0) {
                return;
            }
            DoFileActionJob.scheduleFileRestartTask(scheduleTask, list);
        }
    }

    public static void recordSuccess(ScheduleTask scheduleTask, String string) {
        String string2 = Inter.getLocText(new String[]{"Attach_File", "Send"}) + ":" + Inter.getLocText("Successfully");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank(string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        log.scheduleInfo(scheduleTask.getName(), string2);
        scheduleTask.setCounts(0);
    }

    public static void scheduleFileRestartTask(ScheduleTask scheduleTask, List list) {
        int n2 = Integer.parseInt(scheduleTask.getRepeatTime()) * 60 * 1000;
        OnceITrigger onceITrigger = new OnceITrigger();
        onceITrigger.setStartType(2L);
        onceITrigger.setId(scheduleTask.getITrigger().getId());
        onceITrigger.setStartTime(new Date(new Date().getTime() + (long)n2));
        JobDetail jobDetail = new JobDetail(scheduleTask.getName() + Math.random() * 10000.0, "FileActionRestart", DoFileActionJob.class);
        jobDetail.getJobDataMap().put((Object)"__restarttask__", (Object)scheduleTask);
        jobDetail.getJobDataMap().put((Object)"__attachlist__", (Object)list);
        Trigger trigger = onceITrigger.createTrigger();
        trigger.setName(trigger.getName() + "_FileRestart_" + Math.random());
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }
}

