/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.data.DataUtils;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.BasePrivilegeFilter;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.general.FRLogger;
import com.fr.general.privilege.NoCheckHyperLinkSessionAttribute;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.stable.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthorityControlFilter
extends BasePrivilegeFilter {
    public PrivilegeVote filter(HttpServletRequest httpServletRequest) {
        PrivilegeVote privilegeVote;
        String string;
        FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
        if (fSAuthentication == null) {
            try {
                AbstractFSAuthService.dealCookie(httpServletRequest, null);
                fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = DataUtils.getHTTPRequestParameter(httpServletRequest, "reportlet")) == null) {
            string = DataUtils.getHTTPRequestParameter(httpServletRequest, "formlet");
        }
        int n2 = AuthorityControlFilter.createCheckType(httpServletRequest);
        if (string == null) {
            boolean bl = true;
            try {
                String string2 = DataUtils.getHTTPRequestParameter(httpServletRequest, "reportlets");
                if (StringUtils.isEmpty(string2)) {
                    return PrivilegeVoteImpls.MP_AUTH_ERROR;
                }
                JSONArray jSONArray = new JSONArray(string2);
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        Object object = jSONObject.get(string3);
                        if (this.access(fSAuthentication, String.valueOf(object), n2).isPermitted()) continue;
                        bl = false;
                    }
                }
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
            if (bl) {
                return PrivilegeVoteImpls.SUCCESS;
            }
        }
        if (!(privilegeVote = this.access(fSAuthentication, string, n2)).isPermitted()) {
            return this.isHyperLinkNoCheck(httpServletRequest, fSAuthentication);
        }
        return privilegeVote;
    }

    protected PrivilegeVote isHyperLinkNoCheck(HttpServletRequest httpServletRequest, FSAuthentication fSAuthentication) {
        String string;
        String string2;
        long l2;
        HttpSession httpSession;
        NoCheckHyperLinkSessionAttribute noCheckHyperLinkSessionAttribute;
        String string3 = DataUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        if (string3 == null) {
            string3 = DataUtils.getHTTPRequestParameter(httpServletRequest, "formlet");
        }
        if ((noCheckHyperLinkSessionAttribute = (NoCheckHyperLinkSessionAttribute)(httpSession = httpServletRequest.getSession(true)).getAttribute("fr_nocheck_hyperlinkinfo")) != null && noCheckHyperLinkSessionAttribute.isOneOfTheHyperlinks(string3) && (l2 = noCheckHyperLinkSessionAttribute.checkAlive(string2 = (String)httpSession.getAttribute("fr_username"), string = DataUtils.getHTTPRequestParameter(httpServletRequest, "op"), string3)) > 0L) {
            if (System.currentTimeMillis() - l2 <= this.getTimeout()) {
                return PrivilegeVoteImpls.SUCCESS;
            }
            return PrivilegeVoteImpls.MP_AUTH_TIMEOUT;
        }
        if (fSAuthentication != null) {
            return PrivilegeVoteImpls.MP_ROLE_ERROR;
        }
        return PrivilegeVoteImpls.MP_AUTH_ERROR;
    }

    private static int createCheckType(HttpServletRequest httpServletRequest) {
        String string = null;
        try {
            string = DataUtils.getHTTPRequestParameter(httpServletRequest, "op");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("write".equalsIgnoreCase(string) || "form".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    private PrivilegeVote access(FSAuthentication fSAuthentication, String string, int n2) {
        if (fSAuthentication == null) {
            return PrivilegeVoteImpls.MP_AUTH_ERROR;
        }
        long l2 = fSAuthentication.getUserInfo().getId();
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return PrivilegeVoteImpls.SUCCESS;
        }
        Set set = new HashSet();
        try {
            set = UserControl.getInstance().getAllTemplatePrivileges(l2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
            if (!string.startsWith(roleTemplatePrivilege.getPath())) continue;
            switch (n2) {
                case 0: {
                    if (roleTemplatePrivilege.getPage() != 1L) break;
                    return PrivilegeVoteImpls.SUCCESS;
                }
                case 2: {
                    if (roleTemplatePrivilege.getWrite() != 1L) break;
                    return PrivilegeVoteImpls.SUCCESS;
                }
            }
        }
        return PrivilegeVoteImpls.MP_ROLE_ERROR;
    }

    public int getID() {
        return 1;
    }
}

