/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.FCValueMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.dao.TaskInfo;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.StringUtils;
import com.fr.web.platform.TransmitParameters;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import oracle.sql.TIMESTAMP;

public class TaskInfoTableMapper
extends ObjectTableMapper {
    public TaskInfoTableMapper() {
        this.initProperties();
    }

    public void initProperties() {
        this.setObjectClass(TaskInfo.class);
        this.setTable(this.createTable());
        this.setFieldColumnMappers(this.generateFieldColumnMapper());
    }

    private Table createTable() {
        return new Table("FR_T_" + DAOUtils.getClassNameWithOutPath(TaskInfo.class));
    }

    private FieldColumnMapper[] generateFieldColumnMapper() {
        return new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(20), false, true), new CommonFieldColumnMapper("name", 12, new ColumnSize(255), true), new CommonFieldColumnMapper("processexecutorid", -5, new ColumnSize(20), true), new CommonFieldColumnMapper("processStarter", -5, new ColumnSize(20), true), new CommonFieldColumnMapper("processName", 12, new ColumnSize(255), true), new CommonFieldColumnMapper("startTime", 93, "startTime", new ColumnSize(), true, new FCValueMapper(){

            public Object field2Value(Object object) {
                return object;
            }

            public Object value2Field(Object object) {
                if (object instanceof Timestamp) {
                    return new Date(((Timestamp)object).getTime());
                }
                if (object instanceof TIMESTAMP) {
                    try {
                        return new Date(((TIMESTAMP)object).timestampValue().getTime());
                    }
                    catch (SQLException sQLException) {
                        FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
                return object;
            }
        }), new CommonFieldColumnMapper("endTime", 93, "endTime", new ColumnSize(), true, new FCValueMapper(){

            public Object field2Value(Object object) {
                return object;
            }

            public Object value2Field(Object object) {
                if (object instanceof Timestamp) {
                    return new Date(((Timestamp)object).getTime());
                }
                if (object instanceof TIMESTAMP) {
                    try {
                        return new Date(((TIMESTAMP)object).timestampValue().getTime());
                    }
                    catch (SQLException sQLException) {
                        FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
                return object;
            }
        }), new CommonFieldColumnMapper("parameters", 12, "parameters", new ColumnSize(), true, new FCValueMapper(){

            public Object field2Value(Object object) {
                if (object == null) {
                    return "";
                }
                TransmitParameters transmitParameters = (TransmitParameters)object;
                String string = "";
                try {
                    string = transmitParameters.createJSON().toString();
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
                return string;
            }

            public Object value2Field(Object object) {
                String string = (String)object;
                if (StringUtils.isBlank(string)) {
                    return null;
                }
                TransmitParameters transmitParameters = null;
                try {
                    transmitParameters = TransmitParameters.parseJSON(new JSONArray(string));
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
                return transmitParameters;
            }
        })};
    }
}

