/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.dao.DaoAccess;
import com.fr.fs.dao.DaoObject;
import com.fr.fs.dao.TaskInfoTableMapper;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONTransform;
import com.fr.web.platform.TransmitParameters;
import java.util.Date;
import java.util.logging.Level;

public class TaskInfo
extends DaoObject
implements JSONTransform {
    public static final String PROCESSEXECUTORID = "processexecutorid";
    public static final String PROCESSNAME = "processName";
    public static final String PARAMETERS = "parameters";
    public static final String STARTTIME = "startTime";
    public static final String ENDTIME = "endTime";
    public static final String PROCESSSTARTER = "processStarter";
    private static DaoAccess daoAccess = null;
    private static ObjectTableMapper tableMapper = null;
    private String name;
    private Date startTime;
    private Date endTime;
    private long processexecutorid = -1L;
    private String processName;
    private TransmitParameters parameters = new TransmitParameters();
    private long processStarter = -1L;

    public TaskInfo() {
    }

    public TaskInfo(String string, Date date, Date date2, long l2, String string2) {
        this(string, date, date2, l2, string2, null, -1L);
    }

    public TaskInfo(String string, Date date, long l2, String string2, TransmitParameters transmitParameters, long l3) {
        this(string, date, null, l2, string2, transmitParameters, l3);
    }

    public TaskInfo(String string, Date date, Date date2, long l2, String string2, TransmitParameters transmitParameters, long l3) {
        this.name = string;
        this.startTime = date;
        this.endTime = date2;
        this.processexecutorid = l2;
        this.processName = string2;
        this.parameters = transmitParameters;
        this.processStarter = l3;
    }

    public long getProcessStarter() {
        return this.processStarter;
    }

    public void setProcessStarter(long l2) {
        this.processStarter = l2;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public static DaoAccess getDaoAccess() {
        if (daoAccess == null) {
            daoAccess = new DaoAccess(TaskInfo.class);
        }
        return daoAccess;
    }

    public static ObjectTableMapper getObjectTableMapper() {
        if (tableMapper == null) {
            tableMapper = new TaskInfoTableMapper();
        }
        return tableMapper;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public long getProcessexecutorid() {
        return this.processexecutorid;
    }

    public void setProcessexecutorid(long l2) {
        this.processexecutorid = l2;
    }

    protected int hashCode4Properties() {
        return 0;
    }

    public boolean equals4Properties(Object object) {
        return false;
    }

    public void save() {
        this.setId(TaskInfo.getDaoAccess().save(this));
    }

    public void update() {
        if (this.getId() < 0L) {
            FRContext.getLogger().log(Level.INFO, "Need ID to update!");
            return;
        }
        TaskInfo.getDaoAccess().update(this);
    }

    public void remove() {
        if (this.getId() < 0L) {
            FRContext.getLogger().log(Level.INFO, "Need ID to remove!");
            return;
        }
        TaskInfo.getDaoAccess().removeByID(this.getId());
    }

    public void parseJSON(JSONObject jSONObject) {
    }

    public JSONObject createJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", this.getId());
            jSONObject.put("name", this.name);
            if (this.processexecutorid > -1L) {
                jSONObject.put(PROCESSEXECUTORID, this.processexecutorid);
            }
            jSONObject.put("processname", this.processName);
            jSONObject.put("starttime", DateUtils.DATETIMEFORMAT2.format(this.startTime));
            if (this.endTime != null) {
                jSONObject.put("endtime", DateUtils.DATETIMEFORMAT2.format(this.endTime));
            }
            jSONObject.put("tags", this.parameters.createJSON());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }
}

