/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.systemmanager;

import com.fr.base.FRContext;
import com.fr.bi.fs.BIReportNode;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.fs.FSConfig;
import com.fr.fs.adhoc.ADHOCReportNode;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.dao.TaskInfoUser;
import com.fr.function.DATE;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.stable.Primitive;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SystemManagerFavoriteAndADHOC
implements XMLable {
    private static final long serialVersionUID = 5259276608463171496L;
    private static SystemManagerFavoriteAndADHOC sysFavoriteAndADHOC;
    private EmbeddedTableData sysFavoriteTableData;
    private EmbeddedTableData sysADHOCTableData;
    private EmbeddedTableData sysBITableData;
    private EmbeddedTableData sysTaskTableData;
    private Map sysFavoriteNode_idMap = new Hashtable();
    private Map sysADHOCNode_idMap = new Hashtable();
    private Map sysBINode_idMap = new Hashtable();
    private Map sysTaskNode_idMap = new Hashtable();

    public static SystemManagerFavoriteAndADHOC getInstance() {
        if (sysFavoriteAndADHOC == null) {
            sysFavoriteAndADHOC = new SystemManagerFavoriteAndADHOC();
        }
        return sysFavoriteAndADHOC;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            // empty if block
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("sysFavorite".equals(string)) {
                xMLableReader.readXMLObject(this.getSysFavoriteTabledata());
            } else if ("sysADHOCNode".equals(string)) {
                xMLableReader.readXMLObject(this.getSysADHOCTabledata());
            } else if ("sysBINode".equals(string)) {
                xMLableReader.readXMLObject(this.getSysBITabledata());
            } else if ("sysTaskNode".equals(string)) {
                xMLableReader.readXMLObject(this.getSysTaskTableData());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.sysFavoriteTableData != null) {
            xMLPrintWriter.startTAG("sysFavorite");
            this.getSysFavoriteTabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sysADHOCTableData != null) {
            xMLPrintWriter.startTAG("sysADHOCNode");
            this.getSysADHOCTabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sysBITableData != null) {
            xMLPrintWriter.startTAG("sysBINode");
            this.getSysBITabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sysTaskTableData != null) {
            xMLPrintWriter.startTAG("sysTaskNode");
            this.getSysTaskTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private EmbeddedTableData getSysFavoriteTabledata() {
        if (this.sysFavoriteTableData == null) {
            this.sysFavoriteTableData = this.initEmbeddedTableData(SysFavoriteNodeTable.COLUMNS);
        }
        return this.sysFavoriteTableData;
    }

    private EmbeddedTableData getSysADHOCTabledata() {
        if (this.sysADHOCTableData == null) {
            this.sysADHOCTableData = this.initEmbeddedTableData(SysADHOCReportTable.COLUMNS);
        }
        return this.sysADHOCTableData;
    }

    private EmbeddedTableData getSysBITabledata() {
        if (this.sysBITableData == null) {
            this.sysBITableData = this.initEmbeddedTableData(SysBIReportTable.COLUMNS);
        }
        return this.sysBITableData;
    }

    private EmbeddedTableData getSysTaskTableData() {
        if (this.sysTaskTableData == null) {
            this.sysTaskTableData = this.initEmbeddedTableData(SysTaskTable.COLUMNS);
        }
        return this.sysTaskTableData;
    }

    private EmbeddedTableData initEmbeddedTableData(TableDataDAOControl.ColumnColumn[] columnColumnArray) {
        EmbeddedTableData embeddedTableData = new EmbeddedTableData();
        for (int i2 = 0; i2 < columnColumnArray.length; ++i2) {
            embeddedTableData.addColumn(columnColumnArray[i2].getName(), columnColumnArray[i2].getClazz());
        }
        return embeddedTableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map map = this.sysFavoriteNode_idMap;
        synchronized (map) {
            this.sysFavoriteNode_idMap.clear();
            this.initFavoriteMap();
            this.sysADHOCNode_idMap.clear();
            this.initADHOCMap();
            this.sysBINode_idMap.clear();
            this.initBIMap();
            this.sysTaskNode_idMap.clear();
            this.initTaskMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADHOCMap() {
        Map map = this.sysADHOCNode_idMap;
        synchronized (map) {
            if (this.sysADHOCNode_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = this.getSysADHOCTabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                        ADHOCReportNode aDHOCReportNode = new ADHOCReportNode(l2);
                        aDHOCReportNode.setUserId(-999L);
                        aDHOCReportNode.setPath(embeddedTableData.getValueAt(i2, 1).toString());
                        aDHOCReportNode.setReportName(embeddedTableData.getValueAt(i2, 2).toString());
                        Object object = embeddedTableData.getValueAt(i2, 4);
                        if (object != Primitive.NULL && object != null) {
                            aDHOCReportNode.setDescription(object.toString());
                        }
                        this.sysADHOCNode_idMap.put(l2, aDHOCReportNode);
                        continue;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBIMap() {
        Map map = this.sysBINode_idMap;
        synchronized (map) {
            if (this.sysBINode_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = this.getSysBITabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                        BIReportNode bIReportNode = new BIReportNode(l2);
                        bIReportNode.setUserId(-999L);
                        bIReportNode.setPath(embeddedTableData.getValueAt(i2, 1).toString());
                        bIReportNode.setReportName(embeddedTableData.getValueAt(i2, 2).toString());
                        bIReportNode.setCreateTime(DateUtils.string2Date((String)embeddedTableData.getValueAt(i2, 3), true));
                        bIReportNode.setLastModifyTime(DateUtils.string2Date((String)embeddedTableData.getValueAt(i2, 4), true));
                        Object object = embeddedTableData.getValueAt(i2, 6);
                        if (object != Primitive.NULL && object != null) {
                            bIReportNode.setDescription(object.toString());
                        }
                        this.sysBINode_idMap.put(l2, bIReportNode);
                        continue;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFavoriteMap() {
        Map map = this.sysFavoriteNode_idMap;
        synchronized (map) {
            if (this.sysFavoriteNode_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = this.getSysFavoriteTabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                    FavoriteNode favoriteNode = new FavoriteNode(l2);
                    favoriteNode.setUserId(-999L);
                    favoriteNode.setType((Integer)embeddedTableData.getValueAt(i2, 1));
                    favoriteNode.setEntryid(Long.parseLong(embeddedTableData.getValueAt(i2, 2).toString()));
                    this.sysFavoriteNode_idMap.put(l2, favoriteNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTaskMap() {
        Map map = this.sysTaskNode_idMap;
        synchronized (map) {
            if (this.sysTaskNode_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = this.getSysTaskTableData();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                    TaskInfoUser taskInfoUser = new TaskInfoUser();
                    taskInfoUser.setId(l2);
                    taskInfoUser.setTaskInfoID(new Long(embeddedTableData.getValueAt(i2, 1).toString()));
                    taskInfoUser.setUserID(-999L);
                    this.sysTaskNode_idMap.put(l2, taskInfoUser);
                }
            }
        }
    }

    private void saveSysFavoriteTableData() throws Exception {
        this.sysFavoriteTableData = this.initEmbeddedTableData(SysFavoriteNodeTable.COLUMNS);
        for (Map.Entry entry : this.sysFavoriteNode_idMap.entrySet()) {
            FavoriteNode favoriteNode = (FavoriteNode)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(favoriteNode.getId()));
            arrayList.add(new Integer(favoriteNode.getType()));
            arrayList.add(String.valueOf(favoriteNode.getEntryid()));
            this.sysFavoriteTableData.addRow(arrayList);
        }
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    private void saveSysADHOCTableData() throws Exception {
        this.sysADHOCTableData = this.initEmbeddedTableData(SysADHOCReportTable.COLUMNS);
        for (Map.Entry entry : this.sysADHOCNode_idMap.entrySet()) {
            ADHOCReportNode aDHOCReportNode = (ADHOCReportNode)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(aDHOCReportNode.getId()));
            arrayList.add(aDHOCReportNode.getPath());
            arrayList.add(aDHOCReportNode.getDisplayName());
            arrayList.add(String.valueOf(String.valueOf(aDHOCReportNode.getCreateTime() != null ? aDHOCReportNode.getCreateTime().getTime() : 0L)));
            arrayList.add(aDHOCReportNode.getDescription());
            this.sysADHOCTableData.addRow(arrayList);
        }
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    private void saveSysBITableData() throws Exception {
        this.sysBITableData = this.initEmbeddedTableData(SysBIReportTable.COLUMNS);
        for (Map.Entry entry : this.sysBINode_idMap.entrySet()) {
            BIReportNode bIReportNode = (BIReportNode)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(bIReportNode.getId()));
            arrayList.add(bIReportNode.getPath());
            arrayList.add(bIReportNode.getDisplayName());
            arrayList.add(String.valueOf(bIReportNode.getCreateTime().getTime()));
            arrayList.add(String.valueOf(bIReportNode.getLastModifyTime().getTime()));
            arrayList.add(String.valueOf(-1));
            arrayList.add(bIReportNode.getDescription());
            this.sysBITableData.addRow(arrayList);
        }
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    private void saveSysTaskTableData() throws Exception {
        this.sysTaskTableData = this.initEmbeddedTableData(SysTaskTable.COLUMNS);
        for (Map.Entry entry : this.sysTaskNode_idMap.entrySet()) {
            TaskInfoUser taskInfoUser = (TaskInfoUser)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(taskInfoUser.getId()));
            arrayList.add(new Long(taskInfoUser.getTaskInfoID()));
            this.sysTaskTableData.addRow(arrayList);
        }
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    public void saveFavoriteNode(FavoriteNode favoriteNode) throws Exception {
        long l2 = this.generateID(this.sysFavoriteNode_idMap);
        favoriteNode.setId(l2);
        this.sysFavoriteNode_idMap.put(new Long(l2), favoriteNode);
        this.saveSysFavoriteTableData();
    }

    public void saveADHOCNode(ADHOCReportNode aDHOCReportNode) throws Exception {
        long l2 = this.generateID(this.sysADHOCNode_idMap);
        aDHOCReportNode.setId(l2);
        this.sysADHOCNode_idMap.put(new Long(l2), aDHOCReportNode);
        this.saveSysADHOCTableData();
    }

    public void saveOrUpdateBINode(BIReportNode bIReportNode) throws Exception {
        long l2 = bIReportNode.getId() < 0L ? this.generateID(this.sysBINode_idMap) : bIReportNode.getId();
        bIReportNode.setId(l2);
        this.sysBINode_idMap.put(new Long(l2), bIReportNode);
        this.saveSysBITableData();
    }

    public void saveTaskNode(TaskInfoUser taskInfoUser) throws Exception {
        long l2 = this.generateID(this.sysTaskNode_idMap);
        taskInfoUser.setId(l2);
        this.sysTaskNode_idMap.put(new Long(l2), taskInfoUser);
        this.saveSysTaskTableData();
    }

    private long generateID(Map map) {
        long l2 = 1L;
        while (map.get(new Long(l2)) != null) {
            ++l2;
        }
        return l2;
    }

    public boolean deleteADHOCReportById(long l2) throws Exception {
        this.sysADHOCNode_idMap.remove(new Long(l2));
        this.saveSysADHOCTableData();
        return true;
    }

    public boolean deleteBIReportById(long l2) throws Exception {
        this.sysBINode_idMap.remove(new Long(l2));
        this.saveSysBITableData();
        return true;
    }

    public boolean deleteFavoriteNodeById(long l2) throws Exception {
        this.sysFavoriteNode_idMap.remove(new Long(l2));
        this.saveSysFavoriteTableData();
        return true;
    }

    public boolean deleteTaskNodeById(long l2) throws Exception {
        this.sysTaskNode_idMap.remove(new Long(l2));
        this.saveSysTaskTableData();
        return true;
    }

    public List findSysFavoriteNodes() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : this.sysFavoriteNode_idMap.entrySet()) {
            FavoriteNode favoriteNode = (FavoriteNode)entry.getValue();
            arrayList.add(favoriteNode.clone());
        }
        return arrayList;
    }

    public List findSysADHOCReportNodes() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : this.sysADHOCNode_idMap.entrySet()) {
            ADHOCReportNode aDHOCReportNode = (ADHOCReportNode)entry.getValue();
            arrayList.add(aDHOCReportNode.clone());
        }
        return arrayList;
    }

    public List findSysBIReportNodes() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : this.sysBINode_idMap.entrySet()) {
            BIReportNode bIReportNode = (BIReportNode)entry.getValue();
            arrayList.add(bIReportNode.clone());
        }
        return arrayList;
    }

    public List findSysTaskNodes() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : this.sysTaskNode_idMap.entrySet()) {
            TaskInfoUser taskInfoUser = (TaskInfoUser)entry.getValue();
            arrayList.add(taskInfoUser.clone());
        }
        return arrayList;
    }

    public ADHOCReportNode findSysADHOCReportNodeById(long l2) throws CloneNotSupportedException {
        ADHOCReportNode aDHOCReportNode = (ADHOCReportNode)this.sysADHOCNode_idMap.get(new Long(l2));
        if (aDHOCReportNode == null) {
            return aDHOCReportNode;
        }
        return (ADHOCReportNode)aDHOCReportNode.clone();
    }

    public BIReportNode findSysBIReportNodeById(long l2) throws CloneNotSupportedException {
        BIReportNode bIReportNode = (BIReportNode)this.sysBINode_idMap.get(new Long(l2));
        if (bIReportNode == null) {
            return bIReportNode;
        }
        return (BIReportNode)bIReportNode.clone();
    }

    public BIReportNode findSysBIReportNodeByName(String string) throws CloneNotSupportedException {
        Iterator iterator = this.sysBINode_idMap.entrySet().iterator();
        BIReportNode bIReportNode = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BIReportNode bIReportNode2 = (BIReportNode)entry.getValue();
            if (!ComparatorUtils.equals(string, bIReportNode2.getReportName())) continue;
            if (bIReportNode != null) {
                return null;
            }
            bIReportNode = (BIReportNode)bIReportNode2.clone();
        }
        return bIReportNode;
    }

    private static final class SysTaskTable {
        private static final TableDataDAOControl.ColumnColumn[] COLUMNS = new TableDataDAOControl.ColumnColumn[]{new TableDataDAOControl.ColumnColumn("id", String.class), new TableDataDAOControl.ColumnColumn("taskInfoID", String.class)};

        private SysTaskTable() {
        }
    }

    private static final class SysBIReportTable {
        private static final TableDataDAOControl.ColumnColumn[] COLUMNS = new TableDataDAOControl.ColumnColumn[]{new TableDataDAOControl.ColumnColumn("id", String.class), new TableDataDAOControl.ColumnColumn("path", String.class), new TableDataDAOControl.ColumnColumn("reportName", String.class), new TableDataDAOControl.ColumnColumn("createTime", DATE.class), new TableDataDAOControl.ColumnColumn("modifyTime", DATE.class), new TableDataDAOControl.ColumnColumn("type", String.class), new TableDataDAOControl.ColumnColumn("description", String.class)};

        private SysBIReportTable() {
        }
    }

    private static final class SysADHOCReportTable {
        private static final TableDataDAOControl.ColumnColumn[] COLUMNS = new TableDataDAOControl.ColumnColumn[]{new TableDataDAOControl.ColumnColumn("id", String.class), new TableDataDAOControl.ColumnColumn("path", String.class), new TableDataDAOControl.ColumnColumn("reportName", String.class), new TableDataDAOControl.ColumnColumn("createTime", DATE.class), new TableDataDAOControl.ColumnColumn("description", String.class)};

        private SysADHOCReportTable() {
        }
    }

    private static final class SysFavoriteNodeTable {
        private static final TableDataDAOControl.ColumnColumn[] COLUMNS = new TableDataDAOControl.ColumnColumn[]{new TableDataDAOControl.ColumnColumn("id", String.class), new TableDataDAOControl.ColumnColumn("type", Integer.class), new TableDataDAOControl.ColumnColumn("entryid", String.class)};

        private SysFavoriteNodeTable() {
        }
    }
}

