/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.tabledata;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import java.util.List;

public class TableDataFavoriteNodeDAO
implements FavoriteNodeDAO {
    private static TableDataFavoriteNodeDAO tdfnd;

    public static TableDataFavoriteNodeDAO getInstance() {
        if (tdfnd == null) {
            tdfnd = new TableDataFavoriteNodeDAO();
        }
        return tdfnd;
    }

    public void save(FavoriteNode favoriteNode) throws Exception {
        if (favoriteNode == null) {
            throw new RuntimeException("The node don't exist!");
        }
        TableDataSyncDB.getInstance().saveFavoriteNode(favoriteNode);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    public boolean delete(FavoriteNode favoriteNode) throws Exception {
        if (favoriteNode == null) {
            throw new RuntimeException("The node don't exist!");
        }
        TableDataSyncDB.getInstance().deleteFavoriteNode(favoriteNode);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        return true;
    }

    public boolean deleteByID(long l2) throws Exception {
        return this.delete(TableDataSyncDB.getInstance().findFavoriteById(l2));
    }

    public boolean deleteByUserAndEntry(long l2, int n2, long l3) throws Exception {
        TableDataSyncDB.getInstance().deleteFavoriteNode(l2, n2, l3);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        return true;
    }

    public List findByUserID(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findFavoriteNodes(l2);
    }
}

