/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.tabledata;

import com.fr.base.FRContext;
import com.fr.bi.fs.TableDataBIReportNode;
import com.fr.bi.fs.TableDataBISharedReportNode;
import com.fr.bi.fs.control.dao.BIReportDAO;
import com.fr.bi.fs.control.dao.BISharedReportDAO;
import com.fr.bi.fs.control.dao.tabledata.TableDataBIReportDAO;
import com.fr.bi.fs.control.dao.tabledata.TableDataBISharedReportDAO;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.tabledata.TableDataADHOCReportNode;
import com.fr.fs.cache.tabledata.TableDataFavoriteNode;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataSRole_User;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.cache.tabledata.TableDataTask;
import com.fr.fs.control.Control;
import com.fr.fs.control.dao.ADHOCReportDAO;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.control.dao.TaskInfoUserDAO;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.tabledata.TableDataADHOCReportDAO;
import com.fr.fs.control.dao.tabledata.TableDataCompanyRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataDepartmentDAO;
import com.fr.fs.control.dao.tabledata.TableDataFavoriteNodeDAO;
import com.fr.fs.control.dao.tabledata.TableDataPostDAO;
import com.fr.fs.control.dao.tabledata.TableDataTaskInfoUserDAO;
import com.fr.fs.control.dao.tabledata.TableDataUserDAO;
import com.fr.fs.web.FSConstants;
import com.fr.function.DATE;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TableDataDAOControl
implements Control {
    private static final long serialVersionUID = 1192378177381723817L;
    private static TableDataDAOControl tc = null;
    private EmbeddedTableData jRoleTableData;
    private EmbeddedTableData jRolePrivilegeTableData;
    private EmbeddedTableData jRoleESPrivilegeTableData;
    private EmbeddedTableData jRole_ModuleTableData;
    private EmbeddedTableData jRole_TemplatePrivilegeTableData;
    private EmbeddedTableData sRole_TemplatePrivilegeTableData;
    private EmbeddedTableData jRole_DataConnectionPrivilegeTableData;
    private EmbeddedTableData sRole_DataConnectionPrivilegeTableData;
    private Map companyRole_PlateTableData = new HashMap();
    private EmbeddedTableData sRoleTableData;
    private EmbeddedTableData sRolePrivilegeTableData;
    private EmbeddedTableData sRoleESPrivilegeTableData;
    private EmbeddedTableData sRole_ModuleTableData;
    private EmbeddedTableData sRole_UserTableData;
    private EmbeddedTableData companyRole_DepAndCRolePrivilegeTableData;
    private EmbeddedTableData customRole_DepAndCRolePrivilegeTableData;
    private Map customRole_PlateTableData = new HashMap();
    private EmbeddedTableData favorateNodeTableData;
    private EmbeddedTableData ADHOCReportTableData;
    private EmbeddedTableData BIReportTableData;
    private EmbeddedTableData BISharedReportTableData;
    private EmbeddedTableData taskTableData;
    private String dsName;
    private int userNameIndex = -1;
    private int passwordIndex = -1;
    private int departmentIndex = -1;
    private int postIndex = -1;
    private int roleIndex = -1;
    private int nameIndex = -1;
    private int emailIndex = -1;
    private int mobileIndex = -1;
    private PasswordValidator pv;

    public static TableDataDAOControl getInstance() {
        if (tc == null) {
            tc = new TableDataDAOControl();
        }
        return tc;
    }

    public boolean hasSetTableDataSync() {
        return this.getDsName() != null && DatasourceManager.getInstance().getTableData(this.getDsName()) != null && this.getUserNameIndex() > -1 && this.getPasswordIndex() > -1;
    }

    public int getControlType() {
        return 1;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readXML(XMLableReader xMLableReader) {
        this.readAttr(xMLableReader);
        this.readChild(xMLableReader);
    }

    private void readCustomRolesWithPlate(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("CustomRoleWithPlate")) {
                    xMLableReader.readXMLObject(new XMLReadable(){
                        EmbeddedTableData etd = null;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode()) {
                                if (ComparatorUtils.equals(xMLableReader.getTagName(), "PlateName")) {
                                    this.etd = TableDataDAOControl.this.getCustomRoleTableDataByPlateName(xMLableReader.getElementValue());
                                } else if (ComparatorUtils.equals(xMLableReader.getTagName(), "EmbededTableData")) {
                                    xMLableReader.readXMLObject(this.etd);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private void readCompanyRolesWithPlate(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("CompanyRoleWithPlate")) {
                    xMLableReader.readXMLObject(new XMLReadable(){
                        EmbeddedTableData etd = null;

                        public void readXML(XMLableReader xMLableReader) {
                            if (xMLableReader.isChildNode()) {
                                if (ComparatorUtils.equals(xMLableReader.getTagName(), "PlateName")) {
                                    this.etd = TableDataDAOControl.this.getCompanyRoleTableDataByPlateName(xMLableReader.getElementValue());
                                } else if (ComparatorUtils.equals(xMLableReader.getTagName(), "EmbededTableData")) {
                                    xMLableReader.readXMLObject(this.etd);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        try {
            xMLPrintWriter.attr("dsSetting", this.createJSON().toString());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        if (this.jRoleTableData != null) {
            xMLPrintWriter.startTAG("JRole");
            this.getJRoleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRoleTableData != null) {
            xMLPrintWriter.startTAG("SRole");
            this.getSRoleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRole_UserTableData != null) {
            xMLPrintWriter.startTAG("SRole_User");
            this.getSRole_UserTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writePrivilege(xMLPrintWriter);
        this.writeESPrivilege(xMLPrintWriter);
        this.writeDepAndCRolePrivilege(xMLPrintWriter);
        this.writeTemplatePrivilege(xMLPrintWriter);
        this.writeDataConnectionPrivilege(xMLPrintWriter);
        if (this.sRole_ModuleTableData != null) {
            xMLPrintWriter.startTAG("SRoleModule");
            this.getSRole_ModuleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeCustomPlate(xMLPrintWriter);
        if (this.jRole_ModuleTableData != null) {
            xMLPrintWriter.startTAG("JRoleModule");
            this.getJRole_ModuleTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeCompanyPlate(xMLPrintWriter);
        if (this.favorateNodeTableData != null) {
            xMLPrintWriter.startTAG("favorateNode");
            this.getFavoriteNodeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.ADHOCReportTableData != null) {
            xMLPrintWriter.startTAG("ADHOCReport");
            this.getADHOCReportTabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        this.writeBI(xMLPrintWriter);
    }

    private void writePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRolePrivilege");
            this.getJRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRolePrivilege");
            this.getSRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeTemplatePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRole_TemplatePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleTemplatePrivilege");
            this.getJRoleTemplatePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleTemplatePrivilege");
            this.getSRoleTemplatePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeDataConnectionPrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRole_DataConnectionPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleDataConnectionPrivilege");
            this.getJRoleDataConnectionPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRole_DataConnectionPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleDataConnectionPrivilege");
            this.getSRoleDataConnectionPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeDepAndCRolePrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.companyRole_DepAndCRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("CompanyRoleDepAndCRolePrivilege");
            this.getCompanyRoleDepAndCRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.customRole_DepAndCRolePrivilegeTableData != null) {
            xMLPrintWriter.startTAG("CustomRoleDepAndCRolePrivilege");
            this.getCustomRoleDepAndCRolePrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeESPrivilege(XMLPrintWriter xMLPrintWriter) {
        if (this.jRoleESPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("JRoleESPrivilege");
            this.getJRoleESPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.sRoleESPrivilegeTableData != null) {
            xMLPrintWriter.startTAG("SRoleESPrivilege");
            this.getSRoleESPrivilegeTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeCustomPlate(XMLPrintWriter xMLPrintWriter) {
        if (this.customRole_PlateTableData != null) {
            xMLPrintWriter.startTAG("CustomRolesWithPlate");
            Iterator iterator = this.customRole_PlateTableData.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                xMLPrintWriter.startTAG("CustomRoleWithPlate");
                xMLPrintWriter.startTAG("PlateName").textNode(string).end();
                xMLPrintWriter.startTAG("EmbededTableData");
                this.getCustomRoleTableDataByPlateName(string).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    private void writeCompanyPlate(XMLPrintWriter xMLPrintWriter) {
        if (this.companyRole_PlateTableData != null) {
            xMLPrintWriter.startTAG("CompanyRolesWithPlate");
            Iterator iterator = this.companyRole_PlateTableData.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                xMLPrintWriter.startTAG("CompanyRoleWithPlate");
                xMLPrintWriter.startTAG("PlateName").textNode(string).end();
                xMLPrintWriter.startTAG("EmbededTableData");
                this.getCompanyRoleTableDataByPlateName(string).writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    private void writeBI(XMLPrintWriter xMLPrintWriter) {
        if (this.BIReportTableData != null) {
            xMLPrintWriter.startTAG("BIReport");
            this.getBIReportTabledata().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.BISharedReportTableData != null) {
            xMLPrintWriter.startTAG("BISharedReport");
            this.getBISharedReportTableData().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("dsName")) {
            this.setDsName(jSONObject.getString("dsName"));
        } else {
            this.setDsName(null);
        }
        if (jSONObject.has("userName")) {
            this.setUserNameIndex(jSONObject.getInt("userName"));
        } else {
            this.setUserNameIndex(-1);
        }
        if (jSONObject.has("password")) {
            this.setPasswordIndex(jSONObject.getInt("password"));
        } else {
            this.setPasswordIndex(-1);
        }
        if (jSONObject.has("department")) {
            this.setDepartmentIndex(jSONObject.getInt("department"));
        } else {
            this.setDepartmentIndex(-1);
        }
        if (jSONObject.has("post")) {
            this.setPostIndex(jSONObject.getInt("post"));
        } else {
            this.setPostIndex(-1);
        }
        if (jSONObject.has("name")) {
            this.setNameIndex(jSONObject.getInt("name"));
        } else {
            this.setNameIndex(-1);
        }
        if (jSONObject.has("role")) {
            this.setRoleIndex(jSONObject.getInt("role"));
        } else {
            this.setRoleIndex(-1);
        }
        if (jSONObject.has("email")) {
            this.setEmailIndex(jSONObject.getInt("email"));
        } else {
            this.setEmailIndex(-1);
        }
        if (jSONObject.has("mobile")) {
            this.setMobileIndex(jSONObject.getInt("mobile"));
        } else {
            this.setMobileIndex(-1);
        }
        if (jSONObject.has("encrypt")) {
            int n2 = jSONObject.getInt("encrypt");
            if (n2 == 0) {
                this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
            } else if (n2 == 1) {
                ClassPasswordValidator classPasswordValidator = new ClassPasswordValidator();
                classPasswordValidator.setClassName(jSONObject.getString("myencrypt"));
                this.setPv(classPasswordValidator);
            } else {
                this.setPv(MessageDigestPasswordValidator.MD5_PASSWORD_VALIDATOR);
            }
        } else {
            this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
        }
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("dsName", this.getDsName());
        jSONObject.put("userName", this.getUserNameIndex());
        jSONObject.put("password", this.getPasswordIndex());
        jSONObject.put("department", this.getDepartmentIndex());
        jSONObject.put("post", this.getPostIndex());
        jSONObject.put("role", this.getRoleIndex());
        jSONObject.put("name", this.getNameIndex());
        PasswordValidator passwordValidator = this.getPv();
        if (passwordValidator instanceof MessageDigestPasswordValidator) {
            jSONObject.put("encrypt", 2);
            jSONObject.put("myencrypt", "");
        } else if (passwordValidator instanceof ClassPasswordValidator) {
            jSONObject.put("encrypt", 1);
            jSONObject.put("myencrypt", ((ClassPasswordValidator)passwordValidator).getClassName());
        } else {
            jSONObject.put("encrypt", 0);
            jSONObject.put("myencrypt", "");
        }
        jSONObject.put("email", this.getEmailIndex());
        jSONObject.put("mobile", this.getMobileIndex());
        return jSONObject;
    }

    public String getDsName() {
        return this.dsName;
    }

    private void setDsName(String string) {
        this.dsName = string;
    }

    public int getUserNameIndex() {
        return this.userNameIndex;
    }

    private void setUserNameIndex(int n2) {
        this.userNameIndex = n2;
    }

    public int getPasswordIndex() {
        return this.passwordIndex;
    }

    private void setPasswordIndex(int n2) {
        this.passwordIndex = n2;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    private void setPostIndex(int n2) {
        this.postIndex = n2;
    }

    public int getRoleIndex() {
        return this.roleIndex;
    }

    private void setRoleIndex(int n2) {
        this.roleIndex = n2;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    private void setNameIndex(int n2) {
        this.nameIndex = n2;
    }

    public int getDepartmentIndex() {
        return this.departmentIndex;
    }

    private void setDepartmentIndex(int n2) {
        this.departmentIndex = n2;
    }

    public int getEmailIndex() {
        return this.emailIndex;
    }

    private void setEmailIndex(int n2) {
        this.emailIndex = n2;
    }

    public int getMobileIndex() {
        return this.mobileIndex;
    }

    private void setMobileIndex(int n2) {
        this.mobileIndex = n2;
    }

    public EmbeddedTableData getJRoleTableData() {
        if (this.jRoleTableData == null) {
            this.jRoleTableData = this.initEmbeddedTableData(JRoleTable.COLUMNS);
        }
        return this.jRoleTableData;
    }

    public EmbeddedTableData getSRoleTableData() {
        if (this.sRoleTableData == null) {
            this.sRoleTableData = this.initEmbeddedTableData(SRoleTable.COLUMNS);
        }
        return this.sRoleTableData;
    }

    public EmbeddedTableData getJRolePrivilegeTableData() {
        if (this.jRolePrivilegeTableData == null) {
            this.jRolePrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRolePrivilegeTableData;
    }

    public EmbeddedTableData getJRoleTemplatePrivilegeTableData() {
        if (this.jRole_TemplatePrivilegeTableData == null) {
            this.jRole_TemplatePrivilegeTableData = this.initEmbeddedTableData(RoleTemplatePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRole_TemplatePrivilegeTableData;
    }

    public EmbeddedTableData getSRoleTemplatePrivilegeTableData() {
        if (this.sRole_TemplatePrivilegeTableData == null) {
            this.sRole_TemplatePrivilegeTableData = this.initEmbeddedTableData(RoleTemplatePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_TemplatePrivilegeTableData;
    }

    public EmbeddedTableData getJRoleDataConnectionPrivilegeTableData() {
        if (this.jRole_DataConnectionPrivilegeTableData == null) {
            this.jRole_DataConnectionPrivilegeTableData = this.initEmbeddedTableData(RoleDataConnectionPrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRole_DataConnectionPrivilegeTableData;
    }

    public EmbeddedTableData getSRoleDataConnectionPrivilegeTableData() {
        if (this.sRole_DataConnectionPrivilegeTableData == null) {
            this.sRole_DataConnectionPrivilegeTableData = this.initEmbeddedTableData(RoleDataConnectionPrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_DataConnectionPrivilegeTableData;
    }

    public EmbeddedTableData getJRoleESPrivilegeTableData() {
        if (this.jRoleESPrivilegeTableData == null) {
            this.jRoleESPrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.jRoleESPrivilegeTableData;
    }

    public EmbeddedTableData getSRolePrivilegeTableData() {
        if (this.sRolePrivilegeTableData == null) {
            this.sRolePrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRolePrivilegeTableData;
    }

    public EmbeddedTableData getSRoleESPrivilegeTableData() {
        if (this.sRoleESPrivilegeTableData == null) {
            this.sRoleESPrivilegeTableData = this.initEmbeddedTableData(RolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.sRoleESPrivilegeTableData;
    }

    public EmbeddedTableData getCompanyRoleDepAndCRolePrivilegeTableData() {
        if (this.companyRole_DepAndCRolePrivilegeTableData == null) {
            this.companyRole_DepAndCRolePrivilegeTableData = this.initEmbeddedTableData(Role_DepAndCRolePrivilegeTable.COMPANYCOLUMNS);
        }
        return this.companyRole_DepAndCRolePrivilegeTableData;
    }

    public EmbeddedTableData getCustomRoleDepAndCRolePrivilegeTableData() {
        if (this.customRole_DepAndCRolePrivilegeTableData == null) {
            this.customRole_DepAndCRolePrivilegeTableData = this.initEmbeddedTableData(Role_DepAndCRolePrivilegeTable.CUSTOMROLECOLUMNS);
        }
        return this.customRole_DepAndCRolePrivilegeTableData;
    }

    public EmbeddedTableData getSRole_UserTableData() {
        if (this.sRole_UserTableData == null) {
            this.sRole_UserTableData = this.initEmbeddedTableData(SRole_UserTable.COLUMNS);
        }
        return this.sRole_UserTableData;
    }

    public EmbeddedTableData getSRole_ModuleTableData() {
        if (this.sRole_ModuleTableData == null) {
            this.sRole_ModuleTableData = this.initEmbeddedTableData(Role_ModuleTable.CUSTOMROLECOLUMNS);
        }
        return this.sRole_ModuleTableData;
    }

    public EmbeddedTableData getCustomRoleTableDataByPlateName(String string) {
        if (this.customRole_PlateTableData.get(string) != null) {
            return (EmbeddedTableData)this.customRole_PlateTableData.get(string);
        }
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(PlateFactory.getTableDataColumnsWithPlateName(string));
        this.customRole_PlateTableData.put(string, embeddedTableData);
        return embeddedTableData;
    }

    public EmbeddedTableData getJRole_ModuleTableData() {
        if (this.jRole_ModuleTableData == null) {
            this.jRole_ModuleTableData = this.initEmbeddedTableData(Role_ModuleTable.COMPANYCOLUMNS);
        }
        return this.jRole_ModuleTableData;
    }

    public EmbeddedTableData getCompanyRoleTableDataByPlateName(String string) {
        if (this.companyRole_PlateTableData.get(string) != null) {
            return (EmbeddedTableData)this.companyRole_PlateTableData.get(string);
        }
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(PlateFactory.getTableDataColumnsWithPlateName(string));
        this.companyRole_PlateTableData.put(string, embeddedTableData);
        return embeddedTableData;
    }

    public EmbeddedTableData getFavoriteNodeTableData() {
        if (this.favorateNodeTableData == null) {
            this.favorateNodeTableData = this.initEmbeddedTableData(FavoriteNodeTable.COLUMNS);
        }
        return this.favorateNodeTableData;
    }

    public EmbeddedTableData getADHOCReportTabledata() {
        if (this.ADHOCReportTableData == null) {
            this.ADHOCReportTableData = this.initEmbeddedTableData(ADHOCReportTable.COLUMNS);
        }
        return this.ADHOCReportTableData;
    }

    public EmbeddedTableData getBIReportTabledata() {
        if (this.BIReportTableData == null) {
            this.BIReportTableData = this.initEmbeddedTableData(BIReportTable.COLUMNS);
        }
        return this.BIReportTableData;
    }

    public EmbeddedTableData getBISharedReportTableData() {
        if (this.BISharedReportTableData == null) {
            this.BISharedReportTableData = this.initEmbeddedTableData(BISharedReportTable.COLUMNS);
        }
        return this.BISharedReportTableData;
    }

    public EmbeddedTableData getTaskTabledata() {
        if (this.taskTableData == null) {
            this.taskTableData = this.initEmbeddedTableData(TaskTable.COLUMNS);
        }
        return this.taskTableData;
    }

    public CompanyRoleDAO getCompanyRoleDAO() {
        return TableDataCompanyRoleDAO.getInstance();
    }

    public CustomRoleDAO getCustomRoleDAO() {
        return TableDataCustomRoleDAO.getInstance();
    }

    public UserDAO getUserDAO() {
        return TableDataUserDAO.getInstance();
    }

    public FavoriteNodeDAO getFavoriteNodeDAO() {
        return TableDataFavoriteNodeDAO.getInstance();
    }

    public TaskInfoUserDAO getTaskInfoUserDAO() {
        return TableDataTaskInfoUserDAO.getInstance();
    }

    public ADHOCReportDAO getADHOCReportDAO() {
        return TableDataADHOCReportDAO.getInstance();
    }

    public BIReportDAO getBIReportDAO() {
        return TableDataBIReportDAO.getInstance();
    }

    public BISharedReportDAO getBISharedReportDAO() {
        return TableDataBISharedReportDAO.getInstance();
    }

    public DepartmentDAO getDepartmentDAO() {
        return TableDataDepartmentDAO.getInstance();
    }

    public PostDAO getPostDAO() {
        return TableDataPostDAO.getInstance();
    }

    public boolean init() {
        try {
            TableDataSyncDB.getInstance().reinit();
            FSConfig.getInstance().clearCache();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private EmbeddedTableData initEmbeddedTableData(ColumnColumn[] columnColumnArray) {
        EmbeddedTableData embeddedTableData = new EmbeddedTableData();
        for (int i2 = 0; i2 < columnColumnArray.length; ++i2) {
            embeddedTableData.addColumn(columnColumnArray[i2].getName(), columnColumnArray[i2].getClazz());
        }
        return embeddedTableData;
    }

    public void writeSRoleTableData(Iterator iterator) {
        this.sRoleTableData = this.initEmbeddedTableData(SRoleTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRole customRole = (CustomRole)entry.getValue();
            if (customRole.getId() <= -1000L) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(customRole.getId()));
            arrayList.add(customRole.getRolename());
            arrayList.add(customRole.getDescription());
            this.sRoleTableData.addRow(arrayList);
        }
    }

    public void writeSRole_UserTableData(Iterator iterator) {
        this.sRole_UserTableData = this.initEmbeddedTableData(SRole_UserTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataSRole_User tableDataSRole_User = (TableDataSRole_User)entry.getValue();
            if (tableDataSRole_User.getsRoleId() < 0L) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataSRole_User.getId()));
            arrayList.add(String.valueOf(tableDataSRole_User.getsRoleId()));
            arrayList.add(tableDataSRole_User.getUserName());
            this.sRole_UserTableData.addRow(arrayList);
        }
    }

    public void writeTaskMap(Iterator iterator) {
        this.taskTableData = this.initEmbeddedTableData(TaskTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataTask tableDataTask = (TableDataTask)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(tableDataTask.getId()));
            arrayList.add(tableDataTask.getUserName());
            arrayList.add(new Long(tableDataTask.getTaskInfoId()));
            this.taskTableData.addRow(arrayList);
        }
    }

    public void writeTableDataFavoriteMap(Iterator iterator) {
        this.favorateNodeTableData = this.initEmbeddedTableData(FavoriteNodeTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(tableDataFavoriteNode.getId()));
            arrayList.add(tableDataFavoriteNode.getUserName());
            arrayList.add(new Integer(tableDataFavoriteNode.getType()));
            arrayList.add(String.valueOf(tableDataFavoriteNode.getEntryid()));
            this.favorateNodeTableData.addRow(arrayList);
        }
    }

    public void writeTableDataADHOCReportMap(Iterator iterator) {
        this.ADHOCReportTableData = this.initEmbeddedTableData(ADHOCReportTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataADHOCReportNode tableDataADHOCReportNode = (TableDataADHOCReportNode)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataADHOCReportNode.getId()));
            arrayList.add(tableDataADHOCReportNode.getUserName());
            arrayList.add(tableDataADHOCReportNode.getPath());
            arrayList.add(tableDataADHOCReportNode.getDisplayName());
            arrayList.add(String.valueOf(tableDataADHOCReportNode.getCreateTime().getTime()));
            arrayList.add(tableDataADHOCReportNode.getDescription());
            this.ADHOCReportTableData.addRow(arrayList);
        }
    }

    public void writeTableDataBIReportMap(Iterator iterator) {
        this.BIReportTableData = this.initEmbeddedTableData(BIReportTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataBIReportNode tableDataBIReportNode = (TableDataBIReportNode)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataBIReportNode.getId()));
            arrayList.add(tableDataBIReportNode.getUserName());
            arrayList.add(tableDataBIReportNode.getPath());
            arrayList.add(tableDataBIReportNode.getDisplayName());
            arrayList.add(String.valueOf(tableDataBIReportNode.getCreateTime().getTime()));
            arrayList.add(String.valueOf(tableDataBIReportNode.getModifyTime().getTime()));
            arrayList.add(String.valueOf(-1));
            arrayList.add(tableDataBIReportNode.getDescription());
            this.BIReportTableData.addRow(arrayList);
        }
    }

    public void writeTableDataBISharedReportMap(Iterator iterator) {
        this.BISharedReportTableData = this.initEmbeddedTableData(BISharedReportTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataBISharedReportNode tableDataBISharedReportNode = (TableDataBISharedReportNode)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(tableDataBISharedReportNode.getId()));
            arrayList.add(String.valueOf(tableDataBISharedReportNode.getTemplateId()));
            arrayList.add(String.valueOf(tableDataBISharedReportNode.getUserId()));
            this.BISharedReportTableData.addRow(arrayList);
        }
    }

    public void writeJRoleTableData(Iterator iterator) {
        this.jRoleTableData = this.initEmbeddedTableData(JRoleTable.COLUMNS);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TableDataJRole tableDataJRole = (TableDataJRole)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(tableDataJRole.getId()));
            arrayList.add(tableDataJRole.getDpName());
            arrayList.add(tableDataJRole.getPostName());
            arrayList.add(tableDataJRole.getDescription());
            arrayList.add(tableDataJRole.getDpId());
            arrayList.add(tableDataJRole.getDpMarkValue());
            this.jRoleTableData.addRow(arrayList);
        }
    }

    public void writeJRoleEnrtyPrivilegeTableData(Iterator iterator) {
        this.jRolePrivilegeTableData = this.writeRolePrivilegeTableData(iterator, RolePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeJRoleDataConnectionPrivilegeTableData(Iterator iterator) {
        this.jRole_DataConnectionPrivilegeTableData = this.writeRoleDataConnectionPrivilegeTableData(iterator, RoleDataConnectionPrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeSRoleDataConnectionPrivilegeTableData(Iterator iterator) {
        this.sRole_DataConnectionPrivilegeTableData = this.writeRoleDataConnectionPrivilegeTableData(iterator, RoleDataConnectionPrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRoleTemplatePrivilegeTableData(Iterator iterator) {
        this.jRole_TemplatePrivilegeTableData = this.writeRoleTemplatePrivilegeTableData(iterator, RoleTemplatePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeSRoleTemplatePrivilegeTableData(Iterator iterator) {
        this.sRole_TemplatePrivilegeTableData = this.writeRoleTemplatePrivilegeTableData(iterator, RoleTemplatePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRoleESPrivilegeTableData(Iterator iterator) {
        this.jRoleESPrivilegeTableData = this.writeRoleESPrivilegeTableData(iterator, RolePrivilegeTable.COMPANYCOLUMNS);
    }

    public void writeCompanyRoleDepAndCRolePrivilegeTableData(Iterator iterator) {
        this.companyRole_DepAndCRolePrivilegeTableData = this.writeRoleDepAndCRolePrivilgeTableData(iterator, Role_DepAndCRolePrivilegeTable.COMPANYCOLUMNS, true);
    }

    public void writeCustomRoleDepAndCRolePrivilegeTableData(Iterator iterator) {
        this.customRole_DepAndCRolePrivilegeTableData = this.writeRoleDepAndCRolePrivilgeTableData(iterator, Role_DepAndCRolePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeSRoleEnrtyPrivilegeTableData(Iterator iterator) {
        this.sRolePrivilegeTableData = this.writeRolePrivilegeTableData(iterator, RolePrivilegeTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeSRoleESPrivilegeTableData(Iterator iterator) {
        this.sRoleESPrivilegeTableData = this.writeRoleESPrivilegeTableData(iterator, RolePrivilegeTable.CUSTOMROLECOLUMNS);
    }

    public void writeJRole_ModulePrivilegeTableData(Iterator iterator) {
        this.jRole_ModuleTableData = this.writeRoleModulePrivilegeTableData(iterator, Role_ModuleTable.COMPANYCOLUMNS, true);
    }

    public void writeSRole_ModulePrivilegeTableData(Iterator iterator) {
        this.sRole_ModuleTableData = this.writeRoleModulePrivilegeTableData(iterator, Role_ModuleTable.CUSTOMROLECOLUMNS, false);
    }

    public void writeJRole_PlatePrivilegeTableData(Iterator iterator, String string) {
        this.companyRole_PlateTableData.put(string, this.writeRolePrivilegeTableData(iterator, PlateFactory.getTableDataColumnsWithPlateName(string), true));
    }

    public void writeSRole_PlatePrivilegeTableData(Iterator iterator, String string) {
        this.customRole_PlateTableData.put(string, this.writeRolePrivilegeTableData(iterator, PlateFactory.getTableDataColumnsWithPlateName(string), false));
    }

    private EmbeddedTableData writeRolePrivilegeTableData(Iterator iterator, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(roleEntryPrivilege.getId()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getRoleId()));
            arrayList.add(new Integer(roleEntryPrivilege.getType()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getEntryid()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getView()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getAuthorized()));
            arrayList.add(String.valueOf(roleEntryPrivilege.getEdit()));
            if (!bl) {
                arrayList.add(((CustomRoleEntryPrivilege)roleEntryPrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleESPrivilegeTableData(Iterator iterator, ColumnColumn[] columnColumnArray) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleESPrivilege roleESPrivilege = (RoleESPrivilege)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(roleESPrivilege.getId()));
            arrayList.add(String.valueOf(roleESPrivilege.getRoleId()));
            arrayList.add(new Integer(roleESPrivilege.getType()));
            arrayList.add(String.valueOf(roleESPrivilege.getEntryid()));
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleDepAndCRolePrivilgeTableData(Iterator iterator, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getId()));
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getRoleid()));
            arrayList.add(new Integer(roleDepAndCRolePrivilege.getType()));
            arrayList.add(String.valueOf(roleDepAndCRolePrivilege.getDeporcroleid()));
            if (!bl) {
                arrayList.add(((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleTemplatePrivilegeTableData(Iterator iterator, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleTemplatePrivilege.getId()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getRoleId()));
            arrayList.add(roleTemplatePrivilege.getPath());
            arrayList.add(String.valueOf(roleTemplatePrivilege.getPage()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getWrite()));
            arrayList.add(String.valueOf(roleTemplatePrivilege.getDesign()));
            if (!bl) {
                arrayList.add(((CustomRoleTemplatePrivilege)roleTemplatePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleDataConnectionPrivilegeTableData(Iterator iterator, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = (RoleDataConnectionPrivilege)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getId()));
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getRoleId()));
            arrayList.add(roleDataConnectionPrivilege.getName());
            arrayList.add(String.valueOf(roleDataConnectionPrivilege.getView()));
            if (!bl) {
                arrayList.add(((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    private EmbeddedTableData writeRoleModulePrivilegeTableData(Iterator iterator, ColumnColumn[] columnColumnArray, boolean bl) {
        EmbeddedTableData embeddedTableData = this.initEmbeddedTableData(columnColumnArray);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleModulePrivilege roleModulePrivilege = (RoleModulePrivilege)entry.getValue();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(String.valueOf(roleModulePrivilege.getId()));
            arrayList.add(String.valueOf(roleModulePrivilege.getRoleId()));
            arrayList.add(new Integer(-1));
            arrayList.add(String.valueOf(roleModulePrivilege.getModuleid()));
            arrayList.add(String.valueOf(roleModulePrivilege.getView()));
            arrayList.add(String.valueOf(roleModulePrivilege.getAuthorized()));
            if (!bl) {
                arrayList.add(((CustomRoleModulePrivilege)roleModulePrivilege).getRoleName());
            }
            embeddedTableData.addRow(arrayList);
        }
        return embeddedTableData;
    }

    public PasswordValidator getPv() {
        if (this.pv == null) {
            this.pv = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
        }
        return this.pv;
    }

    public void setPv(PasswordValidator passwordValidator) {
        this.pv = passwordValidator;
    }

    private void readAttr(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("dsSetting", null)) != null) {
            try {
                this.parseJSON(new JSONObject(string));
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private void readChild(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("JRole".equals(string)) {
                xMLableReader.readXMLObject(this.getJRoleTableData());
            } else if ("SRole".equals(string)) {
                xMLableReader.readXMLObject(this.getSRoleTableData());
            } else if ("SRole_User".equals(string)) {
                xMLableReader.readXMLObject(this.getSRole_UserTableData());
            } else if ("JRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getJRolePrivilegeTableData());
            } else if ("SRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getSRolePrivilegeTableData());
            } else if ("JRoleESPrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getJRoleESPrivilegeTableData());
            } else if ("SRoleESPrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getSRoleESPrivilegeTableData());
            } else if ("SRoleModule".equals(string)) {
                xMLableReader.readXMLObject(this.getSRole_ModuleTableData());
            } else if ("SRoleProcess".equals(string)) {
                xMLableReader.readXMLObject(this.getCustomRoleTableDataByPlateName(FSConstants.PLATE.PROCESS));
            } else if ("JRoleModule".equals(string)) {
                xMLableReader.readXMLObject(this.getJRole_ModuleTableData());
            } else if ("JRoleProcess".equals(string)) {
                xMLableReader.readXMLObject(this.getCompanyRoleTableDataByPlateName(FSConstants.PLATE.PROCESS));
            } else if ("CompanyRolesWithPlate".equals(string)) {
                this.readCompanyRolesWithPlate(xMLableReader);
            } else if ("CustomRolesWithPlate".equals(string)) {
                this.readCustomRolesWithPlate(xMLableReader);
            } else if ("favorateNode".equals(string)) {
                xMLableReader.readXMLObject(this.getFavoriteNodeTableData());
            } else if ("ADHOCReport".equals(string)) {
                xMLableReader.readXMLObject(this.getADHOCReportTabledata());
            } else if ("BIReport".equals(string)) {
                xMLableReader.readXMLObject(this.getBIReportTabledata());
            } else if ("BISharedReport".equals(string)) {
                xMLableReader.readXMLObject(this.getBISharedReportTableData());
            } else if ("CompanyRoleDepAndCRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getCompanyRoleDepAndCRolePrivilegeTableData());
            } else if ("CustomRoleDepAndCRolePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getCustomRoleDepAndCRolePrivilegeTableData());
            } else if ("JRoleTemplatePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getJRoleTemplatePrivilegeTableData());
            } else if ("SRoleTemplatePrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getSRoleTemplatePrivilegeTableData());
            } else if ("JRoleDataConnectionPrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getJRoleDataConnectionPrivilegeTableData());
            } else if ("SRoleDataConnectionPrivilege".equals(string)) {
                xMLableReader.readXMLObject(this.getSRoleDataConnectionPrivilegeTableData());
            }
        }
    }

    public static class ColumnColumn {
        private String name;
        private Class clazz;

        public ColumnColumn(String string, Class clazz) {
            this.setName(string);
            this.setClazz(clazz);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }
    }

    private static final class TaskTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("taskInfoID", String.class)};

        private TaskTable() {
        }
    }

    private static final class BISharedReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("bid", String.class), new ColumnColumn("userId", String.class)};

        private BISharedReportTable() {
        }
    }

    private static final class BIReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("path", String.class), new ColumnColumn("reportName", String.class), new ColumnColumn("createTime", DATE.class), new ColumnColumn("modifyTime", DATE.class), new ColumnColumn("type", Integer.class), new ColumnColumn("description", String.class)};

        private BIReportTable() {
        }
    }

    private static final class ADHOCReportTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("path", String.class), new ColumnColumn("reportName", String.class), new ColumnColumn("createTime", DATE.class), new ColumnColumn("description", String.class)};

        private ADHOCReportTable() {
        }
    }

    private static final class FavoriteNodeTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("userName", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("entryid", String.class)};

        private FavoriteNodeTable() {
        }
    }

    private static final class Role_ModuleTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("moduleid", String.class), new ColumnColumn("view", String.class), new ColumnColumn("authorized", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add(COMPANYCOLUMNS, new ColumnColumn("srolename", String.class));

        private Role_ModuleTable() {
        }
    }

    private static final class Role_DepAndCRolePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("deporcroleid", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add(COMPANYCOLUMNS, new ColumnColumn("srolename", String.class));

        private Role_DepAndCRolePrivilegeTable() {
        }
    }

    private static final class RoleDataConnectionPrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleId", String.class), new ColumnColumn("name", String.class), new ColumnColumn("view", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add(COMPANYCOLUMNS, new ColumnColumn("srolename", String.class));

        private RoleDataConnectionPrivilegeTable() {
        }
    }

    private static final class RoleTemplatePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleId", String.class), new ColumnColumn("path", String.class), new ColumnColumn("page", String.class), new ColumnColumn("write", String.class), new ColumnColumn("design", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add(COMPANYCOLUMNS, new ColumnColumn("srolename", String.class));

        private RoleTemplatePrivilegeTable() {
        }
    }

    private static final class RolePrivilegeTable {
        private static final ColumnColumn[] COMPANYCOLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("roleid", String.class), new ColumnColumn("type", Integer.class), new ColumnColumn("entryid", String.class), new ColumnColumn("view", String.class), new ColumnColumn("authorized", String.class), new ColumnColumn("edit", String.class)};
        private static final ColumnColumn[] CUSTOMROLECOLUMNS = (ColumnColumn[])ArrayUtils.add(COMPANYCOLUMNS, new ColumnColumn("srolename", String.class));

        private RolePrivilegeTable() {
        }
    }

    private static final class SRole_UserTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("sroleid", String.class), new ColumnColumn("username", String.class), new ColumnColumn("srolename", String.class)};

        private SRole_UserTable() {
        }
    }

    private static final class SRoleTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("rolename", String.class), new ColumnColumn("description", String.class)};

        private SRoleTable() {
        }
    }

    private static final class JRoleTable {
        private static final ColumnColumn[] COLUMNS = new ColumnColumn[]{new ColumnColumn("id", String.class), new ColumnColumn("department", String.class), new ColumnColumn("post", String.class), new ColumnColumn("description", String.class), new ColumnColumn("departmentid", String.class), new ColumnColumn("dpMarkValue", String.class)};

        private JRoleTable() {
        }
    }
}

