/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.RelationObject;
import com.fr.data.dao.SortInfo;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.dao.FSDAO;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HSQLUserDAO
extends FSDAO
implements UserDAO {
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String FIELD_REALNAME = "realname";
    private static final String FIELD_MALE = "male";
    private static final String FIELD_BIRTHDAY = "birthday";
    private static final String FIELD_MOBILE = "mobile";
    private static final String FIELD_EMAIL = "email";
    private static final HSQLUserDAO SC = new HSQLUserDAO();

    public static HSQLUserDAO getInstance() {
        return SC;
    }

    private HSQLUserDAO() {
    }

    public void save(User user) throws Exception {
        this.createSession().save(user);
    }

    public boolean delete(User user) throws Exception {
        if (user == null) {
            return false;
        }
        return this.deleteByID(user.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            boolean bl2 = dAOSession.deleteByPrimaryKey(User.class, l2);
            dAOSession.commit();
            bl = bl2;
            Object var7_6 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return bl;
    }

    public User findByID(long l2) throws Exception {
        return (User)this.createSession().load(User.class, l2);
    }

    public List findAll() throws Exception {
        return this.createSession().list(User.class);
    }

    public List findAllSortByUserName() throws Exception {
        SortInfo sortInfo = new SortInfo();
        sortInfo.addSortInfo(FIELD_USERNAME, true);
        return this.createSession().list(User.class, sortInfo);
    }

    public boolean update(long l2, String string, String string2, String string3) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        if (StringUtils.isNotBlank(string2)) {
            hashMap.put(FIELD_PASSWORD, string2);
        }
        hashMap.put(FIELD_REALNAME, string3);
        return this.createSession().update(User.class, l2, hashMap);
    }

    public boolean update(long l2, boolean bl, Date date, String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_MALE, bl ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(FIELD_BIRTHDAY, date);
        hashMap.put(FIELD_MOBILE, string);
        hashMap.put(FIELD_EMAIL, string2);
        return this.createSession().update(User.class, l2, hashMap);
    }

    public boolean update(long l2, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        if (StringUtils.isNotBlank(string2)) {
            hashMap.put(FIELD_PASSWORD, string2);
        }
        hashMap.put(FIELD_REALNAME, string3);
        hashMap.put(FIELD_MOBILE, string4);
        hashMap.put(FIELD_EMAIL, string5);
        return this.createSession().update(User.class, l2, hashMap);
    }

    public boolean updatePassword(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_PASSWORD, string);
        return this.createSession().update(User.class, l2, hashMap);
    }

    public User findByUserName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(User.class, FIELD_USERNAME, string);
        if (!list.isEmpty()) {
            return (User)list.get(0);
        }
        return null;
    }

    public User findByUserNameAndPassWord(String string, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        List list = this.createSession().listByFieldValues(User.class, hashMap);
        if (!list.isEmpty()) {
            User user = (User)list.get(0);
            PasswordValidator passwordValidator = HSQLDBDAOControl.getInstance().getPv();
            String string3 = string;
            if (passwordValidator.shouldIgnoreUsername()) {
                string3 = "";
            }
            if (passwordValidator.validatePassword(user.getPassword(), string2, string3)) {
                return user;
            }
        }
        return null;
    }

    public Set getSRoleSet(long l2) throws Exception {
        return this.getSet(l2, EntityDAOConstants.USER.RELATION_ROLE);
    }

    public Set getJobSet(long l2) throws Exception {
        return this.getSet(l2, EntityDAOConstants.USER.RELATION_JOB);
    }

    public Set getUserSet(long l2, long l3) throws Exception {
        if (l2 < 0L || l3 < 0L) {
            return null;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (l2 != CompanyRoleControl.getInstance().getDepartmentAllID()) {
            hashMap.put("Department", new Long(l2));
        }
        if (l3 != CompanyRoleControl.getInstance().getPostAllID()) {
            hashMap.put("Post", new Long(l3));
        }
        List list = this.createSession().getRelationByMap(User.class, EntityDAOConstants.USER.RELATION_JOB, hashMap);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (RelationObject relationObject : list) {
            hashSet.add(relationObject.getValue(User.class));
        }
        return hashSet;
    }

    private Set getSet(long l2, RelationFCMapper relationFCMapper) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), relationFCMapper, User.class, new Long(l2));
        return dAOHashSet.toSet();
    }

    public boolean addJob(long l2, RelationObject relationObject) throws Exception {
        return this.addOrRemove(l2, EntityDAOConstants.USER.RELATION_JOB, relationObject, true);
    }

    public boolean removeJob(long l2, RelationObject relationObject) throws Exception {
        return this.addOrRemove(l2, EntityDAOConstants.USER.RELATION_JOB, relationObject, false);
    }

    public long removeJob(long l2) throws Exception {
        long l3;
        DAOSession dAOSession;
        block7: {
            if (l2 < 0L) {
                return -1L;
            }
            dAOSession = null;
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            RelationObject relationObject = dAOSession.getRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l2);
            boolean bl = false;
            if (relationObject != null) {
                bl = dAOSession.removeRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l2);
            }
            dAOSession.commit();
            if (!bl) break block7;
            long l4 = (Long)relationObject.getValue(User.class);
            Object var9_8 = null;
            this.closeSession(dAOSession);
            return l4;
        }
        try {
            l3 = -1L;
            Object var9_9 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return l3;
    }

    public RelationObject updateJob(long l2, long l3, long l4) throws Exception {
        Cloneable cloneable;
        DAOSession dAOSession;
        block7: {
            if (l2 < 0L) {
                return null;
            }
            dAOSession = null;
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            RelationObject relationObject = dAOSession.getRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l2);
            boolean bl = false;
            if (relationObject != null) {
                cloneable = new HashMap<Class<User>, Long>();
                ((HashMap)cloneable).put(User.class, new Long(l3));
                ((HashMap)cloneable).put(Post.class, new Long(l4));
                bl = dAOSession.updateRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l2, (Map)((Object)cloneable));
            }
            dAOSession.commit();
            if (!bl) break block7;
            cloneable = relationObject;
            Object var12_9 = null;
            this.closeSession(dAOSession);
            return cloneable;
        }
        try {
            cloneable = null;
            Object var12_10 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return cloneable;
    }

    public boolean addSRole(long l2, CustomRole customRole) throws Exception {
        return this.addOrRemove(l2, EntityDAOConstants.USER.RELATION_ROLE, customRole, true);
    }

    public boolean removeSRole(long l2, CustomRole customRole) throws Exception {
        return this.addOrRemove(l2, EntityDAOConstants.USER.RELATION_ROLE, customRole, false);
    }

    private boolean addOrRemove(long l2, RelationFCMapper relationFCMapper, Object object, boolean bl) throws Exception {
        boolean bl2;
        if (l2 < 0L) {
            return false;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            User user = (User)dAOSession.load(User.class, l2);
            if (user == null) {
                throw new RuntimeException("The user don't exist!");
            }
            DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), relationFCMapper, User.class, new Long(l2));
            boolean bl3 = bl ? dAOHashSet.add(object) : dAOHashSet.remove(object);
            dAOSession.commit();
            bl2 = bl3;
            Object var12_11 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return bl2;
    }
}

