/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.UniqueViolationException;
import com.fr.fs.PlateFactory;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.dao.RoleDAO;
import com.fr.fs.dao.FSDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSQLRoleDAO
extends FSDAO
implements RoleDAO {
    @Override
    public Set getEntryPrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getEntryRelation());
    }

    @Override
    public Set getDepAndCrolePrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getDepAndCroleRelation());
    }

    @Override
    public Set getESPrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getESRelation());
    }

    @Override
    public Set getModulePrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getModuleRelation());
    }

    @Override
    public Set getPrivilegesWithPlateName(long l2, String string) throws Exception {
        return this.getPrivileges(l2, this.getRelationFCMapperWithPlateName(string));
    }

    @Override
    public Set getTemplatePrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getTemplateRelation());
    }

    @Override
    public Set getDataConnectionPrivileges(long l2) throws Exception {
        return this.getPrivileges(l2, this.getDataConnectionRelation());
    }

    protected abstract RelationFCMapper getEntryRelation();

    protected abstract RelationFCMapper getESRelation();

    protected abstract RelationFCMapper getModuleRelation();

    protected abstract RelationFCMapper getTemplateRelation();

    protected abstract RelationFCMapper getDataConnectionRelation();

    protected abstract RelationFCMapper getDepAndCroleRelation();

    protected abstract RelationFCMapper getRelationFCMapperWithPlateName(String var1);

    protected abstract Class getRoleClass();

    protected abstract Class getRoleEntryPrivilegeClass();

    protected abstract Class getRoleESPrivilegeClass();

    protected abstract Class getRoleDepAndCrolePrivilegeClass();

    protected abstract Class getRoleModulePrivilegeClass();

    protected abstract Class getRoleTemplatePrivilegeClass();

    protected abstract Class getRoleDataConnectionPrivilegeClass();

    private Set getPrivileges(long l2, RelationFCMapper relationFCMapper) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        DAOSession dAOSession = this.createSession();
        DAOHashSet dAOHashSet = new DAOHashSet(dAOSession, relationFCMapper, this.getRoleClass(), new Long(l2));
        return dAOHashSet.toSet();
    }

    @Override
    public void updateDepAndCrolePrivilege(long l2, List list, List list2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        DAOSession dAOSession = null;
        try {
            try {
                dAOSession = this.createSession();
                dAOSession.beginTransaction();
                Object object = dAOSession.load(this.getRoleClass(), l2);
                if (object == null) {
                    throw new DAOException("The Role is not existed!");
                }
                this.removeDepAndCRolePrivilege(l2, list2, dAOSession);
                this.addDepAndCRolePrivilege(l2, list, dAOSession);
                dAOSession.commit();
            }
            catch (Exception exception) {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.closeSession(dAOSession);
            throw throwable;
        }
        this.closeSession(dAOSession);
    }

    @Override
    public void updateEntryPrivileges(long l2, List list, List list2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        DAOSession dAOSession = null;
        try {
            try {
                EntryTypeAndID entryTypeAndID;
                int n2;
                int n3;
                dAOSession = this.createSession();
                dAOSession.beginTransaction();
                Object object = dAOSession.load(this.getRoleClass(), l2);
                if (object == null) {
                    throw new DAOException("The Role is not existed!");
                }
                if (list2 != null) {
                    n3 = list2.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        entryTypeAndID = (EntryTypeAndID)list2.get(n2);
                        HashMap<String, Number> hashMap = new HashMap<String, Number>(4);
                        hashMap.put("roleId", new Long(l2));
                        hashMap.put("type", new Integer(entryTypeAndID.getType()));
                        hashMap.put("entryid", new Long(entryTypeAndID.getId()));
                        dAOSession.deleteByFields(this.getRoleEntryPrivilegeClass(), hashMap);
                    }
                }
                if (list != null) {
                    n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        entryTypeAndID = (EntryTypeAndID)list.get(n2);
                        RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)this.getRoleEntryPrivilegeClass().newInstance();
                        roleEntryPrivilege.setRoleId(l2);
                        roleEntryPrivilege.setType(entryTypeAndID.getType());
                        roleEntryPrivilege.setEntryid(entryTypeAndID.getId());
                        roleEntryPrivilege.setView(entryTypeAndID.getView());
                        roleEntryPrivilege.setEdit(entryTypeAndID.getEdit());
                        roleEntryPrivilege.setAuthorized(entryTypeAndID.getAuthorized());
                        try {
                            dAOSession.save(roleEntryPrivilege);
                            continue;
                        }
                        catch (UniqueViolationException uniqueViolationException) {
                            // empty catch block
                        }
                    }
                }
                dAOSession.commit();
            }
            catch (Exception exception) {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.closeSession(dAOSession);
            throw throwable;
        }
        this.closeSession(dAOSession);
    }

    @Override
    public void updateESPrivileges(long l2, List list, List list2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        DAOSession dAOSession = null;
        try {
            try {
                EntryTypeAndID entryTypeAndID;
                int n2;
                int n3;
                dAOSession = this.createSession();
                dAOSession.beginTransaction();
                Object object = dAOSession.load(this.getRoleClass(), l2);
                if (object == null) {
                    throw new DAOException("The Role is not existed!");
                }
                if (list2 != null) {
                    n3 = list2.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        entryTypeAndID = (EntryTypeAndID)list2.get(n2);
                        HashMap<String, Number> hashMap = new HashMap<String, Number>(4);
                        hashMap.put("roleId", new Long(l2));
                        hashMap.put("type", new Integer(entryTypeAndID.getType()));
                        hashMap.put("entryid", new Long(entryTypeAndID.getId()));
                        dAOSession.deleteByFields(this.getRoleESPrivilegeClass(), hashMap);
                    }
                }
                if (list != null) {
                    n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        entryTypeAndID = (EntryTypeAndID)list.get(n2);
                        RoleESPrivilege roleESPrivilege = (RoleESPrivilege)this.getRoleESPrivilegeClass().newInstance();
                        roleESPrivilege.setRoleId(l2);
                        roleESPrivilege.setType(entryTypeAndID.getType());
                        roleESPrivilege.setEntryid(entryTypeAndID.getId());
                        try {
                            dAOSession.save(roleESPrivilege);
                            continue;
                        }
                        catch (UniqueViolationException uniqueViolationException) {
                            // empty catch block
                        }
                    }
                }
                dAOSession.commit();
            }
            catch (Exception exception) {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.closeSession(dAOSession);
            throw throwable;
        }
        this.closeSession(dAOSession);
    }

    @Override
    public void updateDataConnectionPrivileges(long l2, List list, List list2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        DAOSession dAOSession = null;
        try {
            try {
                Cloneable cloneable;
                String string;
                int n2;
                int n3;
                dAOSession = this.createSession();
                dAOSession.beginTransaction();
                Object object = dAOSession.load(this.getRoleClass(), l2);
                if (object == null) {
                    throw new DAOException("The Role is not existed!");
                }
                if (list2 != null) {
                    n3 = list2.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = String.valueOf(list2.get(n2));
                        cloneable = new HashMap<String, Long>(4);
                        ((HashMap)cloneable).put("roleId", l2);
                        ((HashMap)cloneable).put("name", string);
                        ((HashMap)cloneable).put("view", 1);
                        dAOSession.deleteByFields(this.getRoleDataConnectionPrivilegeClass(), (Map)((Object)cloneable));
                    }
                }
                if (list != null) {
                    n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = String.valueOf(list.get(n2));
                        cloneable = (RoleDataConnectionPrivilege)this.getRoleDataConnectionPrivilegeClass().newInstance();
                        ((RoleDataConnectionPrivilege)cloneable).setRoleId(l2);
                        ((RoleDataConnectionPrivilege)cloneable).setName(string);
                        ((RoleDataConnectionPrivilege)cloneable).setView(1L);
                        try {
                            dAOSession.save(cloneable);
                            continue;
                        }
                        catch (UniqueViolationException uniqueViolationException) {
                            // empty catch block
                        }
                    }
                }
                dAOSession.commit();
            }
            catch (Exception exception) {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.closeSession(dAOSession);
            throw throwable;
        }
        this.closeSession(dAOSession);
    }

    @Override
    public void updateTemplatePrivileges(long l2, List list, List list2) throws Exception {
        this.updateTemplatePrivileges(l2, this.getTemplateRelation(), list, list2);
    }

    @Override
    public void updateModulePrivileges(long l2, List list, List list2) throws Exception {
        this.updateModulePrivileges(l2, this.getModuleRelation(), list, list2);
    }

    @Override
    public void updatePlatePrivileges(long l2, List list, List list2, String string) throws Exception {
        this.updatePrivilegesWithPlateName(l2, this.getRelationFCMapperWithPlateName(string), list, list2, string);
    }

    private void updateTemplatePrivileges(long l2, RelationFCMapper relationFCMapper, List list, List list2) throws Exception {
        Cloneable cloneable;
        RoleTemplatePrivilege roleTemplatePrivilege;
        int n2;
        int n3;
        DAOSession dAOSession = this.createDAOSession(l2);
        if (dAOSession == null) {
            return;
        }
        if (list2 != null) {
            n3 = list2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                roleTemplatePrivilege = (RoleTemplatePrivilege)list2.get(n2);
                cloneable = new HashMap<String, Long>(4);
                ((HashMap)cloneable).put("roleId", l2);
                ((HashMap)cloneable).put("path", roleTemplatePrivilege.getPath());
                ((HashMap)cloneable).put("page", roleTemplatePrivilege.getPage());
                ((HashMap)cloneable).put("write", roleTemplatePrivilege.getWrite());
                ((HashMap)cloneable).put("design", roleTemplatePrivilege.getDesign());
                dAOSession.deleteByFields(this.getRoleTemplatePrivilegeClass(), (Map)((Object)cloneable));
            }
        }
        if (list != null) {
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                roleTemplatePrivilege = (RoleTemplatePrivilege)list.get(n2);
                cloneable = (RoleTemplatePrivilege)this.getRoleTemplatePrivilegeClass().newInstance();
                ((RoleTemplatePrivilege)cloneable).setRoleId(l2);
                ((RoleTemplatePrivilege)cloneable).setPath(roleTemplatePrivilege.getPath());
                ((RoleTemplatePrivilege)cloneable).setPage(roleTemplatePrivilege.getPage());
                ((RoleTemplatePrivilege)cloneable).setWrite(roleTemplatePrivilege.getWrite());
                ((RoleTemplatePrivilege)cloneable).setDesign(roleTemplatePrivilege.getDesign());
                try {
                    dAOSession.save(cloneable);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
        dAOSession.commit();
        this.closeSession(dAOSession);
    }

    private void updateModulePrivileges(long l2, RelationFCMapper relationFCMapper, List list, List list2) throws Exception {
        Cloneable cloneable;
        RoleModulePrivilege roleModulePrivilege;
        int n2;
        int n3;
        DAOSession dAOSession = this.createDAOSession(l2);
        if (dAOSession == null) {
            return;
        }
        if (list2 != null) {
            n3 = list2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                roleModulePrivilege = (RoleModulePrivilege)list2.get(n2);
                cloneable = new HashMap<String, Long>(4);
                ((HashMap)cloneable).put("roleid", new Long(l2));
                ((HashMap)cloneable).put("moduleid", new Long(roleModulePrivilege.getModuleid()));
                ((HashMap)cloneable).put("view", new Long(roleModulePrivilege.getView()));
                ((HashMap)cloneable).put("authorized", new Long(roleModulePrivilege.getAuthorized()));
                dAOSession.deleteByFields(this.getRoleModulePrivilegeClass(), (Map)((Object)cloneable));
            }
        }
        if (list != null) {
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                roleModulePrivilege = (RoleModulePrivilege)list.get(n2);
                cloneable = (RoleModulePrivilege)this.getRoleModulePrivilegeClass().newInstance();
                ((RoleModulePrivilege)cloneable).setRoleId(l2);
                ((RoleModulePrivilege)cloneable).setModuleid(roleModulePrivilege.getModuleid());
                ((RoleModulePrivilege)cloneable).setView(roleModulePrivilege.getView());
                ((RoleModulePrivilege)cloneable).setAuthorized(roleModulePrivilege.getAuthorized());
                try {
                    dAOSession.save(cloneable);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
        dAOSession.commit();
        this.closeSession(dAOSession);
    }

    private void updatePrivilegesWithPlateName(long l2, RelationFCMapper relationFCMapper, List list, List list2, String string) throws Exception {
        int n2;
        int n3;
        DAOSession dAOSession = this.createDAOSession(l2);
        if (dAOSession == null) {
            return;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(dAOSession, relationFCMapper, this.getRoleClass(), new Long(l2));
        if (list != null) {
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                dAOHashSet.add(PlateFactory.createPrivilegeObject4Plate((Long)list.get(n2), string));
            }
        }
        if (list2 != null) {
            n3 = list2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                dAOHashSet.remove(PlateFactory.createPrivilegeObject4Plate((Long)list2.get(n2), string));
            }
        }
        dAOSession.commit();
        this.closeSession(dAOSession);
    }

    private DAOSession createDAOSession(long l2) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l2)) {
            return null;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            Object object = dAOSession.load(this.getRoleClass(), l2);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
        }
        catch (Exception exception) {
            this.rollbackSession(dAOSession);
            throw exception;
        }
        return dAOSession;
    }

    protected abstract void cache4Sort(long var1, int var3, long var4, long var6);

    @Override
    public void sortByEntryID(int n2, long[] lArray, DAOSession dAOSession) throws Exception {
        RoleEntryPrivilege roleEntryPrivilege;
        List list;
        int n3;
        if (lArray.length < 2) {
            return;
        }
        HashMap<RE, CRN> hashMap = new HashMap<RE, CRN>();
        for (n3 = 0; n3 < lArray.length - 1; ++n3) {
            list = this.findByEntryTypeAndID(n2, lArray[n3], dAOSession);
            if (list == null) continue;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                roleEntryPrivilege = (RoleEntryPrivilege)list.get(i2);
                hashMap.put(new RE(roleEntryPrivilege), new CRN(roleEntryPrivilege, lArray[n3 + 1]));
            }
        }
        list = this.findByEntryTypeAndID(n2, lArray[lArray.length - 1], dAOSession);
        if (list != null) {
            for (n3 = 0; n3 < list.size(); ++n3) {
                roleEntryPrivilege = (RoleEntryPrivilege)list.get(n3);
                hashMap.put(new RE(roleEntryPrivilege), new CRN(roleEntryPrivilege, lArray[0]));
            }
        }
        this.doSortByEntryID(hashMap, dAOSession, n2);
    }

    private void doSortByEntryID(Map map, DAOSession dAOSession, int n2) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        ArrayList<RE> arrayList = new ArrayList<RE>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (arrayList.contains(entry.getKey())) continue;
            CRN cRN = null;
            CRN cRN2 = (CRN)entry.getValue();
            while (cRN2 != null) {
                cRN = cRN2;
                arrayList.add(new RE(cRN.rp));
                RE rE2 = new RE(cRN.rp);
                rE2.entryid = cRN.newID;
                cRN2 = (CRN)map.get(rE2);
                if (cRN2 == null || !arrayList.contains(rE2)) continue;
                cRN2 = null;
            }
            cRN2 = (CRN)entry.getValue();
            long l2 = cRN2.rp.getEntryid();
            cRN.rp.setEntryid(cRN.newID);
            cRN.rp.setId(cRN2.rp.getId());
            if (!dAOSession.saveOrUpdate(cRN.rp)) continue;
            this.cache4Sort(cRN.rp.getRoleId(), n2, l2, cRN.newID);
        }
    }

    private void removeDepAndCRolePrivilege(long l2, List<String> list, DAOSession dAOSession) {
        if (list != null) {
            for (String string : list) {
                HashMap<String, Long> hashMap = new HashMap<String, Long>(4);
                long l3 = 0L;
                if (string.startsWith("1")) {
                    hashMap.put("type", 1L);
                    l3 = new Long(string.substring(1));
                } else if (string.startsWith("2")) {
                    hashMap.put("type", 2L);
                    l3 = string.substring(1).startsWith("-") ? 0L - new Long(string.substring(2)) : new Long(string.substring(1));
                } else if (string.startsWith("-")) {
                    hashMap.put("type", 0L);
                    l3 = 0L - new Long(string.substring(1));
                }
                hashMap.put("roleid", l2);
                hashMap.put("deporcroleid", l3);
                dAOSession.deleteByFields(this.getRoleDepAndCrolePrivilegeClass(), hashMap);
            }
        }
    }

    private void addDepAndCRolePrivilege(long l2, List list, DAOSession dAOSession) throws InstantiationException, IllegalAccessException {
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)this.getRoleDepAndCrolePrivilegeClass().newInstance();
                String string = list.get(i2).toString();
                roleDepAndCRolePrivilege.setRoleid(l2);
                long l3 = 0L;
                if (string.startsWith("1")) {
                    roleDepAndCRolePrivilege.setType(1);
                    l3 = Long.parseLong(string.substring(1));
                } else if (string.startsWith("2")) {
                    roleDepAndCRolePrivilege.setType(2);
                    l3 = string.substring(1).startsWith("-") ? 0L - new Long(string.substring(2)) : new Long(string.substring(1));
                } else {
                    l3 = Long.parseLong(string);
                }
                roleDepAndCRolePrivilege.setDeporcroleid(l3);
                try {
                    dAOSession.save(roleDepAndCRolePrivilege);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
    }

    protected List findByEntryTypeAndID(int n2, long l2, DAOSession dAOSession) {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("entryid", new Long(l2));
        hashMap.put("type", new Integer(n2));
        return dAOSession.listByFieldValues(this.getRoleEntryPrivilegeClass(), hashMap);
    }

    protected static class CRN {
        private RoleEntryPrivilege rp;
        private long newID;

        protected CRN(RoleEntryPrivilege roleEntryPrivilege, long l2) {
            this.rp = roleEntryPrivilege;
            this.newID = l2;
        }
    }

    protected static class RE {
        private long roleid;
        private int type;
        private long entryid;

        protected RE(RoleEntryPrivilege roleEntryPrivilege) {
            this.roleid = roleEntryPrivilege.getRoleId();
            this.type = roleEntryPrivilege.getType();
            this.entryid = roleEntryPrivilege.getEntryid();
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (int)(this.entryid ^ this.entryid >>> 32);
            n2 = 31 * n2 + (int)(this.roleid ^ this.roleid >>> 32);
            n2 = 31 * n2 + this.type;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RE rE2 = (RE)object;
            if (this.entryid != rE2.entryid) {
                return false;
            }
            if (this.roleid != rE2.roleid) {
                return false;
            }
            return this.type == rE2.type;
        }
    }
}

