/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.base.FRContext;
import com.fr.bi.fs.control.dao.BIReportDAO;
import com.fr.bi.fs.control.dao.BISharedReportDAO;
import com.fr.bi.fs.control.dao.hsqldb.HSQLBIReportDAO;
import com.fr.bi.fs.control.dao.hsqldb.HSQLBISharedReportDAO;
import com.fr.fs.FSConfig;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.Control;
import com.fr.fs.control.dao.ADHOCReportDAO;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.control.dao.TaskInfoUserDAO;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.hsqldb.HSQLADHOCReportDAO;
import com.fr.fs.control.dao.hsqldb.HSQLCompanyRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLCustomRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLDepartmentDAO;
import com.fr.fs.control.dao.hsqldb.HSQLFavoriteNodeDAO;
import com.fr.fs.control.dao.hsqldb.HSQLPostDAO;
import com.fr.fs.control.dao.hsqldb.HSQLTaskUserInfoDAO;
import com.fr.fs.control.dao.hsqldb.HSQLUserDAO;
import com.fr.json.JSONObject;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class HSQLDBDAOControl
implements Control {
    private static final long serialVersionUID = 3789717489139819038L;
    private static HSQLDBDAOControl hc;
    private PasswordValidator pv;

    public static HSQLDBDAOControl getInstance() {
        if (hc == null) {
            hc = new HSQLDBDAOControl();
        }
        return hc;
    }

    public PasswordValidator getPv() {
        if (this.pv == null) {
            this.pv = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
        }
        return this.pv;
    }

    public void setPv(PasswordValidator passwordValidator) {
        this.pv = passwordValidator;
    }

    public int getControlType() {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("encrypt")) {
            int n2 = jSONObject.getInt("encrypt");
            if (n2 == 0) {
                this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
            } else if (n2 == 1) {
                ClassPasswordValidator classPasswordValidator = new ClassPasswordValidator();
                classPasswordValidator.setClassName(jSONObject.getString("myencrypt"));
                this.setPv(classPasswordValidator);
            } else {
                this.setPv(MessageDigestPasswordValidator.MD5_PASSWORD_VALIDATOR);
            }
        } else {
            this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
        }
    }

    public JSONObject createJSON() throws Exception {
        PasswordValidator passwordValidator = this.getPv();
        return passwordValidator.toJSONObject();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("hsqlSetting", null)) != null) {
            try {
                this.parseJSON(new JSONObject(string));
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        try {
            xMLPrintWriter.attr("hsqlSetting", this.createJSON().toString());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    public CompanyRoleDAO getCompanyRoleDAO() {
        return HSQLCompanyRoleDAO.getInstance();
    }

    public CustomRoleDAO getCustomRoleDAO() {
        return HSQLCustomRoleDAO.getInstance();
    }

    public UserDAO getUserDAO() {
        return HSQLUserDAO.getInstance();
    }

    public boolean init() {
        TableDataSyncDB.release();
        FSConfig.getInstance().clearCache();
        return true;
    }

    public FavoriteNodeDAO getFavoriteNodeDAO() {
        return HSQLFavoriteNodeDAO.getInstance();
    }

    public ADHOCReportDAO getADHOCReportDAO() {
        return HSQLADHOCReportDAO.getInstance();
    }

    public DepartmentDAO getDepartmentDAO() {
        return HSQLDepartmentDAO.getInstance();
    }

    public PostDAO getPostDAO() {
        return HSQLPostDAO.getInstance();
    }

    public TaskInfoUserDAO getTaskInfoUserDAO() {
        return HSQLTaskUserInfoDAO.getInstance();
    }

    public BIReportDAO getBIReportDAO() {
        return HSQLBIReportDAO.getInstance();
    }

    public BISharedReportDAO getBISharedReportDAO() {
        return HSQLBISharedReportDAO.getInstance();
    }
}

