/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.OToMRelationFCMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLRoleDAO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HSQLCustomRoleDAO
extends HSQLRoleDAO
implements CustomRoleDAO {
    public static final String FIELD_ROLENAME = "rolename";
    private static HSQLCustomRoleDAO SC;

    public static HSQLCustomRoleDAO getInstance() {
        if (SC == null) {
            SC = new HSQLCustomRoleDAO();
        }
        return SC;
    }

    private HSQLCustomRoleDAO() {
    }

    public void save(CustomRole customRole) throws Exception {
        this.createSession().save(customRole);
    }

    public boolean delete(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        return this.deleteByID(customRole.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            boolean bl2 = dAOSession.deleteByPrimaryKey(CustomRole.class, l2);
            dAOSession.commit();
            bl = bl2;
            Object var7_6 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return bl;
    }

    public CustomRole findByID(long l2) throws Exception {
        return (CustomRole)this.createSession().load(CustomRole.class, l2);
    }

    public boolean updateRoleName(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_ROLENAME, string);
        return this.createSession().update(CustomRole.class, l2, hashMap);
    }

    public List findAll() throws Exception {
        return this.createSession().list(CustomRole.class);
    }

    public CustomRole findByRoleName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(CustomRole.class, FIELD_ROLENAME, string);
        if (!list.isEmpty()) {
            return (CustomRole)list.get(0);
        }
        return null;
    }

    public Set getUserSet(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, new Long(l2));
        return dAOHashSet.toSet(bl);
    }

    public void addUsers(long l2, Set set) throws Exception {
        this.addOrRemoveUsers(l2, set, true);
    }

    public void removeUsers(long l2, Set set) throws Exception {
        this.addOrRemoveUsers(l2, set, false);
    }

    private void addOrRemoveUsers(long l2, Set set, boolean bl) throws Exception {
        if (l2 < 0L || set == null) {
            return;
        }
        DAOSession dAOSession = null;
        try {
            try {
                dAOSession = this.createSession();
                dAOSession.beginTransaction();
                CustomRole customRole = (CustomRole)dAOSession.load(CustomRole.class, l2);
                if (customRole == null) {
                    throw new RuntimeException("The role don't exist!");
                }
                DAOHashSet dAOHashSet = new DAOHashSet(dAOSession, EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, new Long(l2));
                if (bl) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        dAOHashSet.add(iterator.next());
                    }
                } else {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        dAOHashSet.remove(iterator.next());
                    }
                }
                dAOSession.commit();
            }
            catch (Exception exception) {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeSession(dAOSession);
            throw throwable;
        }
        this.closeSession(dAOSession);
    }

    protected RelationFCMapper getEntryRelation() {
        return EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_ENTRY;
    }

    protected RelationFCMapper getESRelation() {
        return new OToMRelationFCMapper("ESPrivileges", CustomRoleESPrivilege.class, "roleid");
    }

    protected RelationFCMapper getDepAndCroleRelation() {
        return new OToMRelationFCMapper("depandcrolePrivileges", CustomRoleDepAndCRolePrivilege.class, "roleid");
    }

    protected RelationFCMapper getModuleRelation() {
        return new OToMRelationFCMapper("modulePrivileges", CustomRoleModulePrivilege.class, "roleid");
    }

    protected RelationFCMapper getTemplateRelation() {
        return new OToMRelationFCMapper("templatePrivileges", CustomRoleTemplatePrivilege.class, "roleId");
    }

    protected RelationFCMapper getDataConnectionRelation() {
        return new OToMRelationFCMapper("dataConnectionPrivileges", CustomRoleDataConnectionPrivilege.class, "roleId");
    }

    protected RelationFCMapper getRelationFCMapperWithPlateName(String string) {
        return PlateFactory.getRelationFCMapper4Custom(string);
    }

    protected Class getRoleClass() {
        return CustomRole.class;
    }

    protected Class getRoleEntryPrivilegeClass() {
        return CustomRoleEntryPrivilege.class;
    }

    protected Class getRoleESPrivilegeClass() {
        return CustomRoleESPrivilege.class;
    }

    protected Class getRoleDepAndCrolePrivilegeClass() {
        return CustomRoleDepAndCRolePrivilege.class;
    }

    protected Class getRoleModulePrivilegeClass() {
        return CustomRoleModulePrivilege.class;
    }

    protected Class getRoleTemplatePrivilegeClass() {
        return CustomRoleTemplatePrivilege.class;
    }

    protected Class getRoleDataConnectionPrivilegeClass() {
        return CustomRoleDataConnectionPrivilege.class;
    }

    protected void cache4Sort(long l2, int n2, long l3, long l4) {
        CustomRoleCache.refreshEntryPrivileges(l2, n2, l3, l4);
    }
}

