/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOSession;
import com.fr.data.dao.OToMRelationFCMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CompanyRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CompanyRoleESPrivilege;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CompanyRoleModulePrivilege;
import com.fr.fs.base.entity.CompanyRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLRoleDAO;
import java.util.HashMap;
import java.util.List;

public class HSQLCompanyRoleDAO
extends HSQLRoleDAO
implements CompanyRoleDAO {
    private static HSQLCompanyRoleDAO SC;

    public static HSQLCompanyRoleDAO getInstance() {
        if (SC == null) {
            SC = new HSQLCompanyRoleDAO();
        }
        return SC;
    }

    private HSQLCompanyRoleDAO() {
    }

    public void save(CompanyRole companyRole) throws Exception {
        this.createSession().save(companyRole);
    }

    public boolean delete(CompanyRole companyRole) throws Exception {
        if (companyRole == null) {
            return false;
        }
        return this.deleteByID(companyRole.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            boolean bl2 = dAOSession.deleteByPrimaryKey(CompanyRole.class, l2);
            dAOSession.commit();
            bl = bl2;
            Object var7_6 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return bl;
    }

    public boolean update(long l2, Department department, Post post) throws Exception {
        if (l2 < 0L || department == null || post == null) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("departmentId", new Long(department.getId()));
        hashMap.put("postId", new Long(post.getId()));
        return this.createSession().update(CompanyRole.class, l2, hashMap);
    }

    public CompanyRole findByID(long l2) throws Exception {
        return (CompanyRole)this.createSession().load(CompanyRole.class, l2);
    }

    public List findAll() throws Exception {
        return this.createSession().list(CompanyRole.class);
    }

    public List findByPost(Post post) throws Exception {
        if (post == null) {
            return null;
        }
        return this.createSession().listByFieldValue(CompanyRole.class, "postId", post);
    }

    public List findByDepartMent(Long l2) throws Exception {
        if (l2 == null) {
            return null;
        }
        return this.createSession().listByFieldValue(CompanyRole.class, "departmentId", l2);
    }

    public List findByPostAndDepartment(Long l2, Long[] longArray) throws Exception {
        if (l2 == null || longArray == null) {
            return null;
        }
        Long[] longArray2 = new Long[]{l2};
        HashMap<String, Long[]> hashMap = new HashMap<String, Long[]>();
        hashMap.put("postId", longArray2);
        hashMap.put("departmentId", longArray);
        return this.createSession().listByFieldValues4MVFilter(CompanyRole.class, hashMap);
    }

    protected RelationFCMapper getEntryRelation() {
        return new OToMRelationFCMapper("entryPrivileges", CompanyRoleEntryPrivilege.class, "roleid");
    }

    protected RelationFCMapper getESRelation() {
        return new OToMRelationFCMapper("ESPrivileges", CompanyRoleESPrivilege.class, "roleid");
    }

    protected RelationFCMapper getDepAndCroleRelation() {
        return new OToMRelationFCMapper("depandcrolePrivileges", CompanyRoleDepAndCRolePrivilege.class, "roleid");
    }

    protected RelationFCMapper getModuleRelation() {
        return new OToMRelationFCMapper("modulePrivileges", CompanyRoleModulePrivilege.class, "roleid");
    }

    protected RelationFCMapper getTemplateRelation() {
        return new OToMRelationFCMapper("templatePrivileges", CompanyRoleTemplatePrivilege.class, "roleId");
    }

    protected RelationFCMapper getDataConnectionRelation() {
        return new OToMRelationFCMapper("dataConnectionPrivileges", CompanyRoleDataConnectionPrivilege.class, "roleId");
    }

    protected RelationFCMapper getRelationFCMapperWithPlateName(String string) {
        return PlateFactory.getRelationFCMapper4Company(string);
    }

    protected Class getRoleClass() {
        return CompanyRole.class;
    }

    protected Class getRoleEntryPrivilegeClass() {
        return CompanyRoleEntryPrivilege.class;
    }

    protected Class getRoleESPrivilegeClass() {
        return CompanyRoleESPrivilege.class;
    }

    protected Class getRoleDepAndCrolePrivilegeClass() {
        return CompanyRoleDepAndCRolePrivilege.class;
    }

    protected Class getRoleModulePrivilegeClass() {
        return CompanyRoleModulePrivilege.class;
    }

    protected Class getRoleTemplatePrivilegeClass() {
        return CompanyRoleTemplatePrivilege.class;
    }

    protected Class getRoleDataConnectionPrivilegeClass() {
        return CompanyRoleDataConnectionPrivilege.class;
    }

    protected void cache4Sort(long l2, int n2, long l3, long l4) {
        CompanyRoleCache.refreshEntryPrivileges(l2, n2, l3, l4);
    }
}

