/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.bi.fs.BIReportNode;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.adhoc.ADHOCReportNode;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserControl {
    private static UserControl uc;

    public static UserControl getInstance() {
        if (uc == null) {
            uc = new UserControl();
        }
        return uc;
    }

    public long getSuperManagerID() {
        return -999L;
    }

    public User getUser(String string, String string2) throws Exception {
        if (string != null && ComparatorUtils.equals(string, PrivilegeManager.getInstance().getRootManagerName())) {
            return string2 != null && ComparatorUtils.equals(string2, PrivilegeManager.getInstance().getRootManagerPassword()) ? this.getSysManagerUser() : null;
        }
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return FSConfig.getInstance().getControl().getUserDAO().findByUserNameAndPassWord(string, string2);
    }

    public User getByUserName(String string) throws Exception {
        if (string != null && ComparatorUtils.equals(string, PrivilegeManager.getInstance().getRootManagerName())) {
            return this.getSysManagerUser();
        }
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return FSConfig.getInstance().getControl().getUserDAO().findByUserName(string);
    }

    public User getUser(long l2) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return this.getSysManagerUser();
        }
        if (l2 < 0L) {
            return null;
        }
        return UserCache.getUserById(l2);
    }

    public Long getUser(String string) throws Exception {
        if (StringUtils.isEmpty(string)) {
            return -1L;
        }
        if (ComparatorUtils.equals(string, PrivilegeManager.getInstance().getRootManagerName())) {
            return new Long(this.getSuperManagerID());
        }
        return new Long(FSConfig.getInstance().getControl().getUserDAO().findByUserName(string).getId());
    }

    public void login(long l2) throws Exception {
        UserCache.cache(l2);
    }

    public void logout(long l2) {
        UserCache.removeCache(l2);
    }

    public boolean addUser(User user) throws Exception {
        if (user == null || ComparatorUtils.equals(UserControl.getInstance().getSysManagerUser().getUsername(), user.getUsername())) {
            return false;
        }
        user.setPassword(this.encodePassword(user.getPassword(), user.getUsername()));
        FSContext.setUseingFS();
        user.setId(-1L);
        FSConfig.getInstance().getControl().getUserDAO().save(user);
        long l2 = user.getId();
        if (l2 >= 0L) {
            UserCache.cache(l2);
            UserCache.addNoRoleUser(l2);
        }
        return user.getId() >= 0L;
    }

    public boolean deleteUser(long l2) throws Exception {
        if (l2 >= 0L) {
            boolean bl = FSConfig.getInstance().getControl().getUserDAO().deleteByID(l2);
            if (bl) {
                try {
                    UserCache.removeCache(l2);
                }
                catch (Exception exception) {
                    UserCache.removeAllCache();
                }
            }
            return bl;
        }
        return false;
    }

    public boolean updateUserAuthInfo(User user) throws Exception {
        long l2 = user.getId();
        String string = user.getUsername();
        String string2 = user.getPassword();
        String string3 = user.getRealname();
        String string4 = user.getEmail();
        String string5 = user.getMobile();
        if (this.isValidateUser(l2, string, string3)) {
            return false;
        }
        UserDAO userDAO = FSConfig.getInstance().getControl().getUserDAO();
        User user2 = userDAO.findByID(l2);
        string2 = ComparatorUtils.equals(user.getUsername(), user2.getUsername()) && string2 == null ? user2.getPassword() : this.encodePassword(string2, string);
        return userDAO.update(l2, string, string2, string3, string5, string4);
    }

    public boolean updateUserPersonalInfo(User user) throws Exception {
        if (user.getId() == UserControl.getInstance().getSuperManagerID()) {
            PrivilegeManager.getInstance().setUserInfo(user.getRealname(), user.getBirthday(), user.isMale(), user.getMobile(), user.getWorkphone(), user.getEmail());
            FRContext.getCurrentEnv().writeResource(PrivilegeManager.getInstance());
            return true;
        }
        if (user.getId() < 0L) {
            return false;
        }
        return FSConfig.getInstance().getControl().getUserDAO().update(user.getId(), user.isMale(), user.getBirthday(), user.getMobile(), user.getEmail());
    }

    public boolean updatePassword(long l2, String string, String string2) throws Exception {
        if (l2 == this.getSuperManagerID() && ComparatorUtils.equals(string, PrivilegeManager.getInstance().getRootManagerPassword())) {
            PrivilegeManager.getInstance().setRootManagerPassword(string2);
            FRContext.getCurrentEnv().writeResource(PrivilegeManager.getInstance());
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        User user = this.getUser(l2);
        if (user != null) {
            String string3 = user.getUsername();
            String string4 = user.getPassword();
            if (ComparatorUtils.equals(string = this.encodePassword(string, string3), string4)) {
                string2 = this.encodePassword(string2, string3);
                return FSConfig.getInstance().getControl().getUserDAO().updatePassword(l2, string2);
            }
            throw new RuntimeException("Password is not right!");
        }
        throw new RuntimeException("User not exist!");
    }

    public String encodePassword(String string) {
        if (string == null) {
            return null;
        }
        return FSConfig.getInstance().getControl().getPv().encodePassword(string);
    }

    public String encodePassword(String string, String string2) {
        PasswordValidator passwordValidator = FSConfig.getInstance().getControl().getPv();
        if (passwordValidator.shouldIgnoreUsername()) {
            if (string == null) {
                return null;
            }
            return passwordValidator.encodePassword(string);
        }
        if (string == null) {
            string = "123456";
        }
        return passwordValidator.encodePassword(string, string2);
    }

    public FArray getAllSRoleNames(long l2) throws Exception {
        Set set = this.getSRoles(l2);
        FArray fArray = new FArray();
        if (set != null) {
            for (CustomRole customRole : set) {
                fArray.add(customRole.getRolename());
            }
        }
        return fArray;
    }

    public List findAllUser() throws Exception {
        return FSConfig.getInstance().getControl().getUserDAO().findAllSortByUserName();
    }

    public List findAllUserWithoutSort() throws Exception {
        return FSConfig.getInstance().getControl().getUserDAO().findAll();
    }

    public JSONArray getAllMailUser() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.findAllUser();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            User user = (User)list.get(i2);
            if (!StringUtils.isNotBlank(user.getEmail())) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("text", user.getRealname() + "(" + user.getUsername() + ")");
            jSONObject.put("value", user.getEmail());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public List findAllAuthUser(long l2) throws Exception {
        List list = this.findAllUser();
        if (l2 == this.getSuperManagerID()) {
            return list;
        }
        ArrayList<RoleDepAndCRolePrivilege> arrayList = new ArrayList<RoleDepAndCRolePrivilege>();
        if (list != null) {
            HashSet<User> hashSet = new HashSet<User>();
            Set set = this.getAllDepAndCRolePrivilege(l2);
            for (DAOBean dAOBean : set) {
                hashSet.addAll(this.findAllRoleUsers((RoleDepAndCRolePrivilege)dAOBean));
            }
            hashSet.addAll(this.getNoRoleUsers());
            for (DAOBean dAOBean : list) {
                if (!hashSet.contains(dAOBean)) continue;
                arrayList.add((RoleDepAndCRolePrivilege)dAOBean);
            }
        }
        return arrayList;
    }

    protected Set<User> findAllRoleUsers(RoleDepAndCRolePrivilege roleDepAndCRolePrivilege) throws Exception {
        Set<User> set = new HashSet<User>();
        if (roleDepAndCRolePrivilege.getType() == 1) {
            Department department = DepartmentControl.getInstance().getDepartment(roleDepAndCRolePrivilege.getDeporcroleid());
            if (department != null) {
                set = DepartmentControl.getInstance().getUsers(department.getId());
            }
        } else if (roleDepAndCRolePrivilege.getType() == 2) {
            Set<RelationObject> set2 = CustomRoleControl.getInstance().getUsers(roleDepAndCRolePrivilege.getDeporcroleid(), true);
            for (RelationObject relationObject : set2) {
                User user = (User)relationObject.getValue(User.class);
                set.add(user);
            }
        }
        return set;
    }

    protected Set<User> getNoRoleUsers() throws Exception {
        return UserCache.getNoRoleUsers();
    }

    public JSONArray getAllUserInfo4D() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.findAllUser();
        HashMap<Object, HashSet<User>> hashMap = new HashMap<Object, HashSet<User>>(32);
        HashSet<User> hashSet = new HashSet<User>();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                User user = (User)list.get(i2);
                if (user.getId() == this.getSuperManagerID()) continue;
                Set set = this.getJobs(user.getId());
                boolean bl = false;
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        bl = true;
                        RelationObject relationObject = (RelationObject)iterator.next();
                        HashSet<User> hashSet2 = (HashSet<User>)hashMap.get(relationObject.getValue(Department.class));
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<User>();
                            hashMap.put(relationObject.getValue(Department.class), hashSet2);
                        }
                        hashSet2.add(user);
                    }
                }
                if (bl) continue;
                hashSet.add(user);
            }
        }
        this.dealWithDepartmentUser(jSONArray, hashMap);
        this.dealWithNoDepUser(jSONArray, hashSet);
        return jSONArray;
    }

    public Set getJobs(long l2) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getUserDAO().getJobSet(l2);
    }

    public Set<Long> getAllCompanyRoleIDs(long l2) throws Exception {
        return UserCache.getAllCompanyRoleIDs(l2);
    }

    public Set getDepartPostUsers(long l2, long l3) throws Exception {
        if (l2 < 0L || l3 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getUserDAO().getUserSet(l2, l3);
    }

    public String getCacheDepart(long l2) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        Set set = this.getJobs(l2);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            RelationObject relationObject = (RelationObject)iterator.next();
            return DepartmentControl.getInstance().getDepartmentShowName((Long)relationObject.getValue(Department.class));
        }
        return null;
    }

    public FArray getUserDP(long l2) throws Exception {
        Set set = this.getJobs(l2);
        if (set != null) {
            Iterator iterator = set.iterator();
            FArray fArray = new FArray();
            while (iterator.hasNext()) {
                String string;
                JSONObject jSONObject = new JSONObject();
                RelationObject relationObject = (RelationObject)iterator.next();
                String string2 = DepartmentControl.getInstance().getDepartmentShowName((Long)relationObject.getValue(Department.class), ",");
                if (string2 == null || (string = PostControl.getInstance().getPostName((Long)relationObject.getValue(Post.class))) == null) continue;
                fArray.add(jSONObject.put("departments", string2).put("jobTitle", string));
            }
            return fArray.length() > 0 ? fArray : null;
        }
        return null;
    }

    public long addDepartmentAndPost2User(long l2, long l3, long l4) throws Exception {
        if (l2 < 0L) {
            return -1L;
        }
        RelationObject relationObject = RelationObject.getInstance(new DAOBean[]{new Department(l3), new Post(l4)});
        if (FSConfig.getInstance().getControl().getUserDAO().addJob(l2, relationObject)) {
            try {
                UserCache.cacheJob(l2, l3, l4);
                UserCache.removeNoRoleUser(l2);
            }
            catch (Exception exception) {
                UserCache.removeCache(l2);
            }
            return relationObject.getId();
        }
        return -1L;
    }

    public boolean removeDepartmentAndPost2User(long l2, long l3, long l4) throws Exception {
        if (l3 < 0L || l4 < 0L) {
            return false;
        }
        if (l2 >= 0L) {
            RelationObject relationObject = RelationObject.getInstance(new DAOBean[]{new Department(l3), new Post(l4)});
            if (!FSConfig.getInstance().getControl().getUserDAO().removeJob(l2, relationObject)) {
                return false;
            }
            try {
                UserCache.refreshCacheJob(l2);
                UserCache.checkAndAddNoRoleUser(l2);
            }
            catch (Exception exception) {
                UserCache.removeCache(l2);
            }
            return true;
        }
        return false;
    }

    public boolean removeDepartmentAndPost2User(long l2) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        long l3 = FSConfig.getInstance().getControl().getUserDAO().removeJob(l2);
        if (l3 >= 0L) {
            try {
                UserCache.refreshCacheJob(l3);
            }
            catch (Exception exception) {
                UserCache.removeCache(l3);
            }
            return true;
        }
        return false;
    }

    public boolean updateDepartmentAndPost2User(long l2, long l3, long l4) throws Exception {
        if (!this.isValidateDepUser(l2, l3, l4)) {
            return false;
        }
        RelationObject relationObject = FSConfig.getInstance().getControl().getUserDAO().updateJob(l2, l3, l4);
        if (relationObject != null) {
            long l5 = (Long)relationObject.getValue(User.class);
            long l6 = (Long)relationObject.getValue(Department.class);
            if (l5 != l3) {
                try {
                    UserCache.refreshCacheJob(l5);
                }
                catch (Exception exception) {
                    UserCache.removeCache(l5);
                }
                try {
                    UserCache.cacheJob(l3, l6, l4);
                }
                catch (Exception exception) {
                    UserCache.removeCache(l3);
                }
            } else {
                try {
                    UserCache.refreshCacheJob(l3);
                }
                catch (Exception exception) {
                    UserCache.removeCache(l3);
                }
            }
            return true;
        }
        return false;
    }

    public Set getSRoles(long l2) throws Exception {
        Set set = UserCache.getSRoles(l2);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    public boolean addSRole(long l2, long l3) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l3);
        if (FSConfig.getInstance().getControl().getUserDAO().addSRole(l2, customRole)) {
            try {
                UserCache.cacheSRole(l2, customRole);
            }
            catch (Exception exception) {
                UserCache.removeCache(l2);
            }
            return true;
        }
        return false;
    }

    public boolean removeSRole(long l2, long l3) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l3);
        if (FSConfig.getInstance().getControl().getUserDAO().removeSRole(l2, customRole)) {
            try {
                UserCache.removeCacheSRole(l2, customRole);
            }
            catch (Exception exception) {
                UserCache.removeCache(l2);
            }
            return true;
        }
        return false;
    }

    public Set getAllEntryPrivileges(long l2) throws Exception {
        return UserCache.getAllEntryPrivileges(l2);
    }

    public Set getAllTemplatePrivileges(long l2) throws Exception {
        return UserCache.getAllTemplatePrivileges(l2);
    }

    public JSONArray getAllDepAndCRoleInfo(long l2) throws Exception {
        if (l2 == CustomRoleControl.getInstance().getSuperCustomRoleID()) {
            JSONArray jSONArray = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
            JSONArray jSONArray2 = CustomRoleControl.getInstance().getAllCustomRoleInfo();
            int n2 = jSONArray2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(jSONArray2.get(i2));
            }
            return jSONArray;
        }
        JSONArray jSONArray = new JSONArray();
        Set set = this.getAllDepAndCRolePrivilege(l2);
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            int n3;
            int n4;
            Object object;
            if (roleDepAndCRolePrivilege.getDeporcroleid() == -1L && roleDepAndCRolePrivilege.getType() == 0) {
                object = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
                n4 = ((JSONArray)object).length();
                for (n3 = 0; n3 < n4; ++n3) {
                    jSONArray.put(((JSONArray)object).get(n3));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getDeporcroleid() == -2L && roleDepAndCRolePrivilege.getType() == 0) {
                object = CustomRoleControl.getInstance().getAllCustomRoleInfo();
                n4 = ((JSONArray)object).length();
                for (n3 = 0; n3 < n4; ++n3) {
                    jSONArray.put(((JSONArray)object).get(n3));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == 1) {
                object = CompanyRoleControl.getInstance().getAllCompanyRole();
                n4 = object.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    CompanyRole companyRole = (CompanyRole)object.get(n3);
                    if (companyRole.getDepartmentId() != roleDepAndCRolePrivilege.getDeporcroleid()) continue;
                    JSONObject jSONObject = companyRole.createJSONConfig();
                    String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                    String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                    if (string == null || string2 == null) continue;
                    jSONObject.put("departmentname", string);
                    jSONObject.put("postname", string2);
                    jSONArray.put(jSONObject);
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2 || (object = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getDeporcroleid())) == null) continue;
            jSONArray.put(((CustomRole)object).createJSONConfig());
        }
        return jSONArray;
    }

    public Set getAllModulePrivileges(long l2) throws Exception {
        return UserCache.getAllModulePrivileges(l2);
    }

    public Set getAllDataConnectionPrivileges(long l2) throws Exception {
        return UserCache.getAllDataConnectionPrivileges(l2);
    }

    public boolean hasModulePrivilege(long l2, long l3) {
        return UserCache.containModulePrivilege(l2, l3);
    }

    public boolean hasPlatePrivilege(long l2, long l3, String string) {
        return UserCache.containPlatePrivilege(l2, l3, string);
    }

    public boolean hasEntryPrivilege(long l2, int n2, long l3) {
        return UserCache.containEntryPrivilege(l2, n2, l3);
    }

    public List getFavoriteNodes(long l2) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().findSysFavoriteNodes();
        }
        if (l2 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getFavoriteNodeDAO().findByUserID(l2);
    }

    public List getADHOCReportNodes(long l2) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().findSysADHOCReportNodes();
        }
        if (l2 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getADHOCReportDAO().findByUserID(l2);
    }

    public List getBIReportNodes(long l2) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().findSysBIReportNodes();
        }
        if (l2 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getBIReportDAO().findByUserID(l2);
    }

    public List getBIReportNodesShared2UserId(long l2) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return Collections.EMPTY_LIST;
        }
        if (l2 < 0L) {
            return null;
        }
        long[] lArray = FSConfig.getInstance().getControl().getBISharedReportDAO().findTemplateIdsByUserId(l2);
        ArrayList<BIReportNode> arrayList = new ArrayList<BIReportNode>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            BIReportNode bIReportNode = FSConfig.getInstance().getControl().getBIReportDAO().findByID(lArray[i2]);
            if (bIReportNode == null) continue;
            arrayList.add(bIReportNode);
        }
        return arrayList;
    }

    public JSONArray getFavoriteNodesInfo(long l2) throws Exception {
        Object object;
        JSONArray jSONArray = new JSONArray();
        List list = this.getFavoriteNodes(l2);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DAOBean dAOBean = (FavoriteNode)list.get(i2);
                object = EntryControl.getInstance().getEntry(((FavoriteNode)dAOBean).getType(), ((FavoriteNode)dAOBean).getEntryid());
                if (object == null) continue;
                JSONObject jSONObject = new JSONObject();
                JSONObject jSONObject2 = object.createJSONConfig();
                jSONObject.put("id", dAOBean.getId());
                jSONObject.put("entry", jSONObject2);
                jSONArray.put(jSONObject);
            }
        }
        if ((list = this.getADHOCReportNodes(l2)) != null) {
            for (DAOBean dAOBean : list) {
                object = new JSONObject();
                object = ((ADHOCReportNode)dAOBean).createJSONConfig();
                jSONArray.put(new JSONObject().put("type", "adhoc").put("entry", object).put("icon", ((ADHOCReportNode)dAOBean).getICON()));
            }
        }
        return jSONArray;
    }

    public long addFavoriteNode(long l2, int n2, long l3) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            FavoriteNode favoriteNode = new FavoriteNode(l2, n2, l3);
            SystemManagerFavoriteAndADHOC.getInstance().saveFavoriteNode(favoriteNode);
            return favoriteNode.getId();
        }
        if (l2 < 0L || l3 < 0L) {
            return -1L;
        }
        FavoriteNode favoriteNode = new FavoriteNode(l2, n2, l3);
        favoriteNode.setId(-1L);
        FSConfig.getInstance().getControl().getFavoriteNodeDAO().save(favoriteNode);
        return favoriteNode.getId();
    }

    public boolean deleteFavoriteNode(long l2, long l3) throws Exception {
        if (l2 == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().deleteFavoriteNodeById(l3);
        }
        return FSConfig.getInstance().getControl().getFavoriteNodeDAO().deleteByID(l3);
    }

    private User getSysManagerUser() {
        User user = new User(PrivilegeManager.getInstance().getRootManagerName(), PrivilegeManager.getInstance().getRootManagerPassword(), PrivilegeManager.getInstance().getRootManagerRealname(), PrivilegeManager.getInstance().getRootManagerBirthday(), PrivilegeManager.getInstance().isRootManagerMale(), PrivilegeManager.getInstance().getRootManagerMobile(), PrivilegeManager.getInstance().getRootManagerWorkphone(), PrivilegeManager.getInstance().getRootManagerEmail());
        user.setId(this.getSuperManagerID());
        return user;
    }

    private boolean hasUserPrivilege(Set<RoleDepAndCRolePrivilege> set, User user) throws Exception {
        long l2 = user.getId();
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            Object object;
            if (roleDepAndCRolePrivilege.getType() == 1) {
                object = DepartmentControl.getInstance().getDepartment(roleDepAndCRolePrivilege.getDeporcroleid());
                if (object == null) continue;
                JSONArray jSONArray = DepartmentControl.getInstance().getUserAndPostsInfo(((DAOBean)object).getId());
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    if (jSONObject.getLong("userid") != l2) continue;
                    return true;
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2 || !(object = CustomRoleControl.getInstance().getUsersID(roleDepAndCRolePrivilege.getDeporcroleid())).contains(new Long(user.getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean isNoDeptOrRoleUser(User user) throws Exception {
        Set<Long> set = this.getAllCompanyRoleIDs(user.getId());
        FArray fArray = this.getAllSRoleNames(user.getId());
        return set.isEmpty() && fArray.length() == 0;
    }

    private boolean isValidateUser(long l2, String string, String string2) {
        return l2 < 0L || StringUtils.isBlank(string) || StringUtils.isBlank(string2);
    }

    private boolean isValidateDepUser(long l2, long l3, long l4) {
        return l2 >= 0L && l3 >= 0L && l4 >= 0L;
    }

    private void dealWithDepartmentUser(JSONArray jSONArray, Map map) throws JSONException {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentname", DepartmentControl.getInstance().getDepartmentShowName((Long)entry.getKey()));
            Set set2 = (Set)entry.getValue();
            if (set2 != null) {
                JSONArray jSONArray2 = new JSONArray();
                jSONObject.put("users", jSONArray2);
                for (User user : set2) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("id", user.getId());
                    jSONObject2.put("text", user.getUsername());
                    jSONArray2.put(jSONObject2);
                }
            }
            jSONArray.put(jSONObject);
        }
    }

    private Set getAllDepAndCRolePrivilege(long l2) throws Exception {
        return UserCache.getAllDepAndCRolePrivileges(l2);
    }

    private void dealWithNoDepUser(JSONArray jSONArray, Set set) throws JSONException {
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentname", Inter.getLocText("No-Department"));
            JSONArray jSONArray2 = new JSONArray();
            jSONObject.put("users", jSONArray2);
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("id", user.getId());
                jSONObject2.put("text", user.getUsername());
                jSONArray2.put(jSONObject2);
            }
            jSONArray.put(jSONObject);
        }
    }
}

