/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Module;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleCache;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.ModuleDAO;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModuleControl {
    private static ModuleControl mc;
    private int ID_INIT_MARK = 0;
    private M_ID m_ID = new M_ID();
    private int retryTimes = 5;

    public static ModuleControl getInstance() {
        if (mc == null) {
            mc = new ModuleControl();
        }
        return mc;
    }

    public boolean addModule(Module module) throws Exception {
        if (module == null) {
            return false;
        }
        module.setId(-1L);
        ModuleDAO.getInstance().save(module);
        if (module.getId() >= 0L) {
            try {
                ModuleCache.cache(module);
            }
            catch (Exception exception) {
                ModuleCache.reInit();
            }
            return true;
        }
        return false;
    }

    public List getAllModules() {
        return ModuleCache.getAllModules(true);
    }

    public List getAllModuleIDs() {
        List list = ModuleCache.getAllModules(false);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Module module = (Module)list.get(i2);
                arrayList.add(new Long(module.getId()));
            }
        }
        return arrayList;
    }

    public List getAllRoleModulePrivilege() {
        List list = ModuleCache.getAllModules(false);
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Module module = (Module)list.get(i2);
                RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(module.getId(), 1L, 1L);
                if (roleModulePrivilege.getModuleid() <= 1L) continue;
                try {
                    arrayList.add(roleModulePrivilege);
                    continue;
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        }
        return arrayList;
    }

    public boolean deleteModule(long l2) throws Exception {
        boolean bl = ModuleDAO.getInstance().deleteByID(l2);
        if (bl) {
            try {
                ModuleCache.removeCache(l2);
            }
            catch (Exception exception) {
                ModuleCache.reInit();
            }
        }
        return bl;
    }

    public JSONArray getModuleRootShowInfo(long l2) throws Exception {
        return ModuleCache.getModuleRootShowInfo(l2);
    }

    public JSONArray getModuleRootInfo() throws JSONException {
        return ModuleCache.getRootNodeInfo();
    }

    public JSONArray getAuthorizedModuleItems(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllModulePrivileges(l2);
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (RoleModulePrivilege roleModulePrivilege : set) {
            if (!this.hasNoAuthority(roleModulePrivilege)) continue;
            hashSet.add(roleModulePrivilege);
        }
        set.removeAll(hashSet);
        return ModuleCache.getAuthorizedModuleItemsFromPrivilegeSet(set);
    }

    public JSONObject getModuleNodeShowInfo(long l2, long l3) throws Exception {
        return ModuleCache.getNodeInfo(l2, l3);
    }

    private boolean hasNoAuthority(RoleModulePrivilege roleModulePrivilege) {
        return FSConfig.getInstance().isGradeAuthority() && (roleModulePrivilege.getAuthorized() == 0L || roleModulePrivilege.getModuleid() <= 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initModuleID() throws Exception {
        if (this.m_ID.LOG >= 0L || this.ID_INIT_MARK >= this.retryTimes) return;
        Class<ModuleControl> clazz = ModuleControl.class;
        synchronized (ModuleControl.class) {
            if (this.m_ID.LOG >= 0L || this.ID_INIT_MARK >= this.retryTimes) return;
            ++this.ID_INIT_MARK;
            List list = ModuleDAO.getInstance().findAll();
            if (list == null) return;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Module module = (Module)list.get(i2);
                if (2L == module.getId()) {
                    this.m_ID.REPORT_MANAGER = module.getId();
                    continue;
                }
                if (3L == module.getId()) {
                    this.m_ID.CUSTOM = module.getId();
                    continue;
                }
                if (5L == module.getId()) {
                    this.m_ID.SERVER_SETTINGS = module.getId();
                    continue;
                }
                if (7L == module.getId()) {
                    this.m_ID.DATA_SETTINGS = module.getId();
                    continue;
                }
                if (8L == module.getId()) {
                    this.m_ID.REGISTER_INFO = module.getId();
                    continue;
                }
                if (9L == module.getId()) {
                    this.m_ID.MONITOR = module.getId();
                    continue;
                }
                if (10L == module.getId()) {
                    this.m_ID.ACCESS_INFO = module.getId();
                    continue;
                }
                if (11L == module.getId()) {
                    this.m_ID.LOG = module.getId();
                    continue;
                }
                if (12L == module.getId()) {
                    this.m_ID.SYSEXAM = module.getId();
                    continue;
                }
                if (13L == module.getId()) {
                    this.m_ID.PROCESSMANAGER = module.getId();
                    continue;
                }
                if (14L == module.getId()) {
                    this.m_ID.TITLE = module.getId();
                    continue;
                }
                if (15L == module.getId()) {
                    this.m_ID.BIDATASETTINGS = module.getId();
                    continue;
                }
                if (16L == module.getId()) {
                    this.m_ID.SCHEDULE = module.getId();
                    continue;
                }
                if (17L == module.getId()) {
                    this.m_ID.MOBILE = module.getId();
                    continue;
                }
                if (18L != module.getId()) continue;
                this.m_ID.PRIVILEGE = module.getId();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean hasReportManagerModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.REPORT_MANAGER;
        if (l3 < 0L) {
            throw new RuntimeException("[Module REPORTMANAGER ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasCustomModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.CUSTOM;
        if (l3 < 0L) {
            throw new RuntimeException("[Module CUSTOM ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasPrivilegeModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.PRIVILEGE;
        if (l3 < 0L) {
            throw new RuntimeException("[Module CUSTOM ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasServerSettingsModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.SERVER_SETTINGS;
        if (l3 < 0L) {
            throw new RuntimeException("[Module SERVERSETTINGS ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasDataSettingsModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.DATA_SETTINGS;
        if (l3 < 0L) {
            throw new RuntimeException("[Module DATASETTINGS ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasRegisterInfoModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.REGISTER_INFO;
        if (l3 < 0L) {
            throw new RuntimeException("[Module REGISTERINFO ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasMonitorModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.MONITOR;
        if (l3 < 0L) {
            throw new RuntimeException("[Module MONITOR ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasAccessInfoModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.ACCESS_INFO;
        if (l3 < 0L) {
            throw new RuntimeException("[Module ACCESSINFO ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasLogModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.LOG;
        if (l3 < 0L) {
            throw new RuntimeException("[Module LOG ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasScheduleModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.SCHEDULE;
        if (l3 < 0L) {
            throw new RuntimeException("[Module SCHEDULE ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasSysExamModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.SYSEXAM;
        if (l3 < 0L) {
            throw new RuntimeException("[Module SYSEXAM ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasProcessManagerModulePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.PROCESSMANAGER;
        if (l3 < 0L) {
            throw new RuntimeException("[Module PROCESSMANAGER ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasFSTitlePrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.TITLE;
        if (l3 < 0L) {
            throw new RuntimeException("[Module TITLE ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasBIManagerPrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.BIDATASETTINGS;
        if (l3 < 0L) {
            throw new RuntimeException("[Module BIData ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    public boolean hasMobileManagerPrivilege(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        this.initModuleID();
        long l3 = this.m_ID.MOBILE;
        if (l3 < 0L) {
            throw new RuntimeException("[Module BIData ID] inited failed!");
        }
        return UserControl.getInstance().hasModulePrivilege(l2, l3);
    }

    private class M_ID {
        private long REPORT_MANAGER = -1L;
        private long CUSTOM = -1L;
        private long SERVER_SETTINGS = -1L;
        private long DATA_SETTINGS = -1L;
        private long REGISTER_INFO = -1L;
        private long MONITOR = -1L;
        private long ACCESS_INFO = -1L;
        private long LOG = -1L;
        private long SYSEXAM = -1L;
        private long PROCESSMANAGER = -1L;
        private long TITLE = -1L;
        private long BIDATASETTINGS = -1L;
        private long SCHEDULE = -1L;
        private long MOBILE = -1L;
        private long PRIVILEGE = -1L;

        private M_ID() {
        }
    }
}

