/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSContext;
import com.fr.fs.cache.EntryCache;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.AnalysisEntryDAO;
import com.fr.fs.dao.BIReportEntryDAO;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.dao.FastQueryEntryDAO;
import com.fr.fs.dao.FileEntryDAO;
import com.fr.fs.dao.FolderEntryDAO;
import com.fr.fs.dao.ProcessEntryDAO;
import com.fr.fs.dao.ReportProcessEntryDAO;
import com.fr.fs.dao.ReportletEntryDAO;
import com.fr.fs.dao.URLEntryDAO;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.schedule.ScheduleLinkOutputDAO;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.json.JSONArray;
import com.fr.web.platform.entry.AnalysisEntry;
import com.fr.web.platform.entry.BIReportEntry;
import com.fr.web.platform.entry.Entry;
import com.fr.web.platform.entry.FastQueryEntry;
import com.fr.web.platform.entry.FileEntry;
import com.fr.web.platform.entry.ProcessEntry;
import com.fr.web.platform.entry.ReportProcessEntry;
import com.fr.web.platform.entry.URLEntry;

public class EntryControl {
    private static EntryControl ec;
    private Object SORT_LOCK = new Object();

    public static EntryControl getInstance() {
        if (ec == null) {
            ec = new EntryControl();
        }
        return ec;
    }

    public Entry getEntry(int n2, long l2) {
        return EntryCache.getCacheEntry(n2, l2);
    }

    public EntryTreeFolderNode getRootNode() {
        return EntryCache.getRootNode();
    }

    public EntryTreeFolderNode getFolderNode(long l2) {
        return EntryCache.getFolderTreeNode(l2);
    }

    public boolean saveOrUpdateEntry(Entry entry) throws Exception {
        if (entry == null) {
            return false;
        }
        FSContext.setUseingFS();
        boolean bl = false;
        if (entry.getEntryType() == 0) {
            bl = FolderEntryDAO.getInstance().saveOrUpdate((FolderEntry)entry);
        } else if (entry.getEntryType() == 2) {
            bl = ReportletEntryDAO.getInstance().saveOrUpdate((ReportletEntry)entry);
        } else if (entry.getEntryType() == 1) {
            bl = FileEntryDAO.getInstance().saveOrUpdate((FileEntry)entry);
        } else if (entry.getEntryType() == 3) {
            bl = URLEntryDAO.getInstance().saveOrUpdate((URLEntry)entry);
        } else if (entry.getEntryType() == 4) {
            bl = AnalysisEntryDAO.getInstance().saveOrUpdate((AnalysisEntry)entry);
        } else if (entry.getEntryType() == 5) {
            bl = ProcessEntryDAO.getInstance().saveOrUpdate((ProcessEntry)entry);
        } else if (entry.getEntryType() == 6) {
            bl = FastQueryEntryDAO.getInstance().saveOrUpdate((FastQueryEntry)entry);
        } else if (entry.getEntryType() == 7) {
            bl = BIReportEntryDAO.getInstance().saveOrUpdate((BIReportEntry)entry);
        } else if (entry.getEntryType() == 8) {
            bl = ReportProcessEntryDAO.getInstance().saveOrUpdate((ReportProcessEntry)entry);
        }
        if (bl) {
            try {
                EntryCache.cache(entry);
            }
            catch (Exception exception) {
                EntryCache.reInit();
            }
            return true;
        }
        return false;
    }

    public boolean deleteEntry(Entry entry) throws Exception {
        if (entry == null) {
            return false;
        }
        return this.deleteEntry(entry.getEntryType(), entry.getId());
    }

    public boolean deleteEntry(int n2, long l2) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        if (this.getEntryDAO(n2).deleteByID(l2)) {
            try {
                if (n2 == 1) {
                    ScheduleLinkOutput scheduleLinkOutput = ScheduleLinkOutputDAO.getInstance().findByFileEntryId(l2);
                    if (scheduleLinkOutput != null) {
                        EntryCache.removeCache(n2, scheduleLinkOutput.getFileEntryId());
                        ScheduleLinkOutputDAO.getInstance().deleteByFileEntryId(scheduleLinkOutput.getFileEntryId());
                    } else {
                        EntryCache.removeCache(n2, l2);
                    }
                } else {
                    EntryCache.removeCache(n2, l2);
                }
            }
            catch (Exception exception) {
                EntryCache.reInit();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortEntry(long l2, int n2, int n3) throws Exception {
        Entry entry;
        if (l2 > 0L && n2 >= 0 && (entry = EntryControl.getInstance().getEntry(n3, l2)) != null) {
            Object object = this.SORT_LOCK;
            synchronized (object) {
                EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(entry.getParentId());
                Entry[] entryArray = entryTreeFolderNode.getNodes(n3);
                n2 = Math.min(n2, entryArray.length);
                for (int i2 = 0; i2 < entryArray.length; ++i2) {
                    int n4;
                    if (entryArray[i2].getId() != entry.getId()) continue;
                    for (n4 = i2; n4 < entryArray.length - 1; ++n4) {
                        entryArray[n4] = entryArray[n4 + 1];
                    }
                    for (n4 = entryArray.length - 1; n4 > n2; --n4) {
                        entryArray[n4] = entryArray[n4 - 1];
                    }
                    entryArray[n2] = entry;
                    for (n4 = 0; n4 < entryArray.length; ++n4) {
                        entryArray[n4].setSortindex(n4 + 1);
                        if (!FSDAOManager.createSession().saveOrUpdate(entryArray[n4])) continue;
                        EntryCache.cache(entryArray[n4]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortFolderEntry(long l2, int n2) throws Exception {
        FolderEntry folderEntry;
        if (l2 > 0L && n2 >= 0 && (folderEntry = (FolderEntry)EntryControl.getInstance().getEntry(0, l2)) != null) {
            Object object = this.SORT_LOCK;
            synchronized (object) {
                EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(folderEntry.getParentId());
                FolderEntry[] folderEntryArray = entryTreeFolderNode.getAllShowFolderNoPVCheck();
                n2 = Math.min(n2, folderEntryArray.length);
                for (int i2 = 0; i2 < folderEntryArray.length; ++i2) {
                    int n3;
                    if (folderEntryArray[i2].getId() != folderEntry.getId()) continue;
                    for (n3 = i2; n3 < folderEntryArray.length - 1; ++n3) {
                        folderEntryArray[n3] = folderEntryArray[n3 + 1];
                    }
                    for (n3 = folderEntryArray.length - 1; n3 > n2; --n3) {
                        folderEntryArray[n3] = folderEntryArray[n3 - 1];
                    }
                    folderEntryArray[n2] = folderEntry;
                    for (n3 = 0; n3 < folderEntryArray.length; ++n3) {
                        folderEntryArray[n3].setSortindex(n3 + 1);
                        if (!FolderEntryDAO.getInstance().saveOrUpdate(folderEntryArray[n3])) continue;
                        EntryCache.cache(folderEntryArray[n3]);
                    }
                }
            }
        }
    }

    public JSONArray getRootShowFolder(long l2) throws Exception {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return null;
        }
        FolderEntry[] folderEntryArray = EntryCache.getRootNode().getShowFolderEntrys(l2);
        JSONArray jSONArray = new JSONArray();
        if (folderEntryArray != null) {
            for (int i2 = 0; i2 < folderEntryArray.length; ++i2) {
                jSONArray.put(folderEntryArray[i2].createJSONConfig());
            }
        }
        return jSONArray;
    }

    private EntryDAO getEntryDAO(int n2) {
        if (n2 == 0) {
            return FolderEntryDAO.getInstance();
        }
        if (n2 == 2) {
            return ReportletEntryDAO.getInstance();
        }
        if (n2 == 1) {
            return FileEntryDAO.getInstance();
        }
        if (n2 == 3) {
            return URLEntryDAO.getInstance();
        }
        if (n2 == 4) {
            return AnalysisEntryDAO.getInstance();
        }
        if (n2 == 5) {
            return ProcessEntryDAO.getInstance();
        }
        if (n2 == 6) {
            return FastQueryEntryDAO.getInstance();
        }
        if (n2 == 7) {
            return BIReportEntryDAO.getInstance();
        }
        if (n2 == 8) {
            return ReportProcessEntryDAO.getInstance();
        }
        throw new IllegalArgumentException("Illegal Type!");
    }
}

