/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRoleControl {
    private static CustomRoleControl sc;
    private final IDLockCreator sroleDaoIDLockCreator = new IDLockCreator();

    public static CustomRoleControl getInstance() {
        if (sc == null) {
            sc = new CustomRoleControl();
        }
        return sc;
    }

    public long getSuperCustomRoleID() {
        return -999L;
    }

    public String getSupperRoleName() {
        return "SUPERROLE";
    }

    public CustomRole getCustomRole(long l2) throws Exception {
        if (l2 == this.getSuperCustomRoleID()) {
            CustomRole customRole = new CustomRole(l2);
            customRole.setRolename(this.getSupperRoleName());
            customRole.setDescription(FSConstants.CUSTOMROLE.COMPATIABLE_SUPER_SROLE_NAME);
            return customRole;
        }
        return FSConfig.getInstance().getControl().getCustomRoleDAO().findByID(l2);
    }

    private void add(CustomRole customRole, long[] lArray, Set set, String string) throws Exception {
        if (set != null) {
            List<Long> list = Arrays.asList(set.toArray(new Long[set.size()]));
            FSConfig.getInstance().getControl().getCustomRoleDAO().updatePlatePrivileges(customRole.getId(), list, null, string);
            try {
                CustomRoleCache.refreshPrivilegesWithPlateName(customRole.getId(), FSConfig.getInstance().getControl().getCustomRoleDAO().getPrivilegesWithPlateName(customRole.getId(), string), string);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
        }
    }

    public long addPlateCustomRole(CustomRole customRole, long[] lArray, Set set, String string) throws Exception {
        if (customRole.getId() > 0L || this.addCustomRole(customRole)) {
            this.add(customRole, lArray, set, string);
            return customRole.getId();
        }
        return -1L;
    }

    public long addCustomRole(CustomRole customRole, long[] lArray, Set set, Set set2, Set set3) throws Exception {
        customRole.setId(-1L);
        if (this.addCustomRole(customRole)) {
            List<Object> list;
            if (lArray != null) {
                this.addUsers(customRole.getId(), lArray);
                UserCache.refreshAfterAddSRole(lArray, customRole.getId());
            }
            if (set != null) {
                list = Arrays.asList(set.toArray(new Long[set.size()]));
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateModulePrivileges(customRole.getId(), list, null);
                try {
                    CustomRoleCache.refreshModulePrivileges(customRole.getId(), FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(customRole.getId()));
                }
                catch (Exception exception) {
                    CustomRoleCache.reInitCache();
                }
            }
            if (set2 != null) {
                list = Arrays.asList(set2.toArray(new EntryTypeAndID[set2.size()]));
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateEntryPrivileges(customRole.getId(), list, null);
                try {
                    CustomRoleCache.refreshEntryPrivileges(customRole.getId(), FSConfig.getInstance().getControl().getCustomRoleDAO().getEntryPrivileges(customRole.getId()));
                }
                catch (Exception exception) {
                    CustomRoleCache.reInitCache();
                }
            }
            if (set3 != null) {
                list = Arrays.asList(set3.toArray(new Long[set3.size()]));
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateDepAndCrolePrivilege(customRole.getId(), list, null);
                try {
                    CustomRoleCache.refreshDepAndCRolePrivileges(customRole.getId(), FSConfig.getInstance().getControl().getCustomRoleDAO().getDepAndCrolePrivileges(customRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                    CustomRoleCache.reInitCache();
                }
            }
            return customRole.getId();
        }
        return -1L;
    }

    public Set getCustomRoleSet(long l2) throws Exception {
        HashSet<CustomRole> hashSet = new HashSet<CustomRole>();
        List list = this.getAllCustomRole();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CustomRole customRole = (CustomRole)list.get(i2);
            if (!this.getUsersID(customRole.getId()).contains(new Long(l2))) continue;
            hashSet.add(customRole);
        }
        return hashSet;
    }

    public boolean addCustomRole(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        customRole.setId(-1L);
        FSConfig.getInstance().getControl().getCustomRoleDAO().save(customRole);
        if (customRole.getId() >= 0L) {
            try {
                CustomRoleCache.cacheNew(customRole);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
            return true;
        }
        return false;
    }

    public List getAllCustomRole() throws Exception {
        List list = FSConfig.getInstance().getControl().getCustomRoleDAO().findAll();
        return list;
    }

    public JSONArray getCustomRoleInfoPrivilege(long l2) throws Exception {
        if (l2 == this.getSuperCustomRoleID()) {
            return this.getAllCustomRoleInfo();
        }
        JSONArray jSONArray = new JSONArray();
        Set set = new HashSet();
        try {
            set = UserCache.getAllDepAndCRolePrivileges(l2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        List list = this.getAllCustomRole();
        if (list != null) {
            int n2 = list.size();
            block2: for (int i2 = 0; i2 < n2; ++i2) {
                CustomRole customRole = (CustomRole)list.get(i2);
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (roleDepAndCRolePrivilege.getDeporcroleid() == -2L && roleDepAndCRolePrivilege.getType() == 0) {
                        return this.getAllCustomRoleInfo();
                    }
                    if (roleDepAndCRolePrivilege.getType() != 2 || customRole.getId() != roleDepAndCRolePrivilege.getDeporcroleid()) continue;
                    jSONArray.put(customRole.createJSONConfig());
                    continue block2;
                }
            }
        }
        return jSONArray;
    }

    public JSONArray getAllCustomRoleInfo() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getAllCustomRole();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CustomRole customRole = (CustomRole)list.get(i2);
                jSONArray.put(customRole.createJSONConfig());
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCustomRole(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        List list = CustomRoleControl.getInstance().getAllEntryPrivileges(l2);
        List list2 = CustomRoleControl.getInstance().getAllModulePrivileges(l2);
        List list3 = CustomRoleControl.getInstance().getAllDepAndCRolePrivileges(l2, false);
        CustomRoleControl.getInstance().updateEntryPrivileges(l2, null, new HashSet(list));
        CustomRoleControl.getInstance().updateModulePrivileges(l2, null, new HashSet(list2));
        CustomRoleControl.getInstance().updateDepAndCRolePrivileges(l2, null, new HashSet(list3));
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getInstance().getControl().getCustomRoleDAO().deleteByID(l2);
            }
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        if (bl) {
            try {
                CustomRoleCache.removeCache(l2);
                UserCache.refreshAfterDelSRole(l2);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
            try {
                UserCache.refreshAfterDelSRole(l2);
            }
            catch (Exception exception) {
                UserCache.removeAllCache();
            }
        }
        return bl;
    }

    public String getCustomRoleName(long l2) {
        if (l2 == this.getSuperCustomRoleID()) {
            return this.getSupperRoleName();
        }
        return CustomRoleCache.getSRoleName(l2);
    }

    public boolean updateCustomRoleName(long l2, String string) throws Exception {
        if (FSConfig.getInstance().getControl().getCustomRoleDAO().updateRoleName(l2, string)) {
            try {
                CustomRoleCache.refreshCustomRoleName(l2, string);
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
        }
        return false;
    }

    public CustomRole findByCustomRoleName(String string) throws Exception {
        return FSConfig.getInstance().getControl().getCustomRoleDAO().findByRoleName(string);
    }

    public List getAllEntryPrivileges(long l2) {
        if (l2 == this.getSuperCustomRoleID()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            arrayList.add("0-1");
            return arrayList;
        }
        return CustomRoleCache.getAllEntryPrivileges(l2, true);
    }

    public List getAllEntryPrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllEntryPrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                arrayList.add(((EntryTypeAndID)list.get(i2)).toJSONObject());
                continue;
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return arrayList;
    }

    public List getAllESPrivileges(long l2) {
        if (l2 == this.getSuperCustomRoleID()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("0-1");
            return arrayList;
        }
        return CustomRoleCache.getAllESPrivileges(l2, false);
    }

    public List getAllEntryPrivileges4Obj(long l2) {
        if (l2 == this.getSuperCustomRoleID()) {
            ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            return arrayList;
        }
        return CustomRoleCache.getAllEntryPrivileges(l2, true);
    }

    public JSONArray getAllDepAndCRoleInfo(long l2) throws Exception {
        if (l2 == this.getSuperCustomRoleID()) {
            JSONArray jSONArray = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
            JSONArray jSONArray2 = this.getAllCustomRoleInfo();
            int n2 = jSONArray2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(jSONArray2.get(i2));
            }
            return jSONArray;
        }
        JSONArray jSONArray = new JSONArray();
        List list = CustomRoleCache.getAllDepAndCRolePrivileges(l2, true);
        int n3 = list.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            DAOBean dAOBean;
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)list.get(i3);
            if (roleDepAndCRolePrivilege.getType() == 1) {
                dAOBean = CompanyRoleControl.getInstance().getJRole(roleDepAndCRolePrivilege.getRoleid());
                JSONObject jSONObject = ((CompanyRole)dAOBean).createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)dAOBean).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)dAOBean).getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", string);
                jSONObject.put("postname", string2);
                jSONArray.put(jSONObject);
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2) continue;
            dAOBean = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getRoleid());
            jSONArray.put(((CustomRole)dAOBean).createJSONConfig());
        }
        return jSONArray;
    }

    public List getAllModulePrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllModulePrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((RoleModulePrivilege)list.get(i2)).toJSONObject());
        }
        return arrayList;
    }

    public List getAllDepAndCRolePrivileges(long l2, boolean bl) throws JSONException {
        return CustomRoleCache.getAllDepAndCRolePrivileges(l2, bl);
    }

    public List getAllDataConnectionPrivileges(long l2) {
        return CustomRoleCache.getAllDataConnectionPrivileges(l2);
    }

    public List getAllTemplatePrivileges(long l2) {
        return CustomRoleCache.getAllTemplatePrivileges(l2);
    }

    public List getAllTemplatePrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllTemplatePrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((RoleTemplatePrivilege)list.get(i2)).toJSONObject());
        }
        return arrayList;
    }

    public List getAllModulePrivileges(long l2) {
        if (l2 == this.getSuperCustomRoleID()) {
            return ModuleControl.getInstance().getAllRoleModulePrivilege();
        }
        return CustomRoleCache.getAllModulePrivileges(l2);
    }

    public List getAllPlatePrivileges(long l2, String string) {
        if (l2 == this.getSuperCustomRoleID()) {
            return PlateFactory.getPlateWithPlateName(string).getAllPrivilegesID();
        }
        return CustomRoleCache.getAllPrivilegesWithPlateName(l2, string);
    }

    public boolean containModulePrivilege(long l2, long l3) {
        if (l2 == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l3 < 0L) {
            return false;
        }
        return CustomRoleCache.containModulePrivilege(l2, l3);
    }

    public boolean containPlatePrivilege(long l2, long l3, String string) {
        if (l2 == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l3 < 0L) {
            return false;
        }
        return CustomRoleCache.containPlatePrivilege(l2, l3, string);
    }

    public boolean containEntryPrivilege(long l2, int n2, long l3) {
        if (l2 == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l3 < -1L) {
            return false;
        }
        return CustomRoleCache.containEntryPrivilege(l2, n2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateModulePrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDepAndCRolePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateDepAndCrolePrivilege(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshDepAndCRolePrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getDepAndCrolePrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataConnectionPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateDataConnectionPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshDataConnectionPrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getDataConnectionPrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlatePrivileges(long l2, Set set, Set set2, String string) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l2)) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updatePlatePrivileges(l2, arrayList, arrayList2, string);
            }
            Object var12_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshPrivilegesWithPlateName(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getPrivilegesWithPlateName(l2, string), string);
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateEntryPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshEntryPrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getEntryPrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplatePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateTemplatePrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshTemplatePrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getTemplatePrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateESPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCustomRoleDAO().updateESPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.sroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CustomRoleCache.refreshESPrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getESPrivileges(l2));
        }
        catch (Exception exception) {
            CustomRoleCache.reInitCache();
        }
    }

    public Set getUsersID(long l2) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        Set<RelationObject> set = this.getUsers(l2, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)relationObject.getValue(User.class);
                hashSet.add(new Long(user.getId()));
            }
        }
        return hashSet;
    }

    public Set<RelationObject> getUsers(long l2, boolean bl) throws Exception {
        return FSConfig.getInstance().getControl().getCustomRoleDAO().getUserSet(l2, bl);
    }

    public JSONArray getUsersInfo(long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Set<RelationObject> set = this.getUsers(l2, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)relationObject.getValue(User.class);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("userid", user.getId());
                jSONObject.put("text", user.getUsername());
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    public void addUsers(long l2, long[] lArray) throws Exception {
        if (l2 < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            hashSet.add(new User(lArray[i2]));
        }
        FSConfig.getInstance().getControl().getCustomRoleDAO().addUsers(l2, hashSet);
        UserCache.refreshAfterAddSRole(lArray, l2);
    }

    public void removeUsers(long l2, long[] lArray) throws Exception {
        if (l2 < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            hashSet.add(new User(lArray[i2]));
        }
        FSConfig.getInstance().getControl().getCustomRoleDAO().removeUsers(l2, hashSet);
        UserCache.refreshAfterDelSRoleUser(lArray, l2);
    }

    public void reset() {
        sc = null;
    }
}

