/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOBean;
import com.fr.fs.FSConfig;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.web.FSConstants;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyRoleControl {
    private static CompanyRoleControl jc;
    private final IDLockCreator jroleDaoIDLockCreator = new IDLockCreator();
    private long DEPARTMENT_ALL = -5L;
    private long POST_ALL = -5L;

    public static CompanyRoleControl getInstance() {
        if (jc == null) {
            jc = new CompanyRoleControl();
        }
        return jc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDepartmentAllID() {
        if (this.DEPARTMENT_ALL == -1L) {
            throw new RuntimeException("[DEPARTMENT_ALL_ID] inited failed!");
        }
        if (this.DEPARTMENT_ALL >= 0L) {
            return this.DEPARTMENT_ALL;
        }
        String string = FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME;
        synchronized (string) {
            if (this.DEPARTMENT_ALL < -1L) {
                try {
                    DepartmentDAO departmentDAO = FSConfig.getInstance().getControl().getDepartmentDAO();
                    Department department = departmentDAO.findByNameAndPid(FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, -2L);
                    long l2 = -1L;
                    if (department != null) {
                        l2 = department.getId();
                    }
                    if (l2 < 0L) {
                        FRContext.getLogger().error("Can not find no-check-department!");
                    } else {
                        this.DEPARTMENT_ALL = l2;
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
                if (this.DEPARTMENT_ALL < 0L) {
                    ++this.DEPARTMENT_ALL;
                    throw new RuntimeException("[DEPARTMENT_ALL_ID] inited failed!");
                }
            }
            return this.DEPARTMENT_ALL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPostAllID() {
        if (this.POST_ALL == -1L) {
            throw new RuntimeException("[POST_ALL] inited failed!");
        }
        if (this.POST_ALL >= 0L) {
            return this.POST_ALL;
        }
        String string = FSConstants.COMPANYROLE.POST_ALL_NAME;
        synchronized (string) {
            if (this.POST_ALL < -1L) {
                try {
                    PostDAO postDAO = FSConfig.getInstance().getControl().getPostDAO();
                    Post post = postDAO.findByPostName(FSConstants.COMPANYROLE.POST_ALL_NAME);
                    long l2 = -1L;
                    if (post != null) {
                        l2 = post.getId();
                    }
                    if (l2 < 0L) {
                        FRContext.getLogger().error("Can not find no-check-post!");
                    } else {
                        this.POST_ALL = l2;
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
                if (this.POST_ALL < 0L) {
                    ++this.POST_ALL;
                    throw new RuntimeException("[POST_ALL] inited failed!");
                }
            }
            return this.POST_ALL;
        }
    }

    public List getAllCompanyRole() throws Exception {
        return FSConfig.getInstance().getControl().getCompanyRoleDAO().findAll();
    }

    public List getAllCustomRole() throws Exception {
        return FSConfig.getInstance().getControl().getCustomRoleDAO().findAll();
    }

    public String[] getAllCompanyRole4Desinger() throws Exception {
        List list = this.getAllCompanyRole();
        list.addAll(this.getAllCustomRole());
        int n2 = list.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            DAOBean dAOBean;
            Object e2 = list.get(i2);
            if (e2 instanceof CompanyRole) {
                dAOBean = (CompanyRole)e2;
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)dAOBean).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)dAOBean).getPostId());
                stringArray[i2] = string + string2;
                continue;
            }
            dAOBean = (CustomRole)e2;
            stringArray[i2] = ((CustomRole)dAOBean).getRolename();
        }
        return stringArray;
    }

    public JSONArray getAllCompanyRoleInfoWithDepAll() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getAllCompanyRole();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CompanyRole companyRole = (CompanyRole)list.get(i2);
                JSONObject jSONObject = companyRole.createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", string);
                jSONObject.put("postname", string2);
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONArray getAllCompanyRoleInfo() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getAllCompanyRole();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CompanyRole companyRole = (CompanyRole)list.get(i2);
                if (companyRole.getDepartmentId() == CompanyRoleControl.getInstance().getDepartmentAllID() || companyRole.getPostId() == CompanyRoleControl.getInstance().getPostAllID()) continue;
                JSONObject jSONObject = companyRole.createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", string);
                jSONObject.put("postname", string2);
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    public List<CompanyRole> getJRole(long l2, long l3) throws Exception {
        if (l3 >= 0L && l3 != this.getPostAllID() && l2 >= 0L && l2 != this.getDepartmentAllID()) {
            Long[] longArray;
            ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
            Long[] longArray2 = DepartmentControl.getInstance().getDepartmentIDPath(l2);
            if (longArray2 == null) {
                longArray = new Long[1];
            } else {
                longArray = new Long[longArray2.length + 1];
                for (int i2 = 0; i2 < longArray2.length; ++i2) {
                    longArray[i2] = longArray2[i2];
                }
            }
            longArray[longArray.length - 1] = new Long(this.getDepartmentAllID());
            List<CompanyRole> list = FSConfig.getInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(new Long(l3), longArray);
            if (list != null) {
                arrayList.addAll(list);
            }
            if ((list = FSConfig.getInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(new Long(this.getPostAllID()), longArray)) != null) {
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if (l3 == CompanyRoleControl.getInstance().getPostAllID() || l2 == CompanyRoleControl.getInstance().getDepartmentAllID()) {
            Long[] longArray = new Long[]{l2};
            return FSConfig.getInstance().getControl().getCompanyRoleDAO().findByPostAndDepartment(l3, longArray);
        }
        return null;
    }

    public CompanyRole getJRole(long l2) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        return FSConfig.getInstance().getControl().getCompanyRoleDAO().findByID(l2);
    }

    public long addCompanyRole4WithPlateName(CompanyRole companyRole, Set set, String string) throws Exception {
        if (companyRole.getId() > 0L || this.addCompanyRole(companyRole)) {
            if (set != null) {
                List<Long> list = Arrays.asList(set.toArray(new Long[set.size()]));
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updatePlatePrivileges(companyRole.getId(), list, null, string);
                try {
                    CompanyRoleCache.refreshPrivilegesWithPlateName(companyRole.getId(), FSConfig.getInstance().getControl().getCompanyRoleDAO().getPrivilegesWithPlateName(companyRole.getId(), string), string);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                    CompanyRoleCache.reinitCache();
                }
            }
            return companyRole.getId();
        }
        return -1L;
    }

    public long addCompanyRole(CompanyRole companyRole, Set set, Set set2, Set set3) throws Exception {
        companyRole.setId(-1L);
        if (this.addCompanyRole(companyRole)) {
            List<Object> list;
            if (set != null) {
                list = Arrays.asList(set.toArray(new Long[set.size()]));
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateModulePrivileges(companyRole.getId(), list, null);
                try {
                    CompanyRoleCache.refreshModulePrivileges(companyRole.getId(), FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                    CompanyRoleCache.reinitCache();
                }
            }
            if (set2 != null) {
                list = Arrays.asList(set2.toArray(new EntryTypeAndID[set2.size()]));
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateEntryPrivileges(companyRole.getId(), list, null);
                try {
                    CompanyRoleCache.refreshEntryPrivileges(companyRole.getId(), FSConfig.getInstance().getControl().getCompanyRoleDAO().getEntryPrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                    CompanyRoleCache.reinitCache();
                }
            }
            if (set3 != null) {
                list = Arrays.asList(set3.toArray(new Long[set3.size()]));
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateDepAndCrolePrivilege(companyRole.getId(), list, null);
                try {
                    CompanyRoleCache.refreshDepAndCrolePrivileges(companyRole.getId(), FSConfig.getInstance().getControl().getCompanyRoleDAO().getDepAndCrolePrivileges(companyRole.getId()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                    CompanyRoleCache.reinitCache();
                }
            }
            return companyRole.getId();
        }
        return -1L;
    }

    public boolean addCompanyRole(CompanyRole companyRole) throws Exception {
        if (companyRole == null) {
            return false;
        }
        companyRole.setId(-1L);
        FSConfig.getInstance().getControl().getCompanyRoleDAO().save(companyRole);
        if (companyRole.getId() >= 0L) {
            try {
                CompanyRoleCache.cacheNew(companyRole);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                CompanyRoleCache.reinitCache();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCompanyRole(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        List list = CompanyRoleControl.getInstance().getAllEntryPrivileges(l2);
        List list2 = CompanyRoleControl.getInstance().getAllModulePrivileges(l2);
        List list3 = CompanyRoleCache.getAllDepAndCRolePrivileges(l2, false);
        CompanyRoleControl.getInstance().updateEntryPrivileges(l2, null, new HashSet(list));
        CompanyRoleControl.getInstance().updateModulePrivileges(l2, null, new HashSet(list2));
        CompanyRoleControl.getInstance().updateDepAndCRolePrivileges(l2, null, new HashSet(list3));
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getInstance().getControl().getCompanyRoleDAO().deleteByID(l2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        if (bl) {
            try {
                UserCache.refreshAfterDeleteCompanyRole(l2);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                UserCache.removeAllCache();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDepartmentAndPost(long l2, long l3, long l4) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        CompanyRole companyRole = null;
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getInstance().getControl().getCompanyRoleDAO().update(l2, new Department(l3), new Post(l4));
                if (bl) {
                    companyRole = FSConfig.getInstance().getControl().getCompanyRoleDAO().findByID(l2);
                }
            }
            Object var13_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        if (bl) {
            try {
                UserCache.refreshAfterUpdateJRole(companyRole);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                UserCache.removeAllCache();
            }
        }
        return bl;
    }

    public List getAllEntryPrivileges(long l2) {
        return CompanyRoleCache.getAllEntryPrivileges(l2, true);
    }

    public List getAllEntryPrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllEntryPrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                arrayList.add(((EntryTypeAndID)list.get(i2)).toJSONObject());
                continue;
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return arrayList;
    }

    public List getAllESPrivileges(long l2) {
        return CompanyRoleCache.getAllESPrivileges(l2, false);
    }

    public List getAllModulePrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllModulePrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((RoleModulePrivilege)list.get(i2)).toJSONObject());
        }
        return arrayList;
    }

    public List getAllTemplatePrivilegesJO(long l2) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List list = this.getAllTemplatePrivileges(l2);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((RoleTemplatePrivilege)list.get(i2)).toJSONObject());
        }
        return arrayList;
    }

    public List getAllModulePrivileges(long l2) {
        return CompanyRoleCache.getAllModulePrivileges(l2);
    }

    public List getAllDepAndCRolePrivileges(long l2) {
        return CompanyRoleCache.getAllDepAndCRolePrivileges(l2, false);
    }

    public List getAllTemplatePrivileges(long l2) {
        return CompanyRoleCache.getAllTemplatePrivileges(l2);
    }

    public List getAllDataConnectionPrivileges(long l2) {
        return CompanyRoleCache.getAllDataConnectionPrivileges(l2);
    }

    public JSONArray getAllDepAndCRoleInfo(long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = CompanyRoleCache.getAllDepAndCRolePrivileges(l2, true);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)list.get(i2);
            if (roleDepAndCRolePrivilege.getType() == 1) {
                object = CompanyRoleControl.getInstance().getJRole(roleDepAndCRolePrivilege.getRoleid());
                JSONObject jSONObject = ((CompanyRole)object).createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)object).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)object).getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", string);
                jSONObject.put("postname", string2);
                jSONArray.put(jSONObject);
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == 2) {
                object = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getRoleid());
                jSONArray.put(((CustomRole)object).createJSONConfig());
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == -1) {
                object = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
                int n3 = ((JSONArray)object).length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    jSONArray.put(((JSONArray)object).get(i3));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != -2) continue;
            object = CustomRoleControl.getInstance().getAllCustomRoleInfo();
            int n4 = ((JSONArray)object).length();
            for (int i4 = 0; i4 < n4; ++i4) {
                jSONArray.put(((JSONArray)object).get(i4));
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateModulePrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(l2));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplatePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateTemplatePrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshTemplatePrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getTemplatePrivileges(l2));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrivilegesWithPlateName(long l2, Set set, Set set2, String string) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l2)) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updatePlatePrivileges(l2, arrayList, arrayList2, string);
            }
            Object var12_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshPrivilegesWithPlateName(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getPrivilegesWithPlateName(l2, string), string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateEntryPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshEntryPrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getEntryPrivileges(l2));
        }
        catch (Exception exception) {
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDepAndCRolePrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateDepAndCrolePrivilege(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshDepAndCrolePrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getDepAndCrolePrivileges(l2));
        }
        catch (Exception exception) {
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataConnectionPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateDataConnectionPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshDataConnectionPrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getDataConnectionPrivileges(l2));
        }
        catch (Exception exception) {
            CompanyRoleCache.reinitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateESPrivileges(long l2, Set set, Set set2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        Object object = this.jroleDaoIDLockCreator.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList arrayList = new ArrayList();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList arrayList2 = new ArrayList();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getInstance().getControl().getCompanyRoleDAO().updateESPrivileges(l2, arrayList, arrayList2);
            }
            Object var11_10 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.jroleDaoIDLockCreator.releaseIDLock();
            throw throwable;
        }
        try {
            CompanyRoleCache.refreshESPrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getESPrivileges(l2));
        }
        catch (Exception exception) {
            CompanyRoleCache.reinitCache();
        }
    }

    public Set getUsersID(long l2) throws Exception {
        CompanyRole companyRole = this.getJRole(l2);
        if (companyRole == null) {
            return null;
        }
        return UserControl.getInstance().getDepartPostUsers(companyRole.getDepartmentId(), companyRole.getPostId());
    }

    public Set<CompanyRole> getCompanyRoleSet(long l2) throws Exception {
        HashSet<CompanyRole> hashSet = new HashSet<CompanyRole>();
        List list = this.getAllCompanyRole();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CompanyRole companyRole = (CompanyRole)list.get(i2);
            if (!this.getUsersID(companyRole.getId()).contains(new Long(l2))) continue;
            hashSet.add(companyRole);
        }
        return hashSet;
    }

    public void reset() {
        jc = null;
    }
}

