/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.data.dao.DAOSession;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.FSPlate;
import com.fr.fs.FSPlateConfig;
import com.fr.fs.base.entity.Module;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateFactory {
    private static Map<String, FSPlate> plateMap = new HashMap<String, FSPlate>();

    private PlateFactory() {
    }

    public static Iterator<String> plateNameIterator() {
        return plateMap.keySet().iterator();
    }

    public static Class getRelationClassWithPlateName(String string) {
        return PlateFactory.getPlateWithPlateName(string).getRelationClass();
    }

    public static TableDataDAOControl.ColumnColumn[] getTableDataColumnsWithPlateName(String string) {
        FSPlate fSPlate = PlateFactory.getPlateWithPlateName(string);
        if (fSPlate != null) {
            return PlateFactory.getPlateWithPlateName(string).getTableDataColumns();
        }
        return new TableDataDAOControl.ColumnColumn[0];
    }

    public static void putPlate2Factory(String string, FSPlate fSPlate) {
        if (fSPlate != null) {
            plateMap.put(string, fSPlate);
        }
    }

    public static FSPlate getPlateWithPlateName(String string) {
        return plateMap.get(string);
    }

    public static RelationFCMapper getRelationFCMapper4Company(String string) {
        return PlateFactory.getPlateWithPlateName(string).getRelationFCMapper4Company();
    }

    public static RelationFCMapper getRelationFCMapper4Custom(String string) {
        return PlateFactory.getPlateWithPlateName(string).getRelationFCMapper4Custom();
    }

    public static Object createPrivilegeObject4Plate(long l2, String string) {
        return PlateFactory.getPlateWithPlateName(string).createPrivilegeObject(l2);
    }

    public static void savePlate2Module(DAOSession dAOSession, long l2) {
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            FSPlate fSPlate = PlateFactory.getPlateWithPlateName(string);
            dAOSession.save(fSPlate.getModule());
        }
    }

    public static void deletePlateModule(DAOSession dAOSession, FSPlateConfig fSPlateConfig) {
        Module module = fSPlateConfig.toFSModule();
        if (module != null) {
            dAOSession.delete(module);
        }
    }

    public static boolean containsPlate(String string) {
        return plateMap.containsKey(string);
    }
}

