/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.BaseFactory;
import com.fr.base.FRContext;
import com.fr.fs.FSBridge;
import com.fr.fs.FSCompatible;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.FSPlate;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.PlateFactory;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.web.service.ExternalSourceService;
import com.fr.fs.web.service.FSEntryService;
import com.fr.fs.web.service.FSLoadService;
import com.fr.fs.web.service.FSMainService;
import com.fr.fs.web.service.FSManagerService;
import com.fr.fs.web.service.FSOpenEntryService;
import com.fr.fs.web.service.FSSetService;
import com.fr.fs.web.service.FSSystemExamineService;
import com.fr.fs.web.service.FSTouchService;
import com.fr.fs.web.service.FSUtilService;
import com.fr.fs.web.service.PlatformEntryService;
import com.fr.fs.web.service.jsonp.FSJsonpService;
import com.fr.fs.web.service.remotedesign.FSRemoteDesignService;
import com.fr.general.FRLogger;
import com.fr.remote.module.RemoteDesignUserAuthorityProvider;
import com.fr.report.module.EngineModule;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.Service;
import com.fr.web.core.A.MA;
import com.fr.write.ProcessProvider;
import java.util.Iterator;

public class FSModule
extends EngineModule {
    private boolean hasUpdated = false;

    public Service[] service4Register() {
        return (Service[])ArrayUtils.addAll(super.service4Register(), new Service[]{new FSOpenEntryService(), new FSEntryService(), new FSMainService(), new FSSetService(), new FSManagerService(), new FSUtilService(), new FSSystemExamineService(), new FSLoadService(), new FSTouchService(), new PlatformEntryService(), new ExternalSourceService(), new FSRemoteDesignService(), new FSJsonpService()});
    }

    public void registerData() {
        StableFactory.registerObDescription("FServicePrivilege", FSBridge.class);
        RemoteDesignUserAuthorityProvider.setAuthentication(UserNamePassWordFSAuthenticationProvider.getInstance());
    }

    public String[] filterParameters4BaseSession() {
        return new String[]{"fr_fs_auth_key"};
    }

    public void startFinish() {
        Object object;
        if (FSContext.isUseFS()) {
            FSContext.initData();
        }
        this.registerData();
        this.compatible();
        StableFactory.registerFSJavaScriptFiles4WebClient(this.getFSJavaScriptFiles4WebClient());
        StableFactory.registerFSCssFiles4WebClient(this.getFSCssFiles4WebClient());
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            FSPlate fSPlate = PlateFactory.getPlateWithPlateName((String)object);
            StableFactory.registerFSJavaScriptFiles4WebClient(fSPlate.getPlateJavaScriptFiles4WebClient());
            StableFactory.registerCssFiles4WebClient(fSPlate.getPlateCssFiles4WebClient());
            StableFactory.registerLocaleFile(fSPlate.getLocaleFile());
            fSPlate.initData();
        }
        object = StableFactory.createNewObject("processBridge");
        if (object != null) {
            ((ProcessProvider)object).init();
        }
    }

    private void compatible() {
        if (!this.hasUpdated && FSConfig.getInstance().getXmlVersion() < 20140501L) {
            boolean bl = this.isSupportFS();
            try {
                if (!bl) {
                    FSCompatible.getInstance().makePlatFormCompatible();
                } else {
                    FSCompatible.getInstance().makeFSCompatible();
                }
                FSCompatible.getInstance().makeCompatible();
                FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        this.hasUpdated = true;
    }

    private boolean isSupportFS() {
        return FSRegisterForBI.isSupportFS();
    }

    private String[] getFSJavaScriptFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/js/fsbase.js", "/com/fr/fs/web/js/fsdesign.js", "/com/fr/web/core/js/jscroll.js", "/com/fr/fs/web/js/widget/fs.tree.js", "/com/fr/fs/web/js/widget/fs.tab.js", "/com/fr/fs/web/js/widget/fs_light_grid.js", "/com/fr/fs/web/js/widget/fs_widget.js", "/com/fr/fs/web/js/fstools.js", "/com/fr/web/core/js/ui/jquery.ui.core.js", "/com/fr/web/core/js/ui/jquery.ui.widget.js", "/com/fr/web/core/js/ui/jquery.ui.mouse.js", "/com/fr/web/core/js/ui/jquery.ui.position.js", "/com/fr/web/core/js/ui/jquery.ui.draggable.js", "/com/fr/fs/web/js/widget/fs.tabletree.js"};
    }

    private String[] getFSCssFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/css/fs.css", "/com/fr/fs/web/css/base.css", "/com/fr/web/core/css/redmond/jquery-ui.custom.css"};
    }

    public void stop() {
        try {
            FSConfig.release();
            Iterator<String> iterator = PlateFactory.plateNameIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                FSPlate fSPlate = PlateFactory.getPlateWithPlateName(string);
                fSPlate.release();
            }
        }
        catch (Throwable throwable) {
            FRContext.getLogger().error("shutdown fs module schedule failed" + throwable.getMessage());
        }
    }

    public boolean isNeedReleaseResource() {
        return true;
    }

    public MA loginUIExecutor4Register() {
        return BaseFactory.getFormLoginUIExecutor();
    }
}

