/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.base.fservice.FServicePrivilegeProvider;
import com.fr.base.fservice.ToastChecker;
import com.fr.data.dao.RelationObject;
import com.fr.fs.base.ToastManager;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSBridge
implements FServicePrivilegeProvider {
    private static FSBridge SC = new FSBridge();

    public static FSBridge getInstance() {
        return SC;
    }

    public long getUserIdByName(String string) {
        try {
            return UserControl.getInstance().getUser(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return -1L;
        }
    }

    public String[] getAllCompanyRole4Desinger() throws Exception {
        return CompanyRoleControl.getInstance().getAllCompanyRole4Desinger();
    }

    public long getCurrentUserID(HttpServletRequest httpServletRequest) {
        return ServiceUtils.getCurrentUserID(httpServletRequest);
    }

    public long[] getCompanyRolesByUserId(long l2) {
        try {
            Set set = UserControl.getInstance().getJobs(l2);
            int n2 = set.size();
            long[] lArray = new long[n2];
            RelationObject[] relationObjectArray = set.toArray(new RelationObject[n2]);
            for (int i2 = 0; i2 < n2; ++i2) {
                RelationObject relationObject = relationObjectArray[i2];
                Long l3 = (Long)relationObject.getValue(Department.class);
                Long l4 = (Long)relationObject.getValue(Post.class);
                List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l3, l4);
                if (list == null || list.isEmpty()) continue;
                CompanyRole companyRole = list.get(0);
                lArray[i2] = companyRole.getId();
            }
            return lArray;
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    public long[] getCustomRolesByUserId(long l2) {
        try {
            Set set = UserControl.getInstance().getSRoles(l2);
            int n2 = set.size();
            long[] lArray = new long[n2];
            CustomRole[] customRoleArray = set.toArray(new CustomRole[n2]);
            for (int i2 = 0; i2 < n2; ++i2) {
                CustomRole customRole = customRoleArray[i2];
                lArray[i2] = customRole.getId();
            }
            return lArray;
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    public long[] getUsersByCompanyRoleId(long l2) {
        return this.getUsersByRoleId(l2, true);
    }

    public long[] getUsersByCustomRoleId(long l2) {
        return this.getUsersByRoleId(l2, false);
    }

    private long[] getUsersByRoleId(long l2, boolean bl) {
        try {
            JSONArray jSONArray;
            Object object;
            if (bl) {
                object = CompanyRoleControl.getInstance().getJRole(l2);
                jSONArray = DepartmentControl.getInstance().getUserInfoByDepartAndPost(((CompanyRole)object).getDepartmentId(), ((CompanyRole)object).getPostId());
            } else {
                jSONArray = CustomRoleControl.getInstance().getUsersInfo(l2);
            }
            object = new long[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                object[i2] = jSONArray.getJSONObject(i2).optLong("userid");
            }
            return object;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return new long[0];
        }
    }

    public JSONObject getUserInfoById(long l2) {
        try {
            return UserControl.getInstance().getUser(l2).createEditInfoJSONConfig();
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public JSONObject getCompanyRoleInfoById(long l2) {
        try {
            CompanyRole companyRole = CompanyRoleControl.getInstance().getJRole(l2);
            JSONObject jSONObject = companyRole.createJSONConfig();
            jSONObject.put("departmentname", DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ","));
            jSONObject.put("postname", PostControl.getInstance().getPostName(companyRole.getPostId()));
            return jSONObject;
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public JSONObject getCustomRoleInfoById(long l2) {
        try {
            return CustomRoleControl.getInstance().getCustomRole(l2).createJSONConfig();
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public void addToastChecker(ToastChecker toastChecker) {
        ToastManager.addToastChecker(toastChecker);
    }

    public void startToastCheck(long l2) {
        ToastManager.startToastCheck(l2);
    }

    public JSONArray getAllRoles() {
        try {
            JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(-999L);
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                if (jSONObject.opt("departmentid") == null) {
                    jSONObject.put("value", "2_" + jSONObject.get("id"));
                    continue;
                }
                jSONObject.put("value", "1_" + jSONObject.get("id"));
                jSONObject.put("text", jSONObject.optString("departmentname") + jSONObject.getString("postname"));
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllUsers(boolean bl) {
        try {
            List list = UserControl.getInstance().findAllUser();
            JSONArray jSONArray = new JSONArray();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                User user = (User)list.get(i2);
                if (bl && StringUtils.isBlank(user.getEmail())) continue;
                JSONObject jSONObject = user.createUnEditInfoJSONConfig();
                jSONObject.put("value", jSONObject.optString("username"));
                jSONObject.put("text", jSONObject.optString("realname") + "(" + jSONObject.optString("username") + ")");
                jSONArray.put(jSONObject);
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllDepart() {
        try {
            JSONArray jSONArray = DepartmentControl.getInstance().getAllDepartmentInfo(false);
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                jSONObject.put("value", jSONObject.get("id"));
            }
            return jSONArray;
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public JSONArray getAllMailUsers() {
        try {
            return UserControl.getInstance().getAllMailUser();
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public boolean hasProcessTask(long l2) {
        EntryTreeFolderNode entryTreeFolderNode = EntryControl.getInstance().getFolderNode(-1L);
        try {
            JSONArray jSONArray = entryTreeFolderNode.createAllEntryJSONArray(l2, true);
            return this.hasProcessTask(jSONArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasProcessTask(JSONArray jSONArray) throws Exception {
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            if (!(jSONObject.optBoolean("hasChildren") ? this.hasProcessTask(jSONObject.getJSONArray("ChildNodes")) : ComparatorUtils.equals(jSONObject.optString("type"), "8") && ComparatorUtils.equals(jSONObject.optString("processType"), 1))) continue;
            return true;
        }
        return false;
    }
}

