/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WLayout;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;

public class WCardLayout
extends WLayout {
    private int showIndex = 0;

    public WCardLayout() {
        this(0, 0);
    }

    public WCardLayout(int n2, int n3) {
        this.setHgap(n2);
        this.setVgap(n3);
    }

    public int getShowIndex() {
        return this.showIndex;
    }

    public void setShowIndex(int n2) {
        this.showIndex = n2;
    }

    public String getShowIndex2Name() {
        return this.getWidget(this.showIndex).getWidgetName();
    }

    public void setShowIndexByName(String string) {
        this.showIndex = this.getWidgetIndex(this.getWidget(string));
    }

    public String getXType() {
        return "card";
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("WLayout-Card-ToolTips");
    }

    public Dimension getMinDesignSize() {
        Widget widget;
        if (this.getWidgetCount() > this.showIndex && (widget = this.getWidget(this.showIndex)) instanceof WLayout && widget.isVisible()) {
            return ((WLayout)widget).getMinDesignSize();
        }
        return new Dimension();
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("defaultShowIndex", this.showIndex);
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("CardAttr")) {
            this.showIndex = xMLableReader.getAttrAsInt("defaultShowIndex", 0);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("CardAttr").attr("defaultShowIndex", this.showIndex).end();
    }
}

