/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.DirectWriteEditor;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class WriteAbleRepeatEditor
extends DirectWriteEditor {
    private boolean removeRepeat = true;
    private int delayTime = 200;

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int n2) {
        this.delayTime = n2;
    }

    public boolean isRemoveRepeat() {
        return this.removeRepeat;
    }

    public void setRemoveRepeat(boolean bl) {
        this.removeRepeat = bl;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        if (this.isRemoveRepeat()) {
            jSONObject.put("norepeat", true);
        }
        jSONObject.put("searchTime", this.delayTime);
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("noRepeat".equals(string)) {
                this.setRemoveRepeat(Boolean.valueOf(xMLableReader.getElementValue()));
            }
            if ("DelayTime".equals(string)) {
                this.setDelayTime(Integer.valueOf(xMLableReader.getElementValue()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.removeRepeat) {
            xMLPrintWriter.startTAG("noRepeat").textNode(String.valueOf(this.removeRepeat)).end();
        }
        if (this.delayTime != 200) {
            xMLPrintWriter.startTAG("DelayTime").textNode(String.valueOf(this.getDelayTime())).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof WriteAbleRepeatEditor && super.equals(object) && this.removeRepeat == ((WriteAbleRepeatEditor)object).removeRepeat && this.delayTime == ((WriteAbleRepeatEditor)object).delayTime;
    }
}

