/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.form.ui.CustomToolBarButton;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.finegrain.AbstractPrivilegeControl;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ToolBar
extends Widget {
    protected List widgets = new ArrayList();
    private boolean isDefault = true;
    private Background background = null;

    public ToolBar() {
    }

    public ToolBar(Widget[] widgetArray) {
        if (widgetArray != null) {
            this.widgets.addAll(Arrays.asList(widgetArray));
        }
    }

    public String getXType() {
        return "toolbar";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[0];
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getWidgetSize() {
        return this.widgets == null ? 0 : this.widgets.size();
    }

    public Widget getWidget(int n2) {
        return (Widget)this.widgets.get(n2);
    }

    public void addWidget(Widget widget) {
        if (this.widgets == null) {
            this.widgets = new ArrayList();
        }
        this.widgets.add(widget);
    }

    public void addWidgetAhead(Widget widget) {
        if (this.widgets == null) {
            this.widgets = new ArrayList();
        }
        if (this.widgets.contains(widget)) {
            return;
        }
        this.widgets.add(0, widget);
    }

    public Widget removeWidget(int n2) {
        if (this.widgets == null || this.widgets.size() <= n2) {
            return null;
        }
        return (Widget)this.widgets.remove(n2);
    }

    public void clearWidgets() {
        if (this.widgets != null) {
            this.widgets.clear();
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("disabled", this.isEnabled() ? "true" : "false");
        jSONObject.put("items", this.createJSONComponents(repository, calculator));
        if (!this.isDefault) {
            if (this.background != null) {
                jSONObject.put("toolbarbg", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            } else {
                jSONObject.put("toolbarbg", "none");
            }
        }
        return jSONObject;
    }

    private JSONArray createJSONComponents(Repository repository, Calculator calculator) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n2 = this.widgets.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XMLReadable xMLReadable;
            Widget widget = null;
            try {
                widget = (Widget)((Widget)this.widgets.get(i2)).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage());
            }
            if (!this.supportToolbar(repository, widget)) continue;
            Calculator.createCalculator();
            String[] stringArray = PrivilegeManager.getRoleFromCalculator(calculator);
            if (stringArray.length > 0) {
                xMLReadable = widget.getWidgetPrivilegeControl();
                if (widget.isVisible()) {
                    widget.setVisible(!((AbstractPrivilegeControl)xMLReadable).checkInvisible(stringArray));
                }
                if (!widget.isVisible()) continue;
            }
            if (widget instanceof CustomToolBarButton && (xMLReadable = ((CustomToolBarButton)widget).getJSImpl()) != null) {
                xMLReadable.setShouldRecalculate(true);
            }
            jSONArray.put(widget.createJSONConfig(repository, calculator));
        }
        return jSONArray;
    }

    private boolean supportToolbar(Repository repository, Widget widget) {
        return !repository.getBrowser().isMobile() || repository.getBrowser().isMobile() && widget.supportMobile();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ToolBar");
        int n2 = this.getWidgetSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            WidgetXmlUtils.writeXMLWidget(xMLPrintWriter, this.getWidget(i2));
        }
        if (!this.isDefault()) {
            xMLPrintWriter.startTAG("IsDefault").textNode(String.valueOf(this.isDefault)).end();
            if (this.background != null) {
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearWidgets();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Widget")) {
                this.addWidget(WidgetXmlUtils.readWidget(xMLableReader));
            } else if ("Background".equals(string)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if ("IsDefault".equals(string)) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setDefault(Boolean.valueOf(string2));
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ToolBar)) {
            return false;
        }
        ToolBar toolBar = (ToolBar)object;
        return super.equals(object) && ComparatorUtils.equals(this.widgets, toolBar.widgets) && this.isDefault == toolBar.isDefault && ComparatorUtils.equals(this.background, toolBar.background);
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBar toolBar = (ToolBar)super.clone();
        if (this.widgets != null) {
            toolBar.widgets = new ArrayList(this.widgets.size());
            int n2 = this.widgets.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                toolBar.widgets.add(((Widget)this.widgets.get(i2)).clone());
            }
        }
        if (this.background != null) {
            toolBar.background = (Background)this.background.clone();
        }
        return toolBar;
    }
}

