/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.form.ui.FieldEditor;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class TableTree
extends FieldEditor {
    public static final String XML_TAG = "TT";
    private String dataUrl;
    private Dictionary dict;

    public String getXType() {
        return "tabletree";
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String string) {
        this.dataUrl = string;
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dict = dictionary;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.dict == null) {
            return jSONArray;
        }
        this.dict.reset();
        Iterator iterator = this.dict.entrys(calculator);
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            jSONArray.put(new JSONObject().put("state", Utils.objectToString(mV.getModel())).put("name", Utils.objectToString(mV.getView())));
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        HashMap hashMap = new HashMap();
        try {
            jSONObject.put("url", this.dataUrl == null ? "" : TemplateUtils.renderParameter4Tpl(this.dataUrl, hashMap));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.dataUrl = xMLableReader.getAttrAsString("url", null);
            } else if (string.equals("Dictionary")) {
                this.dict = DataCoreXmlUtils.readXMLDictionary(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.dataUrl)) {
            xMLPrintWriter.startTAG(XML_TAG).attr("url", this.dataUrl).end();
        }
        if (this.dict != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.dict, "Dictionary");
        }
    }

    public boolean equals(Object object) {
        return object instanceof TableTree && super.equals(object) && ComparatorUtils.equals(this.dataUrl, ((TableTree)object).dataUrl);
    }
}

