/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.FieldEditor;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Map;

public class MultiFileEditor
extends FieldEditor {
    public static final String EVENT_UPLOAD_CALLBACK = "callback";
    private int maxLength = -1;
    private double maxSize = -1.0;
    private String accept;

    public boolean isEditor() {
        return true;
    }

    public void setMaxLength(int n2) {
        this.maxLength = n2;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setSingleFile(boolean bl) {
        this.maxLength = bl ? 1 : -1;
    }

    public boolean isSingleFile() {
        return this.maxLength == 1;
    }

    public void setAccept(String string) {
        this.accept = string;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setMaxSize(double d2) {
        this.maxSize = d2;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public String getXType() {
        return "multifile";
    }

    public boolean supportMobile() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", EVENT_UPLOAD_CALLBACK};
    }

    protected Map getConvertMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("beforeedit", EVENT_UPLOAD_CALLBACK);
        hashMap.put("afteredit", EVENT_UPLOAD_CALLBACK);
        hashMap.put("stopedit", EVENT_UPLOAD_CALLBACK);
        return hashMap;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        if (!StringUtils.isEmpty(this.getAccept())) {
            jSONObject.put("accept", this.getAccept());
        }
        if (this.maxLength != -1) {
            jSONObject.put("maxlength", this.maxLength);
        }
        if (this.maxSize != -1.0) {
            jSONObject.put("maxSize", this.maxSize);
        }
        jSONObject.put("needSubmit", true);
        return jSONObject;
    }

    public Object value2Config(Object object, CalculatorProvider calculatorProvider) {
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("FileAttr")) {
            String string = null;
            this.setMaxLength(xMLableReader.getAttrAsInt("maxlength", -1));
            string = xMLableReader.getAttrAsString("accept", null);
            if (string != null) {
                this.setAccept(string);
            }
            this.setMaxSize(xMLableReader.getAttrAsInt("maxSize", -1));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("FileAttr");
        if (this.maxLength != -1) {
            xMLPrintWriter.attr("maxlength", this.maxLength);
        }
        if (!StringUtils.isEmpty(this.getAccept())) {
            xMLPrintWriter.attr("accept", this.getAccept());
        }
        if (this.maxSize != -1.0) {
            xMLPrintWriter.attr("maxSize", this.maxSize);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MultiFileEditor)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(((MultiFileEditor)object).accept, this.accept) && this.maxLength == ((MultiFileEditor)object).maxLength;
    }
}

