/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.Button;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class CustomButton
extends Button {
    private String prefix = "x-btn";

    public String getXType() {
        return "custombutton";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String[] supportedEvents() {
        return new String[]{"afteredit", "click"};
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        if (StringUtils.isNotBlank(this.prefix)) {
            jSONObject.put("prefix", this.getPrefix());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("Prefix") && (string = xMLableReader.getElementValue()) != null) {
            this.setPrefix(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.prefix) && !"x-btn".equals(this.prefix)) {
            xMLPrintWriter.startTAG("Prefix").textNode(this.prefix).end();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CustomButton)) {
            return false;
        }
        CustomButton customButton = (CustomButton)object;
        return super.equals(object) && ComparatorUtils.equals(this.getPrefix(), customButton.getPrefix());
    }

    public Object clone() throws CloneNotSupportedException {
        CustomButton customButton = (CustomButton)super.clone();
        return customButton;
    }
}

