/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.form.data.DataBinding;
import com.fr.form.data.FilterComboBoxData;
import com.fr.form.ui.ComboCheckBox;
import com.fr.form.ui.CustomWriteAbleRepeatEditor;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DictionaryContainer;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox
extends CustomWriteAbleRepeatEditor
implements DictionaryContainer,
DataControl {
    protected Dictionary mvList;
    private Map dependenceMap = null;
    private WidgetValue widgetValue;
    private int defaultLimit = 500;
    protected boolean previewLimitData = false;
    private boolean alwaysReload = false;
    private JSONObject joData;

    @Override
    public Map getDependenceMap() {
        return this.dependenceMap;
    }

    @Override
    public void setDependenceMap(Map map) {
        this.dependenceMap = map;
    }

    @Override
    public String getXType() {
        return "combo";
    }

    @Override
    public int[] getValueType() {
        return new int[]{1, 2, 3};
    }

    @Override
    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    @Override
    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        this.mvList = dictionary;
    }

    @Override
    public Dictionary getDictionary() {
        return this.mvList;
    }

    @Override
    public Object getViewValue(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        Iterator iterator = this.getEntrysIterator(calculator, sessionIDInfor, httpServletRequest);
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            if (!ComparatorUtils.equals(mV.getModel(), object) && !ComparatorUtils.equals(mV.getView(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    @Override
    public Object getModuleValue(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        Iterator iterator = this.getEntrysIterator(calculator, sessionIDInfor, httpServletRequest);
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            if (!ComparatorUtils.equals(mV.getModel(), object) && !ComparatorUtils.equals(mV.getView(), object)) continue;
            return mV.getModel();
        }
        return null;
    }

    private Iterator getEntrysIterator(Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        List<NameSpace> list = null;
        try {
            list = this.addParameterAndDependenceNameSpaces(calculator, sessionIDInfor, httpServletRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator iterator = this.getDictionary().entrys(calculator);
        this.removeParameterAndDependenceNameSpaces(calculator, list);
        return iterator;
    }

    @Override
    public String[] dependence(Calculator calculator) {
        return this.mvList == null ? new String[]{} : this.mvList.getDependence(calculator);
    }

    private JSONObject createJSONDataByDefalutValue(Object object, Calculator calculator) throws Exception {
        this.joData = new JSONObject();
        this.joData.put("value", object == null ? "" : object);
        if (object == null || object.toString().length() == 0 || this.mvList == null) {
            return this.joData;
        }
        JSONArray jSONArray = new JSONArray();
        int n2 = this.defaultLimit;
        boolean bl = false;
        this.mvList.reset();
        Iterator iterator = this.mvList.entrys(calculator);
        HashSet<Dictionary.MV> hashSet = new HashSet<Dictionary.MV>();
        int n3 = 1;
        int n4 = 0;
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            if (n4 >= n2 && bl) {
                if (n3 == 0) break;
                --n3;
            }
            Object object2 = mV.getModel();
            Object object3 = mV.getView();
            if (ComparatorUtils.equals(object, object2) || ComparatorUtils.equals(object, object3)) {
                bl = true;
            }
            if (!StringUtils.isNotEmpty(FieldEditor.toJSONString(object3))) continue;
            if (this.isRemoveRepeat()) {
                if (hashSet.contains(mV)) continue;
                hashSet.add(mV);
                jSONArray.put(new JSONObject().put("value", mV.getModel()).put("text", object3));
                ++n4;
                continue;
            }
            jSONArray.put(new JSONObject().put("value", mV.getModel()).put("text", object3));
            ++n4;
        }
        this.joData.put("data", jSONArray);
        return this.joData;
    }

    @Override
    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "startIndex");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "limitIndex");
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "filter");
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Integer.valueOf(string);
            n3 = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.mvList == null) {
            return jSONArray;
        }
        List<NameSpace> list = this.addParameterAndDependenceNameSpaces(calculator, sessionIDInfor, httpServletRequest);
        this.filterAndPutData(calculator, jSONArray, n3, n2, string3);
        this.removeParameterAndDependenceNameSpaces(calculator, list);
        return jSONArray;
    }

    private void removeParameterAndDependenceNameSpaces(Calculator calculator, List<NameSpace> list) {
        for (NameSpace nameSpace : list) {
            calculator.removeNameSpace(nameSpace);
        }
    }

    private List<NameSpace> addParameterAndDependenceNameSpaces(Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) throws Exception {
        ArrayList<NameSpace> arrayList = new ArrayList<NameSpace>();
        ParameterMapNameSpace parameterMapNameSpace = null;
        FieldEditor.DependenceNameSpace dependenceNameSpace = null;
        arrayList.add(parameterMapNameSpace);
        arrayList.add(dependenceNameSpace);
        if (this.alwaysReload || "true".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(httpServletRequest, "reload"))) {
            this.mvList.reset();
            parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
            dependenceNameSpace = new FieldEditor.DependenceNameSpace(CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
            calculator.pushNameSpace(parameterMapNameSpace);
            calculator.pushNameSpace(dependenceNameSpace);
        }
        return arrayList;
    }

    protected void filterAndPutData(Calculator calculator, JSONArray jSONArray, int n2, int n3, String string) throws Exception {
        FilterComboBoxData.filterAndPutData(calculator, jSONArray, n3, n2, string, this.isRemoveRepeat(), this.mvList, null);
    }

    @Override
    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        Object object = null;
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        object = this.widgetValue.createAttrResult(new WidgetValue.WidgetValueInfo(this.getWidgetName(), this instanceof ComboCheckBox, this.isRemoveRepeat()), calculator, jSONObject2);
        try {
            jSONObject.put(this.widgetName.toUpperCase(), this.createJSONDataByDefalutValue(object, calculator));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("autoMode", true);
        jSONObject.put("mode", "remote");
        Object[] objectArray = this.dependence(calculator);
        if (!ArrayUtils.isEmpty(objectArray)) {
            jSONObject.put("dependence", objectArray);
        }
        if (this.joData != null) {
            jSONObject.put("controlAttr", this.joData);
            this.joData = null;
        }
        return jSONObject;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Dictionary") || string.equals("MVList")) {
                this.mvList = DataCoreXmlUtils.readXMLDictionary(xMLableReader);
            } else if ("Dict".equals(string)) {
                this.mvList = DataCoreXmlUtils.readXMLDictionary(xMLableReader);
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            } else if ("text".equals(string)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            }
        }
    }

    @Override
    protected void readDirectEditXML(XMLableReader xMLableReader) {
        if (!xMLableReader.getXMLVersion().isAfterPRIVILGE_FOR7_0_5_XML_VERSION()) {
            this.setCustomData(Boolean.valueOf(xMLableReader.getElementValue()));
        } else {
            super.readDirectEditXML(xMLableReader);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.mvList != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.mvList, "Dictionary");
        }
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        this.widgetValue.writeXML(xMLPrintWriter);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ComboBox && super.equals(object) && ComparatorUtils.equals(this.mvList, ((ComboBox)object).mvList) && this.dependenceMap == ((ComboBox)object).dependenceMap && ComparatorUtils.equals(this.widgetValue, ((ComboBox)object).widgetValue);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ComboBox comboBox = (ComboBox)super.clone();
        if (this.mvList != null) {
            comboBox.mvList = (Dictionary)this.mvList.clone();
        }
        return comboBox;
    }
}

