/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form;

import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;

public class LayoutBorderStyle
implements Cloneable,
Serializable,
XMLable {
    private static final long serialVersionUID = 2677466857456162929L;
    private Color color = Color.BLACK;
    private int border = 0;
    private boolean corner = true;

    public LayoutBorderStyle() {
    }

    public void reset() {
        this.setColor(Color.black);
        this.setBorder(0);
        this.setCorner(true);
    }

    public LayoutBorderStyle(int n2, Color color, boolean bl) {
        this.setStyle(n2, color, bl);
    }

    public void setStyle(int n2, Color color, boolean bl) {
        this.setColor(color);
        this.setBorder(n2);
        this.setCorner(bl);
    }

    public void setStyle(LayoutBorderStyle layoutBorderStyle) {
        if (layoutBorderStyle == null) {
            this.reset();
        } else {
            this.border = layoutBorderStyle.border;
            this.color = layoutBorderStyle.color;
            this.corner = layoutBorderStyle.corner;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean getCorner() {
        return this.corner;
    }

    public void setCorner(boolean bl) {
        this.corner = bl;
    }

    public int getStyle() {
        return this.border;
    }

    public void setBorder(int n2) {
        this.border = n2;
    }

    private static String border2Style(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 5: {
                return "solid";
            }
            case 6: {
                return "doble";
            }
            case 7: 
            case 9: 
            case 11: {
                return "dotted";
            }
        }
        return "dashed";
    }

    public void createJSONConfig(JSONObject jSONObject) throws JSONException {
        if (this.border != 0) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", BaseUtils.getBorderWidth(this.border)).put("type", LayoutBorderStyle.border2Style(this.border)).put("color", StableUtils.javaColorToCSSColor(this.color)).put("corner", this.corner);
            jSONObject.put("border", jSONObject2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LayoutBorderStyle)) {
            return false;
        }
        LayoutBorderStyle layoutBorderStyle = (LayoutBorderStyle)object;
        return this.getStyle() == layoutBorderStyle.getStyle() && ComparatorUtils.equals(this.getColor(), layoutBorderStyle.getColor()) && this.getCorner() == layoutBorderStyle.getCorner();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Border")) {
            this.setStyle(xMLableReader.getAttrAsInt("style", 0), xMLableReader.getAttrAsColor("color", Color.black), xMLableReader.getAttrAsBoolean("corner", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Border").attr("style", this.border);
        if (this.color != Color.black) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        if (this.corner) {
            xMLPrintWriter.attr("corner", this.corner);
        }
        xMLPrintWriter.end();
    }

    public void paint(Graphics graphics, Rectangle2D.Double double_) {
        if (this.getStyle() != 0) {
            graphics.setColor(this.color);
            int n2 = GraphHelper.getLineStyleSize(this.border);
            GraphHelper.draw(graphics, new RoundRectangle2D.Double(double_.getX() + (double)(n2 == 1 ? 1 : 2) - (double)n2 - 1.0, double_.getY() + (double)(n2 == 1 ? 1 : 2) - (double)n2 - 1.0, double_.getWidth() + (double)n2, double_.getHeight() + (double)n2, this.corner ? 15.0 : 0.0, this.corner ? 15.0 : 0.0), this.border);
        }
    }

    public Shape getFilledShape(Insets insets, Dimension dimension) {
        return new RoundRectangle2D.Double(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom, this.corner ? 15.0 : 0.0, this.corner ? 15.0 : 0.0);
    }
}

