/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.file.XMLFileManager;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.AttachmentDownloader;
import com.fr.stable.fun.EmailProvider;
import com.fr.stable.fun.ExcelExportCellValueProvider;
import com.fr.stable.fun.JavaScriptChanger;
import com.fr.stable.fun.NoPrivilegeDirector;
import com.fr.stable.fun.PrintCellValueProvider;
import com.fr.stable.fun.ReportPretreatment;
import com.fr.stable.fun.RequestParameterCollector;
import com.fr.stable.fun.RequestParameterHandler;
import com.fr.stable.fun.Service;
import com.fr.stable.fun.WebFileImporter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtraClassManager
extends XMLFileManager {
    private static final String XML_TAG = "ExtraClassManager";
    private static ExtraClassManager classManager;
    private Map<String, JavaScriptChanger> jsChangerMap = new HashMap<String, JavaScriptChanger>();
    private AttachmentDownloader attachmentDownLoader = null;
    private EmailProvider emailProvider = null;
    private ExcelExportCellValueProvider exportCellValueProvider = null;
    private PrintCellValueProvider printCellValueProvider = null;
    private WebFileImporter webFileImporter = null;
    private RequestParameterHandler requestParameterHandler = null;
    private RequestParameterCollector requestParameterCollector = null;
    private NoPrivilegeDirector noPrivilegeDirector = null;
    private List<Service> services = new ArrayList<Service>();
    private ReportPretreatment pretreatment = null;

    public static synchronized ExtraClassManager getInstance() {
        if (classManager == null) {
            classManager = new ExtraClassManager();
            classManager.readXMLFile();
        }
        return classManager;
    }

    private static synchronized void envChanged() {
        classManager = null;
    }

    public AttachmentDownloader getAttachmentDownLoader() {
        return this.attachmentDownLoader;
    }

    public void setAttachmentDownLoader(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.attachmentDownLoader = (AttachmentDownloader)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public EmailProvider getEmailProvider() {
        return this.emailProvider;
    }

    public void setEmailProvider(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.emailProvider = (EmailProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public ExcelExportCellValueProvider getExportCellValueProvider() {
        return this.exportCellValueProvider;
    }

    public void setExportCellValueProvider(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.exportCellValueProvider = (ExcelExportCellValueProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public PrintCellValueProvider getPrintCellValueProvider() {
        return this.printCellValueProvider;
    }

    public void setPrintCellValueProvider(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.printCellValueProvider = (PrintCellValueProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public JavaScriptChanger getJSChanger(String string) {
        return this.jsChangerMap.get(string);
    }

    public void addJSChanger(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                JavaScriptChanger javaScriptChanger = (JavaScriptChanger)clazz.newInstance();
                this.jsChangerMap.put(javaScriptChanger.getFileName(), javaScriptChanger);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public NoPrivilegeDirector getNoPrivilegeDirector() {
        return this.noPrivilegeDirector;
    }

    public void setNoPrivilegeDirector(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.noPrivilegeDirector = (NoPrivilegeDirector)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public WebFileImporter getWebFileImporter() {
        return this.webFileImporter;
    }

    public void setWebFileImporter(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.webFileImporter = (WebFileImporter)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public RequestParameterHandler getRequestParameterHandler() {
        return this.requestParameterHandler;
    }

    public void setRequestParameterHandler(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.requestParameterHandler = (RequestParameterHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public RequestParameterCollector getRequestParameterCollector() {
        return this.requestParameterCollector;
    }

    public void setRequestParameterCollector(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.requestParameterCollector = (RequestParameterCollector)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public Service[] getServices() {
        return this.services.toArray(new Service[this.services.size()]);
    }

    private void addService(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.services.add((Service)clazz.newInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public ReportPretreatment getPretreatment() {
        return this.pretreatment;
    }

    public void setPretreatment(String string) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class<?> clazz = Class.forName(string);
                this.pretreatment = (ReportPretreatment)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public String fileName() {
        return "extra.xml";
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("AttachmentDownloader")) {
                this.setAttachmentDownLoader(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("EmailProvider")) {
                this.setEmailProvider(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("ExcelExportCellValueProvider")) {
                this.setExportCellValueProvider(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("JavaScriptChanger")) {
                this.setPrintCellValueProvider(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("JavaScriptChanger")) {
                this.addJSChanger(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("WebFileImporter")) {
                this.setWebFileImporter(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("RequestParameterHandler")) {
                this.setRequestParameterHandler(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("RequestParameterCollector")) {
                this.setRequestParameterCollector(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("NoPrivilegeDirector")) {
                this.setNoPrivilegeDirector(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("WebService")) {
                this.addService(xMLableReader.getAttrAsString("class", ""));
            } else if (xMLableReader.getTagName().equals("ReportPretreatment")) {
                this.setPretreatment(xMLableReader.getAttrAsString("class", ""));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.end();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ExtraClassManager.envChanged();
            }
        });
    }
}

