/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class CustomConfigManager
extends XMLFileManager {
    private static final long DEFAULT_DIGITAL_PRIVILEGE = 90000L;
    private static final long DEFAULT_USERNAME_PRIVILEGE = 1200000L;
    private static final String PRIVILEGE_TIMEOUT_XML = "privilegeTimeout";
    private static final String DIGITAL_PRIVILEGE_XML = "digitalPrivilegeTimeout";
    private static final String USERNAME_PRIVILEGE_XML = "usernamePrivilegeTimeout";
    private static final String EXPORT_FULL_IMAGE = "exportFullImage";
    private static final String EXCEL_ADJUST = "excelAdjust";
    public static final String REPORT_PREFIX = "reportPrefix";
    private long digitalPrivilegeTimeout = 90000L;
    private long usernamePrivilegeTimeout = 1200000L;
    private boolean exportFullImg4Excel = false;
    private float excelAdjustHeight = 20.1f;
    private double excelAdjustWidth = 34.742;
    private boolean importDoubleDir = false;
    private boolean checkWidget = false;
    private boolean printWidget = false;
    private String reportPrefix = "";
    private boolean readDialectAgain = false;
    private static CustomConfigManager configManager = null;

    public static synchronized CustomConfigManager getInstance() {
        if (configManager == null) {
            configManager = new CustomConfigManager();
            configManager.readXMLFile();
        }
        return configManager;
    }

    private static synchronized void envChanged() {
        configManager = null;
    }

    private CustomConfigManager() {
    }

    public long getUsernamePrivilegeTimeout() {
        return this.usernamePrivilegeTimeout;
    }

    public void setUsernamePrivilegeTimeout(long l2) {
        this.usernamePrivilegeTimeout = l2;
    }

    public long getDigitalPrivilegeTimeout() {
        return this.digitalPrivilegeTimeout;
    }

    public void setDigitalPrivilegeTimeout(long l2) {
        this.digitalPrivilegeTimeout = l2;
    }

    public boolean isExportFullImg4Excel() {
        return this.exportFullImg4Excel;
    }

    public void setExportFullImg4Excel(boolean bl) {
        this.exportFullImg4Excel = bl;
    }

    public float getExcelAdjustHeight() {
        return this.excelAdjustHeight;
    }

    public void setExcelAdjustHeight(float f2) {
        this.excelAdjustHeight = f2;
    }

    public double getExcelAdjustWidth() {
        return this.excelAdjustWidth;
    }

    public void setExcelAdjustWidth(double d2) {
        this.excelAdjustWidth = d2;
    }

    public boolean isImportDoubleDir() {
        return this.importDoubleDir;
    }

    public void setImportDoubleDir(boolean bl) {
        this.importDoubleDir = bl;
    }

    public boolean isCheckWidget() {
        return this.checkWidget;
    }

    public void setCheckWidget(boolean bl) {
        this.checkWidget = bl;
    }

    public boolean isPrintWidget() {
        return this.printWidget;
    }

    public void setPrintWidget(boolean bl) {
        this.printWidget = bl;
    }

    public String getReportPrefix() {
        return this.reportPrefix;
    }

    public void setReportPrefix(String string) {
        this.reportPrefix = string;
    }

    public boolean isReadDialectAgain() {
        return this.readDialectAgain;
    }

    public void setReadDialectAgain(boolean bl) {
        this.readDialectAgain = bl;
    }

    public String fileName() {
        return "customconfig.xml";
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals(PRIVILEGE_TIMEOUT_XML, string)) {
                this.setDigitalPrivilegeTimeout(xMLableReader.getAttrAsLong(DIGITAL_PRIVILEGE_XML, 90000L));
                this.setUsernamePrivilegeTimeout(xMLableReader.getAttrAsLong(USERNAME_PRIVILEGE_XML, 1200000L));
            } else if (ComparatorUtils.equals(EXPORT_FULL_IMAGE, string)) {
                this.setExportFullImg4Excel(xMLableReader.getAttrAsBoolean("excel", false));
            } else if (ComparatorUtils.equals(EXCEL_ADJUST, string)) {
                this.setExcelAdjustHeight(xMLableReader.getAttrAsFloat("height", 20.1f));
                this.setExcelAdjustWidth(xMLableReader.getAttrAsDouble("width", 34.742));
            } else if (string.equals("PrintWidget")) {
                this.setPrintWidget(xMLableReader.getAttrAsBoolean("print", false));
            } else if (string.equals("CheckWidget")) {
                this.setCheckWidget(xMLableReader.getAttrAsBoolean("check", true));
            } else if (string.equals("ImportDoubleDir")) {
                this.setImportDoubleDir(xMLableReader.getAttrAsBoolean("doubledir", false));
            } else if (ComparatorUtils.equals(REPORT_PREFIX, string)) {
                String string2 = xMLableReader.getAttrAsString("prefix", "");
                if (!StringUtils.isEmpty(string2 = string2.replaceAll("\\\\", "/")) && !string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                this.setReportPrefix(string2);
            } else if ("Dialect".equals(string)) {
                this.setReadDialectAgain(xMLableReader.getAttrAsBoolean("readDialectAgain", false));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (!this.isCheckWidget()) {
            xMLPrintWriter.startTAG("CheckWidget").attr("check", false).end();
        }
        if (this.isImportDoubleDir()) {
            xMLPrintWriter.startTAG("ImportDoubleDir").attr("doubledir", true).end();
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CustomConfigManager.envChanged();
            }
        });
    }
}

