/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.cache.CacheConfiguration;
import com.fr.cache.CacheEventAdapter;
import com.fr.cache.CacheException;
import com.fr.cache.CacheProvider;
import com.fr.cache.FRCache;
import com.fr.cache.MemoryStore;
import com.fr.cache.Status;
import com.fr.cache.Unity;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.stable.Consts;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.InputStream;

public class CacheManager
extends XMLFileManager
implements CacheProvider {
    private static CacheManager cacheManager = null;
    private File cacheDirectory = null;
    private int maxMemSize = 0x400000;
    private CacheConfiguration dbConfig = new CacheConfiguration();
    private CacheConfiguration cptConfig = new CacheConfiguration();
    private Thread shutdownHook;
    private Status status = Status.STATUS_ALIVE;
    private FRCache db_cache;
    private boolean alwaysReloadTpl = true;

    public static synchronized CacheManager getInstance() {
        if (cacheManager == null) {
            cacheManager = new CacheManager();
            cacheManager.readXMLFile();
        }
        return cacheManager;
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        CacheManager cacheManager = new CacheManager();
        XMLTools.readInputStreamXML(cacheManager, inputStream);
        CacheManager.cacheManager = cacheManager;
        GeneralContext.getEnvProvider().writeResource(CacheManager.cacheManager);
    }

    private static synchronized void envChanged() {
        cacheManager = null;
    }

    private CacheManager() {
        this.addShutdownHookIfRequired();
        this.db_cache = this.createDBCache();
    }

    public String fileName() {
        return "cache.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDBDataModel get(Connection connection, String string, long l2) {
        AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)this.db_cache.getObject(new DBKey(connection, string));
        if (abstractDBDataModel != null && abstractDBDataModel.isCheckRowOver()) {
            FRLogger.getLogger().info(Inter.getLocText("getDataFromCache") + string);
        } else {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                FRLogger.getLogger().info("SQL: " + string);
                abstractDBDataModel = DBTableData.createCacheableDBResultSet(connection, string, l2);
                this.db_cache.put(new DBKey(connection, string), abstractDBDataModel);
            }
        }
        return abstractDBDataModel;
    }

    public synchronized Object[] getProcedureDataModel(Connection connection, String string, Object object, CalculatorProvider calculatorProvider) {
        Object[] objectArray = (ProcedureDataModel[])this.db_cache.getObject(new DBKey(connection, string));
        if (objectArray != null && objectArray.length > 0) {
            FRLogger.getLogger().info(Inter.getLocText("getDataFromCache") + string);
            return objectArray;
        }
        FRLogger.getLogger().info("SQL: " + string);
        objectArray = ((StoreProcedure)object).creatCacheableDataModel(calculatorProvider);
        this.db_cache.put(new DBKey(connection, string), objectArray);
        return objectArray;
    }

    public File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = this.getApplicationDefaultCacheFolder();
            try {
                StableUtils.mkdirs(this.cacheDirectory);
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't create or access the directory: " + this.cacheDirectory + ", please check your Permissions.", exception);
            }
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    private void setCacheDirectory(File file) {
        this.cacheDirectory = file;
    }

    public int getMaxMemSize() {
        return this.maxMemSize;
    }

    public void setMaxMemSize(int n2) {
        this.maxMemSize = n2;
    }

    public CacheConfiguration getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(CacheConfiguration cacheConfiguration) {
        this.dbConfig = cacheConfiguration;
    }

    public CacheConfiguration getCptConfig() {
        return this.cptConfig;
    }

    public void setAlwaysReloadTpl(boolean bl) {
        this.alwaysReloadTpl = bl;
    }

    public boolean isAlwaysReloadTpl() {
        return this.alwaysReloadTpl;
    }

    public FRCache createDBCache() {
        final FRCache fRCache = new FRCache(this.dbConfig);
        fRCache.getCacheEventNotificationService().registerListener(new CacheEventAdapter(){

            public void notifyElementRemoved(FRCache fRCache2, Unity unity) throws CacheException {
                Object object = unity.getObjectValue();
                if (object instanceof AbstractDBDataModel) {
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }

            public void notifyElementExpired(FRCache fRCache2, Unity unity) {
                Object object = unity.getObjectValue();
                if (object instanceof AbstractDBDataModel) {
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }

            public void dispose() {
                MemoryStore memoryStore = fRCache.getStore();
                Object[] objectArray = memoryStore.getKeyArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Unity unity = memoryStore.get(objectArray[i2]);
                    Object object = unity.getObjectValue();
                    if (!(object instanceof AbstractDBDataModel)) continue;
                    AbstractDBDataModel abstractDBDataModel = (AbstractDBDataModel)object;
                    try {
                        abstractDBDataModel.tryDestroy();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new CacheException(exception.getMessage(), exception);
                    }
                }
            }
        });
        return fRCache;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("Basic".equals(string)) {
                String string3 = xMLableReader.getAttrAsString("cacheDirectory", null);
                if (string3 != null) {
                    this.setCacheDirectory(new File(string3));
                }
                if ((string3 = xMLableReader.getAttrAsString("maxMemSize", null)) != null) {
                    this.setMaxMemSize(Integer.parseInt(string3));
                }
            } else if ("DBConfig".equals(string)) {
                if (this.dbConfig == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getDbConfig());
                }
            } else if ("AlwaysReloadTpl".equals(string)) {
                this.setAlwaysReloadTpl(Boolean.valueOf(xMLableReader.getElementValue()));
            } else if ("CPTConfig".equals(string)) {
                if (this.getCptConfig() == null) {
                    CacheConfiguration cacheConfiguration = new CacheConfiguration();
                    xMLableReader.readXMLObject(cacheConfiguration);
                    this.setDbConfig(cacheConfiguration);
                } else {
                    xMLableReader.readXMLObject(this.getCptConfig());
                }
            }
        }
    }

    private File getApplicationDefaultCacheFolder() {
        return new File(Consts.getEnvHome(), "cache");
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CacheParameters");
        xMLPrintWriter.startTAG("Basic");
        if (!this.getApplicationDefaultCacheFolder().equals(this.cacheDirectory)) {
            xMLPrintWriter.attr("cacheDirectory", this.getCacheDirectory().getAbsolutePath());
        }
        xMLPrintWriter.attr("maxMemSize", this.getMaxMemSize());
        xMLPrintWriter.end();
        if (this.dbConfig != null) {
            xMLPrintWriter.startTAG("DBConfig");
            this.dbConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.cptConfig != null) {
            xMLPrintWriter.startTAG("CPTConfig");
            this.cptConfig.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("AlwaysReloadTpl").textNode(String.valueOf(this.isAlwaysReloadTpl())).end();
        xMLPrintWriter.end();
    }

    private void addShutdownHookIfRequired() {
        boolean bl = true;
        if (!bl) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (ComparatorUtils.equals(CacheManager.this.status, Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        this.shutdownHook = thread;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                FRLogger.getLogger().error("IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", illegalStateException);
            }
            this.shutdownHook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (ComparatorUtils.equals(this.status, Status.STATUS_SHUTDOWN)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.db_cache != null) {
                this.db_cache.dispose();
            }
            StableUtils.deleteFile(this.cacheDirectory);
            this.status = Status.STATUS_SHUTDOWN;
            this.removeShutdownHook();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CacheManager.envChanged();
            }
        });
    }

    private static interface PoolKey {
    }

    private static class DBKey
    implements PoolKey {
        private Connection database;
        private String query;

        public DBKey(Connection connection, String string) {
            this.database = connection;
            this.query = string;
        }

        public int hashCode() {
            return this.database.hashCode() + this.query.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof DBKey && ComparatorUtils.equals(((DBKey)object).database, this.database) && ComparatorUtils.equals(((DBKey)object).query, this.query);
        }
    }
}

