/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.xmla;

import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLADatabaseConnection
implements Connection {
    public static final String XMLA_TAG = "XMLADatabaseAttr";
    public static final String XMLA_DRIVER = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    private static final long serialVersionUID = 1L;
    private String driver = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    private String url = "";
    private String user = "";
    private String password = "";
    private String catalog = "";
    private String xmlaDatabaseName = "";

    public XMLADatabaseConnection() {
    }

    public XMLADatabaseConnection(String string, String string2, String string3, String string4, String string5) {
        this.setURL(string);
        this.setUser(string2);
        this.setPassword(string3);
        this.setCatalog(string4);
        this.setXmlaDatabaseName(string5);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && XMLA_TAG.equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttrAsString("url", null);
            if (string != null) {
                this.setURL(string);
            }
            if ((string = xMLableReader.getAttrAsString("user", null)) != null) {
                this.setUser(string);
            }
            if ((string = xMLableReader.getAttrAsString("password", null)) != null) {
                this.setPassword(CodeUtils.passwordDecode(string));
            }
            if ((string = xMLableReader.getAttrAsString("catalog", null)) != null) {
                this.setCatalog(string);
            }
            if ((string = xMLableReader.getAttrAsString("xmlaDatabaseName", null)) != null) {
                this.setXmlaDatabaseName(string);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XMLA_TAG).attr("url", this.url).attr("user", this.user).attr("password", CodeUtils.passwordEncode(this.password)).attr("catalog", this.catalog).attr("xmlaDatabaseName", this.xmlaDatabaseName);
        xMLPrintWriter.end();
    }

    @Override
    public void setOriginalCharsetName(String string) {
    }

    @Override
    public String getNewCharsetName() {
        return null;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setNewCharsetName(String string) {
    }

    @Override
    public void testConnection() throws Exception {
        OlapWrapper olapWrapper = (OlapWrapper)this.createConnection();
        OlapConnection olapConnection = (OlapConnection)olapWrapper.unwrap(OlapConnection.class);
        olapConnection.getOlapSchema().getCubes();
    }

    @Override
    public java.sql.Connection createConnection() throws Exception {
        Class.forName(this.driver);
        StringBuilder stringBuilder = new StringBuilder(this.url);
        String string = StringUtils.isBlank(this.catalog) ? this.url : stringBuilder.append(";Catalog=").append(this.catalog).toString();
        return DriverManager.getConnection(string, this.user, this.password);
    }

    @Override
    public boolean isDatabaseConnection() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getOriginalCharsetName() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof XMLADatabaseConnection)) {
            return false;
        }
        XMLADatabaseConnection xMLADatabaseConnection = (XMLADatabaseConnection)object;
        return ComparatorUtils.equals(this.driver, xMLADatabaseConnection.driver) && ComparatorUtils.equals(this.url, xMLADatabaseConnection.url) && ComparatorUtils.equals(this.user, xMLADatabaseConnection.user) && ComparatorUtils.equals(this.password, xMLADatabaseConnection.password);
    }

    public OlapConnection getOlapConnection() throws Exception {
        java.sql.Connection connection = this.createConnection();
        OlapWrapper olapWrapper = (OlapWrapper)connection;
        return (OlapConnection)olapWrapper.unwrap(OlapConnection.class);
    }

    public String[] getAllCatalog() throws Exception {
        OlapConnection olapConnection = this.getOlapConnection();
        NamedList namedList = olapConnection.getOlapCatalogs();
        int n2 = namedList.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = ((Catalog)namedList.get(i2)).getName();
        }
        return stringArray;
    }

    public String[] getAllCubes() throws Exception {
        if (StringUtils.isBlank(this.getCatalog())) {
            return new String[0];
        }
        OlapConnection olapConnection = this.getOlapConnection();
        NamedList namedList = olapConnection.getOlapSchema().getCubes();
        int n2 = namedList.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = ((Cube)namedList.get(i2)).getName();
        }
        return stringArray;
    }

    public String[] getAllMeasures(String string) {
        if (StringUtils.isBlank(string)) {
            return new String[0];
        }
        try {
            OlapConnection olapConnection = this.getOlapConnection();
            List list = ((Cube)olapConnection.getOlapSchema().getCubes().get(string)).getMeasures();
            int n2 = list.size();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = ((Measure)list.get(i2)).getUniqueName();
            }
            return stringArray;
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public String[][] getAllDimensions(String string) {
        if (StringUtils.isBlank(string)) {
            return new String[0][0];
        }
        String[][] stringArray = new String[3][];
        try {
            OlapConnection olapConnection = this.getOlapConnection();
            NamedList namedList = ((Cube)olapConnection.getOlapSchema().getCubes().get(string)).getDimensions();
            int n2 = namedList.size();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.ensureCapacity(n2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = ((Dimension)namedList.get(i2)).getName();
                if (ComparatorUtils.equals(string2, "Measures") || this.dmIsContainMeasure(string2, string)) continue;
                arrayList.add(((Dimension)namedList.get(i2)).getUniqueName());
                ArrayList<String> arrayList4 = this.getHierarchy((Dimension)namedList.get(i2));
                arrayList2.addAll(arrayList4);
                NamedList namedList2 = ((Dimension)namedList.get(i2)).getHierarchies();
                int n3 = namedList2.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    ArrayList<String> arrayList5 = this.getLevels((Hierarchy)namedList2.get(i3));
                    arrayList3.addAll(arrayList5);
                }
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            String[] stringArray3 = arrayList2.toArray(new String[arrayList2.size()]);
            String[] stringArray4 = arrayList3.toArray(new String[arrayList3.size()]);
            stringArray[0] = stringArray2;
            stringArray[1] = stringArray3;
            stringArray[2] = stringArray4;
            arrayList2 = null;
            arrayList3 = null;
            arrayList = null;
        }
        catch (Exception exception) {
            return new String[0][0];
        }
        return stringArray;
    }

    private boolean dmIsContainMeasure(String string, String string2) {
        String[] stringArray = this.getAllMeasures(string2);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(stringArray[i2], string)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> getHierarchy(Dimension dimension) {
        NamedList namedList = dimension.getHierarchies();
        int n2 = namedList.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.ensureCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(((Hierarchy)namedList.get(i2)).getUniqueName());
        }
        return arrayList;
    }

    private ArrayList<String> getLevels(Hierarchy hierarchy) {
        NamedList namedList = hierarchy.getLevels();
        int n2 = namedList.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.ensureCapacity(n2);
        String string = hierarchy.getName();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = ((Level)namedList.get(i2)).getName();
            if (ComparatorUtils.equals(string, string2) || ComparatorUtils.equals(string2, "(All)")) continue;
            arrayList.add(((Level)namedList.get(i2)).getUniqueName());
        }
        return arrayList;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getXmlaDatabaseName() {
        return this.xmlaDatabaseName;
    }

    public void setXmlaDatabaseName(String string) {
        this.xmlaDatabaseName = string;
    }

    @Override
    public boolean isXMLAConnection() {
        return true;
    }

    @Override
    public boolean isFineBIConnection() {
        return false;
    }
}

