/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.xmla;

import com.fr.data.AbstractDataModel;
import com.fr.data.impl.multidimensional.xmla.XMLADatabaseConnection;
import com.fr.file.DatasourceManager;
import com.fr.general.data.TableDataException;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.Position;
import org.olap4j.metadata.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLADataModel
extends AbstractDataModel {
    private String connectionName;
    private String mdxStatement;
    private boolean isCustomMdx = false;
    private List<Object[]> valueList = new ArrayList<Object[]>();
    private List<String> colList = null;
    private int columnNum = 0;
    private int axisRows = 1;
    private int axisColumn = 0;

    public XMLADataModel() {
    }

    public XMLADataModel(String string, String string2, boolean bl) {
        this.setConnectionName(string);
        this.setMdxStatement(string2);
        this.setCustomMdx(bl);
    }

    @Override
    public int getColumnCount() throws TableDataException {
        this.initData();
        return this.columnNum;
    }

    @Override
    public String getColumnName(int n2) throws TableDataException {
        this.initData();
        if (n2 >= this.columnNum) {
            return "";
        }
        return this.colList.get(n2);
    }

    @Override
    public int getRowCount() throws TableDataException {
        this.initData();
        return this.valueList.size();
    }

    @Override
    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        if (n3 >= this.columnNum) {
            return null;
        }
        return this.valueList.get(n2)[n3];
    }

    @Override
    public void release() throws Exception {
    }

    public OlapConnection getConnection(String string) throws Exception {
        XMLADatabaseConnection xMLADatabaseConnection = (XMLADatabaseConnection)DatasourceManager.getInstance().getConnection(string);
        return xMLADatabaseConnection.getOlapConnection();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getMdxStatement() {
        return this.mdxStatement;
    }

    public void setMdxStatement(String string) {
        this.mdxStatement = string;
    }

    public boolean isCustomMdx() {
        return this.isCustomMdx;
    }

    public void setCustomMdx(boolean bl) {
        this.isCustomMdx = bl;
    }

    protected void dealColumnName(List<String> list, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            list.add(i2, stringArray[i2]);
        }
    }

    protected List<Object[]> getValueList() {
        return this.valueList;
    }

    protected void clearValueList() {
        this.valueList.clear();
        this.valueList = null;
    }

    protected List<String> getColList() {
        return this.colList;
    }

    protected abstract void initData();

    protected void dealValueList(CellSet cellSet) {
        int n2 = ((Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0)).getMembers().size();
        int n3 = ((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositionCount();
        this.colList = this.getColAxeNames(cellSet, this.axisColumn);
        String[] stringArray = this.getRowAxeNames(cellSet, n2);
        this.dealColumnName(this.colList, stringArray);
        this.columnNum = n2 + n3;
        List<String[]> list = this.getRowAxeDatas(cellSet, n2);
        for (Position position : ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions()) {
            Object[] objectArray = new Object[this.columnNum];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = list.get(position.getOrdinal())[i2];
            }
            for (Position position2 : (CellSetAxis)cellSet.getAxes().get(this.axisColumn)) {
                objectArray[position2.getOrdinal() + n2] = cellSet.getCell(new Position[]{position2, position}).getValue();
            }
            this.valueList.add(objectArray);
        }
    }

    protected void dealValueListWithCustom(CellSet cellSet) {
        String[] stringArray = this.getDimensionNames(cellSet, this.axisRows);
        String[] stringArray2 = this.getDimensionNames(cellSet, this.axisColumn);
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        this.dealColumnName(this.colList, stringArray);
        this.columnNum = n2 + n3;
        Position position = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(0);
        Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0);
        boolean bl = this.isRowMemberIncludeMeasure(cellSet, n2, n3);
        boolean bl2 = !bl && position.getMembers().size() > 1;
        boolean bl3 = bl && position2.getMembers().size() == 1;
        for (Position position3 : ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions()) {
            Object[] objectArray = new Object[this.columnNum];
            if (bl2) {
                if (this.isMeasureFirst(((Member)position.getMembers().get(0)).getUniqueName())) {
                    this.dealValuelistColAxisIncludeDm(position3, cellSet, n2);
                } else {
                    this.dealValueIncludeDmFirst(position3, cellSet, n2);
                }
            } else {
                for (Position position4 : ((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions()) {
                    if (bl) {
                        if (bl3) {
                            this.dealValuelistRowAxisIncludeOnlyMe(position4, cellSet, n2);
                            continue;
                        }
                        if (this.isMeasureFirst(((Member)position2.getMembers().get(0)).getUniqueName())) {
                            this.dealValuelistRowAxisIncludMeAndDm(position4, cellSet, n2);
                            continue;
                        }
                        this.dealValueIncludeMeAndDmFirst(position4, cellSet, n2);
                        continue;
                    }
                    Cell cell = cellSet.getCell(new Position[]{position4, position3});
                    objectArray[position4.getOrdinal() + n2] = cell.getValue();
                }
            }
            if (bl) break;
            if (bl2) continue;
            for (int i2 = 0; i2 < position3.getMembers().size(); ++i2) {
                objectArray[i2] = ((Member)position3.getMembers().get(i2)).getName();
            }
            this.valueList.add(objectArray);
        }
    }

    private void dealValuelistRowAxisIncludeOnlyMe(Position position, CellSet cellSet, int n2) {
        Object[] objectArray = new Object[this.columnNum];
        for (int i2 = 0; i2 < position.getMembers().size(); ++i2) {
            objectArray[i2 + n2] = ((Member)position.getMembers().get(i2)).getName();
        }
        for (Position position2 : ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions()) {
            Cell cell = cellSet.getCell(new Position[]{position, position2});
            objectArray[position2.getOrdinal()] = cell.getValue();
        }
        this.valueList.add(objectArray);
    }

    private void dealValuelistRowAxisIncludMeAndDm(Position position, CellSet cellSet, int n2) {
        int n3 = ((Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0)).getMembers().size() - 1;
        int n4 = Math.max(1, ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositionCount() / (n2 - n3));
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            Object[] objectArray = new Object[this.columnNum];
            for (int i3 = 0; i3 < position.getMembers().size(); ++i3) {
                objectArray[i3 + n2] = ((Member)position.getMembers().get(i3)).getName();
            }
            Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(i2);
            Cell cell = cellSet.getCell(new Position[]{position, position2});
            for (n5 = 0; n5 < n3 + 1; ++n5) {
                String string = ((Member)position2.getMembers().get(n5)).getUniqueName();
                objectArray[n5] = string.split("\\.").length > 2 ? ((Member)position2.getMembers().get(n5)).getName() : cell.getValue();
            }
            for (n5 = 1; n5 < n2 - n3; ++n5) {
                int n6 = i2 + n4 * n5;
                Position position3 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(n6);
                Cell cell2 = cellSet.getCell(new Position[]{position, position3});
                objectArray[n5 + n3] = cell2.getValue();
            }
            this.valueList.add(objectArray);
        }
    }

    private void dealValueIncludeMeAndDmFirst(Position position, CellSet cellSet, int n2) {
        int n3 = ((Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0)).getMembers().size() - 1;
        for (int i2 = 0; i2 < ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositionCount(); i2 += n2 - n3) {
            int n4;
            Object[] objectArray = new Object[this.columnNum];
            for (int i3 = 0; i3 < position.getMembers().size(); ++i3) {
                objectArray[i3 + n2] = ((Member)position.getMembers().get(i3)).getName();
            }
            Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(i2);
            Cell cell = cellSet.getCell(new Position[]{position, position2});
            for (n4 = 0; n4 < n3; ++n4) {
                objectArray[n4] = ((Member)position2.getMembers().get(n4)).getName();
            }
            objectArray[n3] = cell.getValue();
            for (n4 = 1; n4 < n2 - n3; ++n4) {
                Position position3 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(i2 + n4);
                Cell cell2 = cellSet.getCell(new Position[]{position, position3});
                objectArray[n3 + n4] = cell2.getValue();
            }
            this.valueList.add(objectArray);
        }
    }

    private void dealValuelistColAxisIncludeDm(Position position, CellSet cellSet, int n2) {
        int n3 = this.columnNum - n2 - ((Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(0)).getMembers().size() + 1;
        int n4 = Math.max(1, ((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositionCount() / n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            Object[] objectArray = new Object[this.columnNum];
            for (int i3 = 0; i3 < position.getMembers().size(); ++i3) {
                objectArray[i3] = ((Member)position.getMembers().get(i3)).getName();
            }
            Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(i2);
            Cell cell = cellSet.getCell(new Position[]{position2, position});
            for (n5 = 0; n5 < position2.getMembers().size(); ++n5) {
                String string = ((Member)position2.getMembers().get(n5)).getUniqueName();
                objectArray[n5 + n2] = string.split("\\.").length > 2 ? ((Member)position2.getMembers().get(n5)).getName() : cell.getValue();
            }
            for (n5 = 1; n5 < n3; ++n5) {
                int n6 = i2 + n4 * n5;
                Position position3 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(n6);
                Cell cell2 = cellSet.getCell(new Position[]{position3, position});
                objectArray[n2 + position2.getMembers().size() + n5 - 1] = cell2.getValue();
            }
            this.valueList.add(objectArray);
        }
    }

    private void dealValueIncludeDmFirst(Position position, CellSet cellSet, int n2) {
        int n3 = this.columnNum - n2 - ((Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(0)).getMembers().size() + 1;
        for (int i2 = 0; i2 < ((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositionCount(); i2 += n3) {
            int n4;
            Object[] objectArray = new Object[this.columnNum];
            for (int i3 = 0; i3 < position.getMembers().size(); ++i3) {
                objectArray[i3] = ((Member)position.getMembers().get(i3)).getName();
            }
            Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(i2);
            Cell cell = cellSet.getCell(new Position[]{position2, position});
            for (n4 = 0; n4 < this.columnNum - n2 - n3; ++n4) {
                objectArray[n2 + n4] = ((Member)position2.getMembers().get(n4)).getName();
            }
            objectArray[n2 + position2.getMembers().size() - 1] = cell.getValue();
            for (n4 = 1; n4 < n3; ++n4) {
                Position position3 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(i2 + n4);
                Cell cell2 = cellSet.getCell(new Position[]{position3, position});
                objectArray[n2 + position2.getMembers().size() - 1 + n4] = cell2.getValue();
            }
            this.valueList.add(objectArray);
        }
    }

    private boolean isMeasureFirst(String string) {
        return string.split("\\.").length <= 2;
    }

    private boolean isRowMemberIncludeMeasure(CellSet cellSet, int n2, int n3) {
        Position position = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0);
        Position position2 = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisColumn)).getPositions().get(0);
        String string = ((Member)position.getMembers().get(0)).getUniqueName();
        boolean bl = position.getMembers().size() < n2 && position2.getMembers().size() == n3;
        return position.getMembers().size() == 1 && string.split("\\.").length <= 2 || position.getMembers().size() > 1 && bl;
    }

    private String[] getDimensionNames(CellSet cellSet, int n2) {
        List list = ((CellSetAxis)cellSet.getAxes().get(n2)).getPositions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Position position : list) {
            for (int i2 = 0; i2 < position.getMembers().size(); ++i2) {
                String string = this.getDimensionName(((Member)position.getMembers().get(i2)).getUniqueName());
                if (arrayList.indexOf(string) != -1) continue;
                arrayList.add(string);
            }
        }
        if (n2 == 0) {
            this.colList = arrayList;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List<String> getColAxeNames(CellSet cellSet, int n2) {
        List list = ((CellSetAxis)cellSet.getAxes().get(n2)).getPositions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Position position : list) {
            arrayList.add(((Member)position.getMembers().get(0)).getName());
        }
        return arrayList;
    }

    protected List<String[]> getRowAxeDatas(CellSet cellSet, int n2) {
        List list = ((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (Position position : list) {
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = i2 < position.getMembers().size() ? ((Member)position.getMembers().get(i2)).getName() : "";
            }
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    protected abstract String[] getRowAxeNames(CellSet var1, int var2);

    protected abstract String getDimensionName(String var1);
}

