/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.finebi;

import com.fr.data.AbstractDataModel;
import com.fr.data.condition.XMLATreeNodeField;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.multidimensional.finebi.FineBiCubeDatabaseConnection;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import com.fr.general.http.HttpClient;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;

public class FineBiCubeDataModel
extends AbstractDataModel {
    private EmbeddedTableData data = null;
    private ParameterProvider[] parameters;
    private String connectionName = null;
    private String dimensions = null;
    private String targets = null;
    private XMLATreeNodeField fields = null;
    private int page = -1;
    private String packageName = null;

    public FineBiCubeDataModel(String string, String string2, String string3, XMLATreeNodeField xMLATreeNodeField, String string4, ParameterProvider[] parameterProviderArray) {
        this.packageName = string;
        this.dimensions = string2;
        this.targets = string3;
        this.fields = xMLATreeNodeField;
        this.connectionName = string4;
        this.parameters = parameterProviderArray;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n2) {
        this.page = n2;
    }

    public int getColumnCount() throws TableDataException {
        this.initData();
        return this.data.getColumnCount();
    }

    public String getColumnName(int n2) throws TableDataException {
        this.initData();
        if (n2 >= this.data.getColumnCount()) {
            return null;
        }
        return this.data.getColumnName(n2);
    }

    public int getRowCount() throws TableDataException {
        this.initData();
        return this.data.getRowCount();
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        List list = (List)this.data.getRowData().get(n2);
        if (n3 < 0 || n3 >= list.size()) {
            return null;
        }
        Object e2 = list.get(n3);
        if (e2 == null) {
            return Primitive.NULL;
        }
        return e2;
    }

    public void release() throws Exception {
    }

    public FineBiCubeDatabaseConnection getBiCubeConnection(String string) {
        return (FineBiCubeDatabaseConnection)DatasourceManager.getInstance().getConnection(string);
    }

    private void initData() {
        boolean bl;
        boolean bl2 = bl = this.targets == null || this.dimensions == null;
        if (this.data != null || bl) {
            return;
        }
        FineBiCubeDatabaseConnection fineBiCubeDatabaseConnection = this.getBiCubeConnection(this.connectionName);
        try {
            fineBiCubeDatabaseConnection.createConnection();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        try {
            Object object;
            JSONObject jSONObject;
            JSONArray jSONArray = fineBiCubeDatabaseConnection.createTargets(this.targets, this.packageName);
            JSONArray jSONArray2 = fineBiCubeDatabaseConnection.getAllDimensions(this.packageName, this.targets);
            JSONArray jSONArray3 = fineBiCubeDatabaseConnection.createDimensions(this.dimensions, jSONArray2);
            if (this.fields == null) {
                jSONObject = new JSONObject();
            } else {
                object = fineBiCubeDatabaseConnection.getAllFields(this.packageName);
                jSONObject = fineBiCubeDatabaseConnection.createSelectConditions(this.fields, (JSONArray)object, this.parameters);
            }
            object = new HashMap();
            ((HashMap)object).put("op", "fr_bi_third");
            ((HashMap)object).put("fsusername", fineBiCubeDatabaseConnection.getUser());
            ((HashMap)object).put("fspassword", fineBiCubeDatabaseConnection.getPassword());
            ((HashMap)object).put("cmd", "load_data");
            ((HashMap)object).put("sessionID", fineBiCubeDatabaseConnection.getSessionID());
            ((HashMap)object).put("dimensions", jSONArray3.toString());
            ((HashMap)object).put("targets", jSONArray.toString());
            ((HashMap)object).put("condition", jSONObject.toString());
            ((HashMap)object).put("page", String.valueOf(this.page));
            HttpClient httpClient = new HttpClient(fineBiCubeDatabaseConnection.getPath(), (HashMap<String, String>)object);
            byte[] byArray = httpClient.getResponseBytes();
            String string = new String(byArray);
            if (ComparatorUtils.equals(string, "\u201cERROR_LOGIN") || ComparatorUtils.equals(string, "ERROR_SESSION_TIMEOUT")) {
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.data = (EmbeddedTableData)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }
}

