/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.impl.AbstractLayerDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.TableDataException;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public final class LayerPageQueryDBDataModel
extends AbstractLayerDBDataModel {
    private static final long serialVersionUID = 1L;
    public static final String STARTROW_IDENTIFIER = "fr_startrow";
    public static final String PAGESIZE_IDENTIFIER = "fr_pagesize";
    public static final String PAGE_NUMBER_IDENTIFIER = "fr_pagenumber";
    public static final String ROW_COUNT_IDENTIFIER = "fr_rowcount";
    private transient int startRow;
    private int pageSize;
    protected String pageQuery;
    private boolean bePaged = false;
    private String originalQuery;
    private Parameter[] parameters;

    public LayerPageQueryDBDataModel(Connection connection, String string, String string2, Parameter[] parameterArray, int n2) {
        super(connection, string);
        this.originalQuery = string;
        this.pageSize = n2;
        this.pageQuery = string2;
        this.parameters = parameterArray;
    }

    protected int hasRow_rowIndex2Get(int n2) {
        return n2 - this.startRow;
    }

    protected boolean hasRow_3rd_condition(int n2) {
        return super.hasRow_3rd_condition(n2) || !this.bePaged || n2 >= this.pageSize;
    }

    protected void hasRow_3rd_condition_action(int n2) throws TableDataException {
        try {
            this.releaseConnection();
        }
        catch (SQLException sQLException) {
            this.connection = null;
            this.statement = null;
            this.resultSet = null;
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        this.createPageQuery(n2);
        this.setCheckRowOverState(false);
        this.bePaged = true;
    }

    protected boolean hasRow_isLastRow(int n2) {
        return n2 == this.pageSize - 1 || n2 + this.startRow == this.shortcutRowCount - 1;
    }

    protected void hasRow_after_iterate_resultset(int n2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean createPageQuery(int n2) {
        if (StringUtils.isBlank(this.pageQuery)) {
            if (this.dialect.supportsLimitOffset()) {
                this.sql = this.dialect.getLimitString(this.originalQuery, n2, this.pageSize);
                this.startRow = n2;
                return true;
            }
            this.sql = this.originalQuery;
            FRLogger.getLogger().error(Inter.getLocText("LayerPageReport_PageQuery_Unsupport_Msg1") + "!");
            return false;
        }
        this.startRow = n2;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (!ArrayUtils.isEmpty(this.parameters)) {
            arrayList.addAll(Arrays.asList(this.parameters));
        }
        arrayList.add(new Parameter(STARTROW_IDENTIFIER, new Integer(this.startRow)));
        arrayList.add(new Parameter(PAGESIZE_IDENTIFIER, new Integer(this.pageSize)));
        arrayList.add(new Parameter(PAGE_NUMBER_IDENTIFIER, new Integer(this.startRow / this.pageSize + 1)));
        arrayList.add(new Parameter(ROW_COUNT_IDENTIFIER, new Integer(this.shortcutRowCount)));
        this.sql = ParameterHelper.analyze4Templatee(this.pageQuery, arrayList.toArray(new Parameter[0]));
        return true;
    }
}

